/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.item;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.wildcard.buddycards.battles.game.BattleAbility;
import com.wildcard.buddycards.battles.game.BattleEvent;
import com.wildcard.buddycards.core.BuddycardSet;
import com.wildcard.buddycards.core.BuddycardsAPI;
import com.wildcard.buddycards.registries.BuddycardsItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BuddycardItem
extends Item {
    protected final BuddycardSet SET;
    protected final int CARD_NUMBER;
    protected final Rarity RARITY;
    protected final BuddycardsItems.BuddycardRequirement REQUIREMENT;
    protected final int COST;
    protected final int POWER;
    protected final ImmutableListMultimap<BattleEvent, BattleAbility> ABILITIES;

    public BuddycardItem(BuddycardsItems.BuddycardRequirement shouldLoad, BuddycardSet set, int cardNumber, Rarity rarity, Item.Properties properties, int cost, int power, ListMultimap<BattleEvent, BattleAbility> abilities) {
        super(properties);
        this.SET = set;
        this.CARD_NUMBER = cardNumber;
        this.RARITY = rarity;
        this.REQUIREMENT = shouldLoad;
        this.COST = cost;
        this.POWER = power;
        this.ABILITIES = ImmutableListMultimap.copyOf(abilities);
        BuddycardsAPI.registerCard(this);
    }

    @Deprecated
    public BuddycardItem(BuddycardsItems.BuddycardRequirement shouldLoad, BuddycardSet set, int cardNumber, Rarity rarity, Item.Properties properties) {
        super(properties);
        this.SET = set;
        this.CARD_NUMBER = cardNumber;
        this.RARITY = rarity;
        this.REQUIREMENT = shouldLoad;
        this.COST = 2;
        this.POWER = 2;
        this.ABILITIES = ImmutableListMultimap.of();
        BuddycardsAPI.registerCard(this);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (this.ABILITIES.size() > 0) {
            tooltip.add((Component)new TextComponent("" + this.COST).m_7220_((Component)new TranslatableComponent("item.buddycards.buddycard.cost")).m_7220_((Component)new TranslatableComponent("item.buddycards.buddycard.number_separator")).m_130946_("" + this.POWER).m_7220_((Component)new TranslatableComponent("item.buddycards.buddycard.power")));
            for (BattleAbility ability : this.ABILITIES.values()) {
                tooltip.add((Component)new TranslatableComponent("battles.ability.buddycards." + ability.name).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)new TranslatableComponent("battles.ability.buddycards." + ability.name + ".desc").m_130940_(ChatFormatting.DARK_GRAY));
            }
        } else {
            tooltip.add((Component)new TranslatableComponent("item.buddycards.buddycard.unimplemented").m_130940_(ChatFormatting.DARK_RED));
        }
        tooltip.add((Component)new TranslatableComponent(this.m_5524_() + ".tooltip").m_130940_(ChatFormatting.ITALIC));
        TranslatableComponent cn = new TranslatableComponent("item.buddycards.buddycard.number_separator");
        cn.m_130946_("" + this.CARD_NUMBER);
        if (this.m_5812_(stack)) {
            cn.m_7220_((Component)new TranslatableComponent("item.buddycards.buddycard.foil_symbol"));
        }
        tooltip.add((Component)new TranslatableComponent(this.SET.getDescriptionId()).m_7220_((Component)cn).m_130940_(ChatFormatting.GRAY));
        if (stack.m_41782_() && stack.m_41783_().m_128441_("grade")) {
            tooltip.add((Component)new TranslatableComponent("item.buddycards.buddycard.grade." + stack.m_41783_().m_128451_("grade")).m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("wins")) {
            tooltip.add((Component)new TranslatableComponent("item.buddycards.buddycard.stats").m_130946_("" + stack.m_41783_().m_128451_("wins")).m_7220_((Component)new TranslatableComponent("item.buddycards.buddycard.power")).m_7220_((Component)new TranslatableComponent("item.buddycards.buddycard.number_separator")).m_130946_("" + stack.m_41783_().m_128451_("loss")).m_7220_((Component)new TranslatableComponent("item.buddycards.buddycard.skull")).m_130940_(ChatFormatting.BLUE));
        }
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.getRarity();
    }

    public Rarity getRarity() {
        return this.RARITY;
    }

    public BuddycardSet getSet() {
        return this.SET;
    }

    public int getCardNumber() {
        return this.CARD_NUMBER;
    }

    public static void setShiny(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128379_("foil", true);
        stack.m_41751_(nbt);
    }

    public boolean m_5812_(ItemStack stack) {
        return BuddycardItem.hasFoil(stack);
    }

    public static boolean hasFoil(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("foil") && stack.m_41783_().m_128471_("foil");
    }

    public static int getGrade(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("grade")) {
            return stack.m_41783_().m_128451_("grade");
        }
        return 0;
    }

    public int getCost() {
        return this.COST;
    }

    public int getPower() {
        return this.POWER;
    }

    public ListMultimap<BattleEvent, BattleAbility> getAbilities() {
        return this.ABILITIES;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group) && this.REQUIREMENT.shouldLoad()) {
            ItemStack foil = new ItemStack((ItemLike)this);
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("foil", true);
            foil.m_41751_(nbt);
            items.add((Object)new ItemStack((ItemLike)this));
            items.add((Object)foil);
        }
    }

    public boolean shouldLoad() {
        return this.REQUIREMENT.shouldLoad();
    }

    public BuddycardItem getOriginal() {
        return this;
    }
}

