/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.menu;

import com.mojang.serialization.DynamicOps;
import com.wildcard.buddycards.battles.BattleComponent;
import com.wildcard.buddycards.battles.BuddycardsPackets;
import com.wildcard.buddycards.battles.BuddycardsSyncPacket;
import com.wildcard.buddycards.battles.game.BattleEvent;
import com.wildcard.buddycards.battles.game.BattleGame;
import com.wildcard.buddycards.block.PlaymatBlock;
import com.wildcard.buddycards.block.entity.PlaymatBlockEntity;
import com.wildcard.buddycards.container.BattleContainer;
import com.wildcard.buddycards.item.BuddycardItem;
import com.wildcard.buddycards.registries.BuddycardsMisc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;

public class PlaymatMenu
extends AbstractContainerMenu {
    public PlaymatBlockEntity entity;
    public BattleContainer container;
    public final DataSlot energy = DataSlot.m_39401_();
    public final DataSlot health = DataSlot.m_39401_();
    public final DataSlot opponentEnergy = DataSlot.m_39401_();
    public final DataSlot opponentHealth = DataSlot.m_39401_();
    public final DataSlot selectedSlot = DataSlot.m_39401_();
    private final Inventory inventory;
    private final List<SyncedData> syncedData = new ArrayList<SyncedData>();

    public PlaymatMenu(int id, Inventory playerInv, FriendlyByteBuf buf) {
        this(id, playerInv, PlaymatMenu.decodeBlockEntity(playerInv.f_35978_.f_19853_, buf.m_130135_()));
    }

    private static PlaymatBlockEntity decodeBlockEntity(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PlaymatBlockEntity) {
            PlaymatBlockEntity entity = (PlaymatBlockEntity)blockEntity;
            return entity;
        }
        throw new IllegalStateException("Block entity expected to be PlaymatBlockEntity!" + pos);
    }

    public PlaymatMenu(int id, Inventory playerInv, PlaymatBlockEntity entity) {
        super((MenuType)BuddycardsMisc.PLAYMAT_CONTAINER.get(), id);
        int i;
        this.entity = entity;
        this.container = entity.container;
        this.m_38897_(new DeckSlot((Container)this.container, entity.p1 ? 7 : 0, 143, 18));
        this.m_38897_(new DeckSlot((Container)this.container, entity.p1 ? 0 : 7, 143, 64));
        Direction dir = (Direction)entity.m_58900_().m_61143_((Property)PlaymatBlock.DIR);
        for (i = 0; i < 3; ++i) {
            this.m_38897_(new HandSlot(this, (entity.p1 ? 1 : 8) + i, 80 + 18 * i, 64));
        }
        for (i = 0; i < 3; ++i) {
            this.m_38897_(new BattlefieldSlot(this, (entity.p1 ? 4 : 11) + i, dir == Direction.SOUTH || dir == Direction.WEST ? 80 + 18 * i : 116 - 18 * i, 36));
        }
        for (i = 0; i < 3; ++i) {
            this.m_38897_(new OpponentBattlefieldSlot(this, (entity.p1 ? 11 : 4) + i, dir == Direction.SOUTH || dir == Direction.WEST ? 80 + 18 * i : 116 - 18 * i, 18));
        }
        this.m_38895_(this.energy);
        this.m_38895_(this.health);
        this.m_38895_(this.opponentEnergy);
        this.m_38895_(this.opponentHealth);
        this.m_38895_(this.selectedSlot);
        this.selectedSlot.m_6422_(-999);
        this.updateDataSlots();
        this.inventory = playerInv;
        this.syncedData.add(new SyncedData(() -> {
            CompoundTag nbt = new CompoundTag();
            Tag tag = (Tag)BattleComponent.LIST_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.getBattleLog()).result().orElse(new ListTag());
            nbt.m_128365_("data", tag);
            return nbt;
        }, nbt -> {
            Tag data = nbt.m_128423_("data");
            BattleComponent.LIST_CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)data).result().ifPresent(result -> {
                this.container.battleLog.clear();
                this.container.battleLog.addAll((Collection)result.getFirst());
            });
        }));
        i = 0;
        while (i < 6) {
            int finalI = i++;
            this.syncedData.add(new SyncedData(() -> {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_("power", this.container.game.state[finalI].power);
                return nbt;
            }, nbt -> {
                this.container.game.state[finalI].power = nbt.m_128451_("power");
            }));
        }
    }

    public boolean m_6875_(Player player) {
        return this.container.deck1 != null && this.container.deck2 != null && !this.entity.m_58901_() && this.entity.inGame && player.m_20275_((double)this.entity.m_58899_().m_123341_() + 0.5, (double)this.entity.m_58899_().m_123342_() + 0.5, (double)this.entity.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    public void m_150399_(int slotIndex, int button, ClickType clickType, Player player) {
        if (slotIndex == -999) {
            this.selectedSlot.m_6422_(-999);
        } else {
            Slot slot = this.m_38853_(slotIndex);
            if (slot instanceof CardSlot) {
                CardSlot slot2 = (CardSlot)slot;
                int slotNum = slot2.getSlotIndex();
                if (slot2 instanceof HandSlot) {
                    BuddycardItem item;
                    ItemStack stack = this.container.m_8020_(slotNum);
                    Item item2 = stack.m_41720_();
                    if (item2 instanceof BuddycardItem && this.container.game.canPlay(this.entity.p1, item = (BuddycardItem)item2)) {
                        this.selectedSlot.m_6422_(slotNum == this.selectedSlot.m_6501_() ? -999 : slotNum);
                    } else {
                        if (this.selectedSlot.m_6501_() != -999 && stack.m_41619_()) {
                            ItemStack selectedItem = this.container.m_8020_(this.selectedSlot.m_6501_());
                            this.container.m_6836_(slotNum, selectedItem.m_41620_(1));
                        }
                        this.selectedSlot.m_6422_(-999);
                    }
                } else if (slot2 instanceof BattlefieldSlot) {
                    int selSlot;
                    if (!this.container.m_8020_(slotNum).m_41619_() && this.container.game.trigger(BattleEvent.ACTIVATED, BattleGame.translateTo(slotNum))) {
                        this.container.syncData();
                    }
                    if ((selSlot = this.selectedSlot.m_6501_()) != -999 && this.container.m_8020_(slotNum).m_41619_()) {
                        if (this.container.game.playCard(BattleGame.translateTo(slotNum), this.container.m_8020_(selSlot), this.entity.p1)) {
                            this.container.m_6836_(selSlot, ItemStack.f_41583_);
                            this.container.game.trigger(BattleEvent.PLAYED, BattleGame.translateTo(slotNum));
                            this.m_38946_();
                        }
                        this.selectedSlot.m_6422_(-999);
                    }
                }
            }
        }
        super.m_150399_(slotIndex, button, clickType, player);
        this.setPlaymatsChanged();
    }

    public boolean m_6366_(Player player, int buttonId) {
        if (buttonId == 1 && this.container.game.isP1() == this.entity.p1 && !this.container.game.hasGameEnded()) {
            if (this.container.game.endTurn()) {
                this.container.game.nextTurn();
            }
            this.setPlaymatsChanged();
            return true;
        }
        return false;
    }

    private void setPlaymatsChanged() {
        BlockEntity blockEntity;
        this.entity.m_6596_();
        BlockState blockState = this.entity.m_58900_();
        if (blockState.m_60734_() instanceof PlaymatBlock && (blockEntity = this.entity.m_58904_().m_7702_(this.entity.m_58899_().m_142300_((Direction)blockState.m_61143_((Property)PlaymatBlock.DIR)))) instanceof PlaymatBlockEntity) {
            PlaymatBlockEntity opponent = (PlaymatBlockEntity)blockEntity;
            opponent.m_6596_();
        }
    }

    private void updateDataSlots() {
        if (this.entity.p1) {
            this.energy.m_6422_(this.container.energy1);
            this.opponentEnergy.m_6422_(this.container.energy2);
            this.health.m_6422_(this.container.health1);
            this.opponentHealth.m_6422_(this.container.health2);
        } else {
            this.energy.m_6422_(this.container.energy2);
            this.opponentEnergy.m_6422_(this.container.energy1);
            this.health.m_6422_(this.container.health2);
            this.opponentHealth.m_6422_(this.container.health1);
        }
    }

    public void m_38946_() {
        super.m_38946_();
        this.sync(false);
    }

    public void m_182423_() {
        super.m_182423_();
        this.sync(true);
    }

    private void sync(boolean fullSync) {
        Player player = this.inventory.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.updateDataSlots();
            ListTag nbt = new ListTag();
            for (int i = 0; i < this.syncedData.size(); ++i) {
                Optional<CompoundTag> optData = this.syncedData.get(i).getNBT(fullSync);
                if (!optData.isPresent()) continue;
                CompoundTag compoundTag = optData.get();
                compoundTag.m_128405_("dataid", i);
                nbt.add((Object)compoundTag);
            }
            if (!nbt.isEmpty()) {
                BuddycardsPackets.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new BuddycardsSyncPacket(nbt));
            }
        }
    }

    public void consumeSync(ListTag nbt) {
        for (Tag tag : nbt) {
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag cmpTag = (CompoundTag)tag;
            int dataid = cmpTag.m_128451_("dataid");
            this.syncedData.get(dataid).consumeNBT(cmpTag);
        }
    }

    public List<BattleComponent> getBattleLog() {
        return this.container.battleLog;
    }

    public static class DeckSlot
    extends Slot {
        public DeckSlot(Container inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean m_8010_(Player player) {
            return false;
        }
    }

    public static class HandSlot
    extends CardSlot {
        public HandSlot(PlaymatMenu menu, int index, int xPosition, int yPosition) {
            super(menu, index, xPosition, yPosition);
        }
    }

    public static class BattlefieldSlot
    extends CardSlot {
        public BattlefieldSlot(PlaymatMenu menu, int index, int xPosition, int yPosition) {
            super(menu, index, xPosition, yPosition);
        }
    }

    public static class OpponentBattlefieldSlot
    extends CardSlot {
        public OpponentBattlefieldSlot(PlaymatMenu menu, int index, int xPosition, int yPosition) {
            super(menu, index, xPosition, yPosition);
        }
    }

    public static final class SyncedData {
        private final Supplier<CompoundTag> nbtGetter;
        private final Consumer<CompoundTag> nbtConsumer;
        private CompoundTag clientNBTPrediction = new CompoundTag();

        public SyncedData(Supplier<CompoundTag> nbtGetter, Consumer<CompoundTag> nbtConsumer) {
            this.nbtGetter = nbtGetter;
            this.nbtConsumer = nbtConsumer;
        }

        public Optional<CompoundTag> getNBT(boolean fullSync) {
            CompoundTag compoundTag = this.nbtGetter.get();
            if (fullSync || !compoundTag.equals((Object)this.clientNBTPrediction)) {
                this.clientNBTPrediction = compoundTag;
                return Optional.of(compoundTag);
            }
            return Optional.empty();
        }

        public void consumeNBT(CompoundTag tag) {
            this.nbtConsumer.accept(tag);
        }
    }

    public static abstract class CardSlot
    extends Slot {
        public CardSlot(PlaymatMenu menu, int index, int xPosition, int yPosition) {
            super((Container)menu.container, index, xPosition, yPosition);
        }

        public int m_6641_() {
            return 1;
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public boolean m_8010_(Player player) {
            return false;
        }
    }

    public static final class ButtonIds {
        public static final int END_TURN = 1;
    }
}

