/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class BuddysteelChargingRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final Ingredient input;
    private final Ingredient meter;
    private final NonNullList<Ingredient> ingredients;
    private final float powerReq;

    public BuddysteelChargingRecipe(ResourceLocation id, ItemStack output, Ingredient input, Ingredient meter, NonNullList<Ingredient> ingredients, float powerReq) {
        this.id = id;
        this.output = output;
        this.input = input;
        this.meter = meter;
        this.ingredients = ingredients;
        this.powerReq = powerReq;
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (this.input.test(container.m_8020_(0)) && this.meter.test(container.m_8020_(5))) {
            for (int i = 0; i < this.ingredients.size(); ++i) {
                if (((Ingredient)this.ingredients.get(i)).test(container.m_8020_(i + 1))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ItemStack assemble(SimpleContainer container) {
        return this.output;
    }

    public boolean m_8004_(int w, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public float getPowerReq() {
        return this.powerReq;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public Ingredient getMeter() {
        return this.meter;
    }

    public static class Serializer
    implements RecipeSerializer<BuddysteelChargingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("buddycards", "buddysteel_charging");

        public BuddysteelChargingRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            Ingredient meter = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"meter"));
            JsonArray ingredientsJson = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList ingredients = NonNullList.m_122780_((int)4, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredientsJson.get(i)));
            }
            float req = GsonHelper.m_13915_((JsonObject)json, (String)"power");
            return new BuddysteelChargingRecipe(id, output, input, meter, (NonNullList<Ingredient>)ingredients, req);
        }

        public BuddysteelChargingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.m_122780_((int)buf.readInt(), (Object)Ingredient.f_43901_);
            inputs.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            float req = buf.readFloat();
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            Ingredient meter = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack output = buf.m_130267_();
            return new BuddysteelChargingRecipe(id, output, input, meter, (NonNullList<Ingredient>)inputs, req);
        }

        public void toNetwork(FriendlyByteBuf buf, BuddysteelChargingRecipe recipe) {
            buf.writeInt(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buf);
            }
            buf.writeFloat(recipe.powerReq);
            recipe.input.m_43923_(buf);
            recipe.meter.m_43923_(buf);
            buf.writeItemStack(recipe.m_8043_(), false);
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        public ResourceLocation getRegistryName() {
            return ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }
    }

    public static class Type
    implements RecipeType<BuddysteelChargingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "buddysteel_charging";

        private Type() {
        }
    }
}

