/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.registries;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.ibm.icu.impl.Pair;
import com.wildcard.buddycards.Buddycards;
import com.wildcard.buddycards.battles.BattleComponent;
import com.wildcard.buddycards.battles.BuddycardBattleIcon;
import com.wildcard.buddycards.battles.IBattleIcon;
import com.wildcard.buddycards.battles.TextureBattleIcon;
import com.wildcard.buddycards.battles.game.BattleAbility;
import com.wildcard.buddycards.battles.game.BattleEvent;
import com.wildcard.buddycards.battles.game.BattleGame;
import com.wildcard.buddycards.battles.game.BattleStatusEffect;
import com.wildcard.buddycards.container.BattleContainer;
import com.wildcard.buddycards.core.BuddycardSet;
import com.wildcard.buddycards.gear.BuddycardsArmorMaterial;
import com.wildcard.buddycards.gear.BuddycardsToolTier;
import com.wildcard.buddycards.item.BattleSleeveItem;
import com.wildcard.buddycards.item.BlankBuddysteelMedalItem;
import com.wildcard.buddycards.item.BuddycardBinderItem;
import com.wildcard.buddycards.item.BuddycardBoosterBoxItem;
import com.wildcard.buddycards.item.BuddycardItem;
import com.wildcard.buddycards.item.BuddycardPackItem;
import com.wildcard.buddycards.item.BuddycardReprintItem;
import com.wildcard.buddycards.item.BuddycardSetPackItem;
import com.wildcard.buddycards.item.BuddycardsArmorItem;
import com.wildcard.buddycards.item.BuddysteelPowerMeterItem;
import com.wildcard.buddycards.item.BuddysteelSetMedalItem;
import com.wildcard.buddycards.item.CreativeGradingSleeveItem;
import com.wildcard.buddycards.item.DeckboxItem;
import com.wildcard.buddycards.item.DescriptionBlockItem;
import com.wildcard.buddycards.item.DescriptionItem;
import com.wildcard.buddycards.item.EnderBinderItem;
import com.wildcard.buddycards.item.GradingSleeveItem;
import com.wildcard.buddycards.item.LuminisSleeveItem;
import com.wildcard.buddycards.item.MedalTypes;
import com.wildcard.buddycards.item.MysteryBuddycardPackItem;
import com.wildcard.buddycards.item.SetBasedBlockItem;
import com.wildcard.buddycards.item.ZylexPowerMeterItem;
import com.wildcard.buddycards.registries.BuddycardsBlocks;
import com.wildcard.buddycards.registries.BuddycardsEntities;
import com.wildcard.buddycards.registries.BuddycardsMisc;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BuddycardsItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"buddycards");
    public static final BuddycardSet BASE_SET = new BuddycardSet("base");
    public static final BuddycardSet NETHER_SET = new BuddycardSet("nether");
    public static final BuddycardSet END_SET = new BuddycardSet("end");
    public static final BuddycardSet HOLIDAY_SET = new BuddycardSet("holiday");
    public static final Item.Properties DEFAULT_PROPERTIES = new Item.Properties().m_41491_(Buddycards.TAB);
    public static final Item.Properties DEFAULT_UNCOMMON_PROPERTIES = new Item.Properties().m_41491_(Buddycards.TAB).m_41497_(Rarity.UNCOMMON);
    public static final Item.Properties UNCOMMON_TOOL_PROPERTIES = new Item.Properties().m_41491_(Buddycards.TAB).m_41497_(Rarity.UNCOMMON).m_41487_(1);
    public static final Item.Properties RARE_TOOL_PROPERTIES = new Item.Properties().m_41491_(Buddycards.TAB).m_41497_(Rarity.RARE).m_41487_(1);
    public static final Item.Properties DEFAULT_RARE_PROPERTIES = new Item.Properties().m_41491_(Buddycards.TAB).m_41497_(Rarity.RARE);
    public static final Item.Properties DEFAULT_EPIC_PROPERTIES = new Item.Properties().m_41491_(Buddycards.TAB).m_41497_(Rarity.EPIC);
    public static final Item.Properties DEFAULT_CARD_PROPERTIES = new Item.Properties().m_41491_(Buddycards.CARDS_TAB);
    public static final Item.Properties DEFAULT_PACK_PROPERTIES = new Item.Properties().m_41491_(Buddycards.TAB).m_41487_(16).m_41497_(Rarity.UNCOMMON);
    public static final Item.Properties RARE_PACK_PROPERTIES = new Item.Properties().m_41491_(Buddycards.TAB).m_41487_(16).m_41497_(Rarity.RARE);
    public static final Item.Properties DEFAULT_BINDER_PROPERTIES = new Item.Properties().m_41491_(Buddycards.TAB).m_41487_(1).m_41497_(Rarity.UNCOMMON);
    public static final Item.Properties DEFAULT_CURIO_PROPERTIES = new Item.Properties().m_41491_(Buddycards.TAB).m_41487_(1).m_41497_(Rarity.UNCOMMON);
    public static final Item.Properties BUDDYSTEEL_MEDAL_PROPERTIES = new Item.Properties().m_41491_(Buddycards.TAB).m_41487_(1).m_41497_(Rarity.COMMON);
    public static final BuddycardRequirement DEFAULT_BUDDYCARD_REQUIREMENT = () -> true;
    public static final BuddycardRequirement HALLOWEEN_BUDDYCARD_REQUIREMENT = () -> Calendar.getInstance().get(2) == 9 && Calendar.getInstance().get(5) >= 29;
    public static final BuddycardRequirement CHRISTMAS_BUDDYCARD_REQUIREMENT = () -> Calendar.getInstance().get(2) == 11 && Calendar.getInstance().get(5) >= 24 && Calendar.getInstance().get(5) <= 26;
    public static final SimpleWeightedRandomList<Rarity> DEFAULT_RARITY_WEIGHTS = SimpleWeightedRandomList.m_146263_().m_146271_((Object)Rarity.COMMON, 24).m_146271_((Object)Rarity.UNCOMMON, 12).m_146271_((Object)Rarity.RARE, 3).m_146271_((Object)Rarity.EPIC, 1).m_146270_();
    public static final ImmutableListMultimap<BattleEvent, BattleAbility> DEFAULT_NO_ABILITIES = ImmutableListMultimap.of();
    public static final RegistryObject<BuddycardPackItem> PACK_BASE = ITEMS.register("buddycard_pack_base", () -> new BuddycardSetPackItem(DEFAULT_BUDDYCARD_REQUIREMENT, BASE_SET, 4, 1, DEFAULT_RARITY_WEIGHTS, DEFAULT_PACK_PROPERTIES));
    public static final RegistryObject<BuddycardPackItem> PACK_NETHER = ITEMS.register("buddycard_pack_nether", () -> new BuddycardSetPackItem(DEFAULT_BUDDYCARD_REQUIREMENT, NETHER_SET, 4, 1, DEFAULT_RARITY_WEIGHTS, DEFAULT_PACK_PROPERTIES));
    public static final RegistryObject<BuddycardPackItem> PACK_END = ITEMS.register("buddycard_pack_end", () -> new BuddycardSetPackItem(DEFAULT_BUDDYCARD_REQUIREMENT, END_SET, 4, 1, DEFAULT_RARITY_WEIGHTS, DEFAULT_PACK_PROPERTIES));
    public static final RegistryObject<BuddycardPackItem> MYSTERY_PACK = ITEMS.register("buddycard_pack_mystery", () -> new MysteryBuddycardPackItem(DEFAULT_BUDDYCARD_REQUIREMENT, 4, 1, DEFAULT_RARITY_WEIGHTS, false, RARE_PACK_PROPERTIES));
    public static final RegistryObject<BuddycardBinderItem> BINDER_BASE = ITEMS.register("buddycard_binder_base", () -> new BuddycardBinderItem(DEFAULT_BUDDYCARD_REQUIREMENT, DEFAULT_BINDER_PROPERTIES, BASE_SET));
    public static final RegistryObject<BuddycardBinderItem> BINDER_NETHER = ITEMS.register("buddycard_binder_nether", () -> new BuddycardBinderItem(DEFAULT_BUDDYCARD_REQUIREMENT, DEFAULT_BINDER_PROPERTIES, NETHER_SET));
    public static final RegistryObject<BuddycardBinderItem> BINDER_END = ITEMS.register("buddycard_binder_end", () -> new BuddycardBinderItem(DEFAULT_BUDDYCARD_REQUIREMENT, DEFAULT_BINDER_PROPERTIES, END_SET));
    public static final RegistryObject<EnderBinderItem> ENDER_BINDER = ITEMS.register("ender_buddycard_binder", () -> new EnderBinderItem(DEFAULT_BINDER_PROPERTIES));
    public static final RegistryObject<DeckboxItem> BUDDYSTEEL_DECKBOX = ITEMS.register("buddysteel_deckbox", () -> new DeckboxItem(DEFAULT_BINDER_PROPERTIES));
    public static final RegistryObject<DeckboxItem> LUMINIS_DECKBOX = ITEMS.register("luminis_deckbox", () -> new DeckboxItem(DEFAULT_BINDER_PROPERTIES));
    public static final RegistryObject<DeckboxItem> ZYLEX_DECKBOX = ITEMS.register("zylex_deckbox", () -> new DeckboxItem(DEFAULT_BINDER_PROPERTIES));
    public static final RegistryObject<BlockItem> PLAYMAT_BASE = ITEMS.register("playmat_base", () -> new SetBasedBlockItem((Block)BuddycardsBlocks.PLAYMAT_BASE.get(), DEFAULT_PROPERTIES, BASE_SET));
    public static final RegistryObject<BlockItem> PLAYMAT_NETHER = ITEMS.register("playmat_nether", () -> new SetBasedBlockItem((Block)BuddycardsBlocks.PLAYMAT_NETHER.get(), DEFAULT_PROPERTIES, NETHER_SET));
    public static final RegistryObject<BlockItem> PLAYMAT_END = ITEMS.register("playmat_end", () -> new SetBasedBlockItem((Block)BuddycardsBlocks.PLAYMAT_END.get(), DEFAULT_PROPERTIES, END_SET));
    public static final RegistryObject<Item> BUDDYSTEEL_BLEND = ITEMS.register("buddysteel_blend", () -> new Item(DEFAULT_PROPERTIES));
    public static final RegistryObject<Item> BUDDYSTEEL_INGOT = ITEMS.register("buddysteel_ingot", () -> new Item(DEFAULT_PROPERTIES));
    public static final RegistryObject<Item> BUDDYSTEEL_NUGGET = ITEMS.register("buddysteel_nugget", () -> new Item(DEFAULT_PROPERTIES));
    public static final RegistryObject<Item> BUDDYSTEEL_BLOCK = ITEMS.register("buddysteel_block", () -> new BlockItem((Block)BuddycardsBlocks.BUDDYSTEEL_BLOCK.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<BuddysteelPowerMeterItem> BUDDYSTEEL_POWER_METER = ITEMS.register("buddysteel_power_meter", () -> new BuddysteelPowerMeterItem(DEFAULT_UNCOMMON_PROPERTIES));
    public static final RegistryObject<Item> BUDDYSTEEL_HELMET = ITEMS.register("buddysteel_helmet", () -> new BuddycardsArmorItem(BuddycardsArmorMaterial.BUDDYSTEEL, EquipmentSlot.HEAD));
    public static final RegistryObject<Item> BUDDYSTEEL_CHESTPLATE = ITEMS.register("buddysteel_chestplate", () -> new BuddycardsArmorItem(BuddycardsArmorMaterial.BUDDYSTEEL, EquipmentSlot.CHEST));
    public static final RegistryObject<Item> BUDDYSTEEL_LEGGINGS = ITEMS.register("buddysteel_leggings", () -> new BuddycardsArmorItem(BuddycardsArmorMaterial.BUDDYSTEEL, EquipmentSlot.LEGS));
    public static final RegistryObject<Item> BUDDYSTEEL_BOOTS = ITEMS.register("buddysteel_boots", () -> new BuddycardsArmorItem(BuddycardsArmorMaterial.BUDDYSTEEL, EquipmentSlot.FEET));
    public static final RegistryObject<Item> BUDDYSTEEL_SWORD = ITEMS.register("buddysteel_sword", () -> new SwordItem((Tier)BuddycardsToolTier.BUDDYSTEEL, 3, -2.4f, UNCOMMON_TOOL_PROPERTIES));
    public static final RegistryObject<Item> BUDDYSTEEL_SHOVEL = ITEMS.register("buddysteel_shovel", () -> new ShovelItem((Tier)BuddycardsToolTier.BUDDYSTEEL, 1.5f, -3.0f, UNCOMMON_TOOL_PROPERTIES));
    public static final RegistryObject<Item> BUDDYSTEEL_PICKAXE = ITEMS.register("buddysteel_pickaxe", () -> new PickaxeItem((Tier)BuddycardsToolTier.BUDDYSTEEL, 1, -2.8f, UNCOMMON_TOOL_PROPERTIES));
    public static final RegistryObject<Item> BUDDYSTEEL_AXE = ITEMS.register("buddysteel_axe", () -> new AxeItem((Tier)BuddycardsToolTier.BUDDYSTEEL, 6.0f, -3.1f, UNCOMMON_TOOL_PROPERTIES));
    public static final RegistryObject<Item> BUDDYSTEEL_HOE = ITEMS.register("buddysteel_hoe", () -> new HoeItem((Tier)BuddycardsToolTier.BUDDYSTEEL, -2, -1.0f, UNCOMMON_TOOL_PROPERTIES));
    public static final RegistryObject<BlockItem> LUMINIS_ORE = ITEMS.register("luminis_ore", () -> new BlockItem((Block)BuddycardsBlocks.LUMINIS_ORE.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<BlockItem> DEEPSLATE_LUMINIS_ORE = ITEMS.register("deepslate_luminis_ore", () -> new BlockItem((Block)BuddycardsBlocks.DEEPSLATE_LUMINIS_ORE.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<Item> LUMINIS_CRYSTAL = ITEMS.register("luminis_crystal", () -> new Item(DEFAULT_PROPERTIES));
    public static final RegistryObject<BlockItem> LUMINIS_CRYSTAL_BLOCK = ITEMS.register("luminis_crystal_block", () -> new BlockItem((Block)BuddycardsBlocks.LUMINIS_CRYSTAL_BLOCK.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<Item> LUMINIS = ITEMS.register("luminis", () -> new Item(DEFAULT_PROPERTIES));
    public static final RegistryObject<BlockItem> LUMINIS_BLOCK = ITEMS.register("luminis_block", () -> new BlockItem((Block)BuddycardsBlocks.LUMINIS_BLOCK.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<Item> LUMINIS_PANEL = ITEMS.register("luminis_panel", () -> new Item(DEFAULT_PROPERTIES));
    public static final RegistryObject<BlockItem> LUMINIS_PANELS = ITEMS.register("luminis_panels", () -> new BlockItem((Block)BuddycardsBlocks.LUMINIS_PANELS.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<Item> CRIMSON_LUMINIS = ITEMS.register("crimson_luminis", () -> new Item(DEFAULT_PROPERTIES));
    public static final RegistryObject<BlockItem> CRIMSON_LUMINIS_BLOCK = ITEMS.register("crimson_luminis_block", () -> new BlockItem((Block)BuddycardsBlocks.CRIMSON_LUMINIS_BLOCK.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<BlockItem> KINETIC_CHAMBER = ITEMS.register("kinetic_chamber", () -> new DescriptionBlockItem((Block)BuddycardsBlocks.KINETIC_CHAMBER.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<Item> LUMINIS_HELMET = ITEMS.register("luminis_helmet", () -> new BuddycardsArmorItem(BuddycardsArmorMaterial.LUMINIS, EquipmentSlot.HEAD));
    public static final RegistryObject<Item> LUMINIS_PICKAXE = ITEMS.register("luminis_pickaxe", () -> new PickaxeItem((Tier)BuddycardsToolTier.LUMINIS, 1, -2.8f, UNCOMMON_TOOL_PROPERTIES));
    public static final RegistryObject<Item> LUMINIS_RING = ITEMS.register("luminis_ring", () -> new DescriptionItem(DEFAULT_CURIO_PROPERTIES));
    public static final RegistryObject<Item> ZYLEX = ITEMS.register("zylex", () -> new Item(DEFAULT_PROPERTIES));
    public static final RegistryObject<Item> ZYLEX_NUGGET = ITEMS.register("zylex_nugget", () -> new Item(DEFAULT_PROPERTIES));
    public static final RegistryObject<BlockItem> ZYLEX_BLOCK = ITEMS.register("zylex_block", () -> new BlockItem((Block)BuddycardsBlocks.ZYLEX_BLOCK.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<Item> VOID_ZYLEX = ITEMS.register("void_zylex", () -> new Item(DEFAULT_PROPERTIES));
    public static final RegistryObject<BlockItem> VOID_ZYLEX_BLOCK = ITEMS.register("void_zylex_block", () -> new BlockItem((Block)BuddycardsBlocks.VOID_ZYLEX_BLOCK.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<Item> ZYLEX_BOOTS = ITEMS.register("zylex_boots", () -> new BuddycardsArmorItem(BuddycardsArmorMaterial.ZYLEX, EquipmentSlot.FEET));
    public static final RegistryObject<Item> ZYLEX_HOE = ITEMS.register("zylex_hoe", () -> new HoeItem((Tier)BuddycardsToolTier.ZYLEX, -2, -1.0f, UNCOMMON_TOOL_PROPERTIES));
    public static final RegistryObject<Item> ZYLEX_RING = ITEMS.register("zylex_ring", () -> new DescriptionItem(DEFAULT_CURIO_PROPERTIES));
    public static final RegistryObject<ZylexPowerMeterItem> ZYLEX_POWER_METER = ITEMS.register("zylex_power_meter", () -> new ZylexPowerMeterItem(DEFAULT_RARE_PROPERTIES));
    public static final RegistryObject<BlankBuddysteelMedalItem> BLANK_BUDDYSTEEL_MEDAL = ITEMS.register("blank_buddysteel_medal", () -> new BlankBuddysteelMedalItem(BUDDYSTEEL_MEDAL_PROPERTIES));
    public static final RegistryObject<BuddysteelSetMedalItem> MEDAL_BASE = ITEMS.register("buddysteel_medal_base", () -> new BuddysteelSetMedalItem(DEFAULT_BUDDYCARD_REQUIREMENT, MedalTypes.BASE_SET, BASE_SET, DEFAULT_CURIO_PROPERTIES));
    public static final RegistryObject<BuddysteelSetMedalItem> MEDAL_NETHER = ITEMS.register("buddysteel_medal_nether", () -> new BuddysteelSetMedalItem(DEFAULT_BUDDYCARD_REQUIREMENT, MedalTypes.NETHER_SET, NETHER_SET, DEFAULT_CURIO_PROPERTIES));
    public static final RegistryObject<BuddysteelSetMedalItem> MEDAL_END = ITEMS.register("buddysteel_medal_end", () -> new BuddysteelSetMedalItem(DEFAULT_BUDDYCARD_REQUIREMENT, MedalTypes.END_SET, END_SET, DEFAULT_CURIO_PROPERTIES));
    public static final RegistryObject<GradingSleeveItem> GRADING_SLEEVE = ITEMS.register("grading_sleeve", () -> new GradingSleeveItem(DEFAULT_PROPERTIES, new float[]{0.4f, 0.3f, 0.225f, 0.073f}));
    public static final RegistryObject<GradingSleeveItem> GOLDEN_GRADING_SLEEVE = ITEMS.register("golden_grading_sleeve", () -> new GradingSleeveItem(DEFAULT_UNCOMMON_PROPERTIES, new float[]{0.1f, 0.4f, 0.3f, 0.195f}));
    public static final RegistryObject<GradingSleeveItem> CREATIVE_GRADING_SLEEVE = ITEMS.register("creative_grading_sleeve", () -> new CreativeGradingSleeveItem(DEFAULT_EPIC_PROPERTIES, new float[]{0.1f, 0.4f, 0.3f, 0.19f}));
    public static final RegistryObject<LuminisSleeveItem> LUMINIS_SLEEVE = ITEMS.register("luminis_sleeve", () -> new LuminisSleeveItem(DEFAULT_RARE_PROPERTIES));
    public static final RegistryObject<GradingSleeveItem> ZYLEX_GRADING_SLEEVE = ITEMS.register("zylex_grading_sleeve", () -> new GradingSleeveItem(DEFAULT_RARE_PROPERTIES, new float[]{0.0f, 0.0f, 0.25f, 0.6f}));
    public static final RegistryObject<BattleSleeveItem> BATTLE_SLEEVE = ITEMS.register("battle_sleeve", () -> new BattleSleeveItem(DEFAULT_PROPERTIES));
    public static final RegistryObject<BlockItem> OAK_CARD_DISPLAY_ITEM = ITEMS.register("oak_card_display", () -> new BlockItem((Block)BuddycardsBlocks.OAK_CARD_DISPLAY.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<BlockItem> SPRUCE_CARD_DISPLAY_ITEM = ITEMS.register("spruce_card_display", () -> new BlockItem((Block)BuddycardsBlocks.SPRUCE_CARD_DISPLAY.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<BlockItem> BIRCH_CARD_DISPLAY_ITEM = ITEMS.register("birch_card_display", () -> new BlockItem((Block)BuddycardsBlocks.BIRCH_CARD_DISPLAY.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<BlockItem> JUNGLE_CARD_DISPLAY_ITEM = ITEMS.register("jungle_card_display", () -> new BlockItem((Block)BuddycardsBlocks.JUNGLE_CARD_DISPLAY.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<BlockItem> ACACIA_CARD_DISPLAY_ITEM = ITEMS.register("acacia_card_display", () -> new BlockItem((Block)BuddycardsBlocks.ACACIA_CARD_DISPLAY.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<BlockItem> DARK_OAK_CARD_DISPLAY_ITEM = ITEMS.register("dark_oak_card_display", () -> new BlockItem((Block)BuddycardsBlocks.DARK_OAK_CARD_DISPLAY.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<BlockItem> CRIMSON_CARD_DISPLAY_ITEM = ITEMS.register("crimson_card_display", () -> new BlockItem((Block)BuddycardsBlocks.CRIMSON_CARD_DISPLAY.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<BlockItem> WARPED_CARD_DISPLAY_ITEM = ITEMS.register("warped_card_display", () -> new BlockItem((Block)BuddycardsBlocks.WARPED_CARD_DISPLAY.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<BuddycardBoosterBoxItem> BOOSTER_BOX_BASE = ITEMS.register("buddycard_booster_box_base", () -> new BuddycardBoosterBoxItem((Block)BuddycardsBlocks.BOOSTER_BOX_BASE.get(), (Supplier<BuddycardPackItem>)PACK_BASE, DEFAULT_UNCOMMON_PROPERTIES));
    public static final RegistryObject<BuddycardBoosterBoxItem> BOOSTER_BOX_NETHER = ITEMS.register("buddycard_booster_box_nether", () -> new BuddycardBoosterBoxItem((Block)BuddycardsBlocks.BOOSTER_BOX_NETHER.get(), (Supplier<BuddycardPackItem>)PACK_NETHER, DEFAULT_UNCOMMON_PROPERTIES));
    public static final RegistryObject<BuddycardBoosterBoxItem> BOOSTER_BOX_END = ITEMS.register("buddycard_booster_box_end", () -> new BuddycardBoosterBoxItem((Block)BuddycardsBlocks.BOOSTER_BOX_END.get(), (Supplier<BuddycardPackItem>)PACK_END, DEFAULT_UNCOMMON_PROPERTIES));
    public static final RegistryObject<BuddycardBoosterBoxItem> BOOSTER_BOX_MYSTERY = ITEMS.register("buddycard_booster_box_mystery", () -> new BuddycardBoosterBoxItem((Block)BuddycardsBlocks.BOOSTER_BOX_MYSTERY.get(), (Supplier<BuddycardPackItem>)MYSTERY_PACK, DEFAULT_EPIC_PROPERTIES));
    public static final RegistryObject<Item> BUDDYSTEEL_CHARGER = ITEMS.register("buddysteel_charger", () -> new BlockItem((Block)BuddycardsBlocks.BUDDYSTEEL_CHARGER.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<Item> CHARGED_BUDDYSTEEL_INGOT = ITEMS.register("charged_buddysteel_ingot", () -> new Item(DEFAULT_PROPERTIES));
    public static final RegistryObject<Item> CHARGED_BUDDYSTEEL_BLOCK = ITEMS.register("charged_buddysteel_block", () -> new BlockItem((Block)BuddycardsBlocks.CHARGED_BUDDYSTEEL_BLOCK.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<Item> CHARGED_BUDDYSTEEL_HELMET = ITEMS.register("charged_buddysteel_helmet", () -> new BuddycardsArmorItem(BuddycardsArmorMaterial.CHARGED_BUDDYSTEEL, EquipmentSlot.HEAD));
    public static final RegistryObject<Item> CHARGED_BUDDYSTEEL_CHESTPLATE = ITEMS.register("charged_buddysteel_chestplate", () -> new BuddycardsArmorItem(BuddycardsArmorMaterial.CHARGED_BUDDYSTEEL, EquipmentSlot.CHEST));
    public static final RegistryObject<Item> CHARGED_BUDDYSTEEL_LEGGINGS = ITEMS.register("charged_buddysteel_leggings", () -> new BuddycardsArmorItem(BuddycardsArmorMaterial.CHARGED_BUDDYSTEEL, EquipmentSlot.LEGS));
    public static final RegistryObject<Item> CHARGED_BUDDYSTEEL_BOOTS = ITEMS.register("charged_buddysteel_boots", () -> new BuddycardsArmorItem(BuddycardsArmorMaterial.CHARGED_BUDDYSTEEL, EquipmentSlot.FEET));
    public static final RegistryObject<Item> CHARGED_BUDDYSTEEL_SWORD = ITEMS.register("charged_buddysteel_sword", () -> new SwordItem((Tier)BuddycardsToolTier.CHARGED_BUDDYSTEEL, 3, -2.4f, RARE_TOOL_PROPERTIES));
    public static final RegistryObject<Item> CHARGED_BUDDYSTEEL_SHOVEL = ITEMS.register("charged_buddysteel_shovel", () -> new ShovelItem((Tier)BuddycardsToolTier.CHARGED_BUDDYSTEEL, 1.5f, -3.0f, RARE_TOOL_PROPERTIES));
    public static final RegistryObject<Item> CHARGED_BUDDYSTEEL_PICKAXE = ITEMS.register("charged_buddysteel_pickaxe", () -> new PickaxeItem((Tier)BuddycardsToolTier.CHARGED_BUDDYSTEEL, 1, -2.8f, RARE_TOOL_PROPERTIES));
    public static final RegistryObject<Item> CHARGED_BUDDYSTEEL_AXE = ITEMS.register("charged_buddysteel_axe", () -> new AxeItem((Tier)BuddycardsToolTier.CHARGED_BUDDYSTEEL, 5.5f, -3.1f, RARE_TOOL_PROPERTIES));
    public static final RegistryObject<Item> CHARGED_BUDDYSTEEL_HOE = ITEMS.register("charged_buddysteel_hoe", () -> new HoeItem((Tier)BuddycardsToolTier.CHARGED_BUDDYSTEEL, -3, -1.0f, RARE_TOOL_PROPERTIES));
    public static final RegistryObject<Item> PERFECT_BUDDYSTEEL_INGOT = ITEMS.register("perfect_buddysteel_ingot", () -> new Item(DEFAULT_PROPERTIES));
    public static final RegistryObject<Item> PERFECT_BUDDYSTEEL_BLOCK = ITEMS.register("perfect_buddysteel_block", () -> new BlockItem((Block)BuddycardsBlocks.PERFECT_BUDDYSTEEL_BLOCK.get(), DEFAULT_PROPERTIES));
    public static final RegistryObject<Item> PERFECT_BUDDYSTEEL_HELMET = ITEMS.register("perfect_buddysteel_helmet", () -> new BuddycardsArmorItem(BuddycardsArmorMaterial.PERFECT_BUDDYSTEEL, EquipmentSlot.HEAD));
    public static final RegistryObject<Item> PERFECT_BUDDYSTEEL_CHESTPLATE = ITEMS.register("perfect_buddysteel_chestplate", () -> new BuddycardsArmorItem(BuddycardsArmorMaterial.PERFECT_BUDDYSTEEL, EquipmentSlot.CHEST));
    public static final RegistryObject<Item> PERFECT_BUDDYSTEEL_LEGGINGS = ITEMS.register("perfect_buddysteel_leggings", () -> new BuddycardsArmorItem(BuddycardsArmorMaterial.PERFECT_BUDDYSTEEL, EquipmentSlot.LEGS));
    public static final RegistryObject<Item> PERFECT_BUDDYSTEEL_BOOTS = ITEMS.register("perfect_buddysteel_boots", () -> new BuddycardsArmorItem(BuddycardsArmorMaterial.PERFECT_BUDDYSTEEL, EquipmentSlot.FEET));
    public static final RegistryObject<Item> PERFECT_BUDDYSTEEL_SWORD = ITEMS.register("perfect_buddysteel_sword", () -> new SwordItem((Tier)BuddycardsToolTier.PERFECT_BUDDYSTEEL, 3, -2.4f, RARE_TOOL_PROPERTIES));
    public static final RegistryObject<Item> PERFECT_BUDDYSTEEL_SHOVEL = ITEMS.register("perfect_buddysteel_shovel", () -> new ShovelItem((Tier)BuddycardsToolTier.PERFECT_BUDDYSTEEL, 1.5f, -3.0f, RARE_TOOL_PROPERTIES));
    public static final RegistryObject<Item> PERFECT_BUDDYSTEEL_PICKAXE = ITEMS.register("perfect_buddysteel_pickaxe", () -> new PickaxeItem((Tier)BuddycardsToolTier.PERFECT_BUDDYSTEEL, 1, -2.8f, RARE_TOOL_PROPERTIES));
    public static final RegistryObject<Item> PERFECT_BUDDYSTEEL_AXE = ITEMS.register("perfect_buddysteel_axe", () -> new AxeItem((Tier)BuddycardsToolTier.PERFECT_BUDDYSTEEL, 6.0f, -3.0f, RARE_TOOL_PROPERTIES));
    public static final RegistryObject<Item> PERFECT_BUDDYSTEEL_HOE = ITEMS.register("perfect_buddysteel_hoe", () -> new HoeItem((Tier)BuddycardsToolTier.PERFECT_BUDDYSTEEL, -4, -1.0f, RARE_TOOL_PROPERTIES));
    public static final RegistryObject<ForgeSpawnEggItem> ENDERLING_SPAWN_EGG = ITEMS.register("spawn_egg_enderling", () -> new ForgeSpawnEggItem(BuddycardsEntities.ENDERLING, 3024708, 10121932, DEFAULT_PROPERTIES));

    public static void registerItems() {
        BuddycardsItems.registerCard(BASE_SET, 1, Rarity.COMMON, 2, 1, new BattleAbility.Builder().add(BattleEvent.TURN.ability("growing_up", (game, slot, target, source) -> {
            int n = slot;
            game.turnPower[n] = game.turnPower[n] + 1;
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.growing_up.log"), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(1))));
            game.updatePower(slot);
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 2, Rarity.COMMON, 2, 1, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("stone_toss", (game, slot, target, source) -> {
            int opp = BattleGame.opposite(slot);
            game.directAttack(opp, slot, 1);
            if (game.getCard(opp) != null) {
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.stone_toss.log1").m_7220_((Component)new TranslatableComponent(game.getCard(opp).m_5524_())).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.stone_toss.log2")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.damageIcon(1), BuddycardBattleIcon.create(game.getCard(opp)))));
                game.updatePower(opp);
            } else {
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.stone_toss.log1").m_7220_(BattleGame.getOwner(slot) ? game.container.name2 : game.container.name1).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.stone_toss.log2")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.damageIcon(1))));
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 3, Rarity.COMMON, 3, 2, new BattleAbility.Builder().add(BattleEvent.DEATH.ability("tasty_bacon", (game, slot, target, source) -> {
            if (BattleGame.getOwner(slot)) {
                game.container.health1 += 2;
            } else {
                game.container.health2 += 2;
            }
            game.container.addLog(new BattleComponent((Component)new TextComponent("").m_7220_(BattleGame.getOwner(slot) ? game.container.name1 : game.container.name2).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.tasty_bacon.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, TextureBattleIcon.healIcon(2))));
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 4, Rarity.COMMON, 3, 2, new BattleAbility.Builder().add(BattleEvent.DEATH.ability("stoke_flames", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_FIRE)) continue;
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 1;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.addIcon(1));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.stoke_flames.log"), icons));
                game.updatePower();
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 5, Rarity.COMMON, 3, 2, new BattleAbility.Builder().add(BattleEvent.KILL.ability("iron_temper", (game, slot, target, source) -> {
            int n = slot;
            game.turnPower[n] = game.turnPower[n] + 1;
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.iron_temper.log"), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(1))));
            game.updatePower(slot);
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 6, Rarity.COMMON, 4, 2, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("simple_enchant", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_ENCHANTABLE)) continue;
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 1;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.addIcon(1));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.simple_enchant.log"), icons));
                game.updatePower();
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 7, Rarity.COMMON, 5, 2, new BattleAbility.Builder().add(BattleEvent.ACTIVATED.ability("milk_maid", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                if (game.state[i].status.equals((Object)BattleStatusEffect.EMPTY)) continue;
                game.state[i].status = BattleStatusEffect.EMPTY;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.statusIcon(BattleStatusEffect.EMPTY));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.milk_maid.log"), icons));
                return true;
            }
            return false;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 8, Rarity.COMMON, 1, 1, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("snowball_fight", (game, slot, target, source) -> {
            if (BattleGame.getOwner(slot)) {
                --game.container.health2;
            } else {
                --game.container.health1;
            }
            game.container.addLog(new BattleComponent((Component)new TextComponent("").m_7220_(BattleGame.getOwner(slot) ? game.container.name2 : game.container.name1).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.snowball_fight.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.damageIcon(1))));
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 9, Rarity.COMMON, 2, 0, new BattleAbility.Builder().add(BattleEvent.DEATH.ability("wash_out", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            ArrayList<Integer> changedCards = new ArrayList<Integer>();
            boolean a = false;
            boolean b = false;
            for (int i : (int[])BattleEvent.Distribution.ALL.apply(slot, game)) {
                if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_FIRE)) continue;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
                game.directAttack(BattleGame.opposite(slot), slot, 1, false, false);
                changedCards.add(i);
                a = true;
            }
            if (a) {
                icons.add(TextureBattleIcon.subtractIcon(1));
            }
            for (int i : (int[])BattleEvent.Distribution.ALL.apply(slot, game)) {
                if (game.state[i].status != BattleStatusEffect.FIRE) continue;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
                game.state[i].status = BattleStatusEffect.EMPTY;
                b = true;
            }
            if (a && b) {
                icons.add(TextureBattleIcon.statusIcon(BattleStatusEffect.EMPTY));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.wash_out.log"), icons));
                var8_8 = changedCards.iterator();
                while (var8_8.hasNext()) {
                    i = (Integer)var8_8.next();
                    game.updatePower(i);
                }
            } else if (b) {
                icons.add(TextureBattleIcon.statusIcon(BattleStatusEffect.EMPTY));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.wash_out.loga"), icons));
                var8_8 = changedCards.iterator();
                while (var8_8.hasNext()) {
                    i = (Integer)var8_8.next();
                    game.updatePower(i);
                }
            } else if (a) {
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.wash_out.loga"), icons));
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 10, Rarity.COMMON, 1, 1, new BattleAbility.Builder().add(BattleEvent.DEATH.ability("tasty_treat", (game, slot, target, source) -> {
            if (BattleGame.getOwner(slot)) {
                ++game.container.health1;
            } else {
                ++game.container.health2;
            }
            game.container.addLog(new BattleComponent((Component)new TextComponent("").m_7220_(BattleGame.getOwner(slot) ? game.container.name1 : game.container.name2).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.tasty_treat.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, TextureBattleIcon.healIcon(1))));
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 11, Rarity.COMMON, 3, 0, new BattleAbility.Builder().add(BattleEvent.DEATH.ability("fresh_harvest", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_ANIMAL)) continue;
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 2;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.addIcon(2));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.fresh_harvest.log"), icons));
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 12, Rarity.COMMON, 3, 1, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("feeding_time", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_ANIMAL)) continue;
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 1;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.addIcon(1));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.feeding_time.log"), icons));
                game.updatePower();
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 13, Rarity.UNCOMMON, 4, 3, new BattleAbility.Builder().add(BattleEvent.KILL.ability("play_fetch", (game, slot, target, source) -> {
            if (game.container.tryDrawCard(BattleGame.getOwner(slot))) {
                game.container.addLog(new BattleComponent((Component)new TextComponent("").m_7220_(BattleGame.getOwner(slot) ? game.container.name1 : game.container.name2).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.play_fetch.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, TextureBattleIcon.drawIcon)));
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 14, Rarity.UNCOMMON, 4, 2, new BattleAbility.Builder().add(BattleEvent.ACTIVATED.ability("lazy_cat", (game, slot, target, source) -> {
            if (game.state[slot].status.equals((Object)BattleStatusEffect.EMPTY)) {
                int n = slot;
                game.turnPower[n] = game.turnPower[n] + 2;
                game.state[slot].status = BattleStatusEffect.SLEEP;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.lazy_cat.log"), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(2), TextureBattleIcon.statusIcon(BattleStatusEffect.SLEEP))));
                game.updatePower(slot);
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 15, Rarity.UNCOMMON, 3, 1, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("gilded_gift", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_FOOD)) continue;
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 1;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.addIcon(1));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.gilded_gift.log"), icons));
                game.updatePower();
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 16, Rarity.UNCOMMON, 3, 1, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("rich_trade", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            while (game.container.tryDrawCard(BattleGame.getOwner(slot))) {
                icons.add(TextureBattleIcon.drawIcon);
            }
            if (icons.size() > 2) {
                game.container.addLog(new BattleComponent((Component)new TextComponent("").m_7220_(BattleGame.getOwner(slot) ? game.container.name1 : game.container.name2).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.rich_trade.log")), icons));
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 17, Rarity.UNCOMMON, 7, 3, new BattleAbility.Builder().add(BattleEvent.DAMAGED.ability("unbreakable", (game, slot, target, source) -> {
            ++game.state[slot].power;
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.unbreakable.log"), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(1))));
            game.updatePower(slot);
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 18, Rarity.UNCOMMON, 4, 2, new BattleAbility.Builder().add(BattleEvent.DEATH.ability("delicious_desert", (game, slot, target, source) -> {
            if (BattleGame.getOwner(slot)) {
                game.container.health1 += 3;
            } else {
                game.container.health2 += 3;
            }
            game.container.addLog(new BattleComponent((Component)new TextComponent("").m_7220_(BattleGame.getOwner(slot) ? game.container.name1 : game.container.name2).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.delicious_desert.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, TextureBattleIcon.healIcon(3))));
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 19, Rarity.UNCOMMON, 4, 2, new BattleAbility.Builder().add(BattleEvent.TURN.ability("energize", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            ArrayList<Integer> cards = new ArrayList<Integer>();
            for (int i : (int[])BattleEvent.Distribution.ADJACENT.apply(slot, game)) {
                if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_REDSTONE)) continue;
                cards.add(i);
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (cards.size() > 0) {
                icons.add(TextureBattleIcon.powerIcon);
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.energize.log"), icons));
                Object object = cards.iterator();
                while (object.hasNext()) {
                    int i = (Integer)object.next();
                    game.trigger(BattleEvent.POWERED, i, i, slot);
                }
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 20, Rarity.UNCOMMON, 2, 1, new BattleAbility.Builder().add(BattleEvent.DEATH.ability("sweet_treat", (game, slot, target, source) -> {
            if (BattleGame.getOwner(slot)) {
                game.container.health1 += 2;
            } else {
                game.container.health2 += 2;
            }
            game.container.addLog(new BattleComponent((Component)new TextComponent("").m_7220_(BattleGame.getOwner(slot) ? game.container.name1 : game.container.name2).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.sweet_treat.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, TextureBattleIcon.healIcon(2))));
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 21, Rarity.UNCOMMON, 4, 1, new BattleAbility.Builder().add(BattleEvent.FIGHT.ability("spook_em", (game, slot, target, source) -> {
            if (target != slot && game.getCard(target) != null && game.isP1() == BattleGame.getOwner(slot)) {
                game.directAttack(target, slot, 1, false, false);
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(target).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.spook_em.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(target)), TextureBattleIcon.subtractIcon(1))));
                game.updatePower(target);
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 22, Rarity.RARE, 8, 3, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("premium_enchant", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_ENCHANTABLE)) continue;
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 2;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.addIcon(2));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.premium_enchant.log"), icons));
                game.updatePower();
            }
            return true;
        })).add(BattleEvent.KILL.ability("xp_farm", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_ENCHANTABLE)) continue;
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 1;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.addIcon(1));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.premium_enchant.log"), icons));
                game.updatePower();
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 23, Rarity.RARE, 9, 4, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("anvil_drop", (game, slot, target, source) -> {
            int opp = BattleGame.opposite(slot);
            if (game.getCard(opp) != null) {
                game.directAttack(opp, slot, 4);
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.anvil_drop.log1").m_7220_((Component)new TranslatableComponent(game.getCard(opp).m_5524_())).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.anvil_drop.log2")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.damageIcon(4), BuddycardBattleIcon.create(game.getCard(opp)))));
                game.updatePower(opp);
            }
            return true;
        })).add(BattleEvent.TURN.ability("reforge", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ADJACENT.apply(slot, game)) {
                if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_METAL)) continue;
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 1;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.addIcon(1));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.reforge.log"), icons));
                game.updatePower();
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 24, Rarity.RARE, 6, 2, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("push_back", (game, slot, target, source) -> {
            int opp = BattleGame.opposite(slot);
            BuddycardItem returnedCard = game.returnCard(opp);
            if (returnedCard != null) {
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(returnedCard.m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.push_back.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(returnedCard), TextureBattleIcon.returnIcon)));
            }
            return true;
        })).add(BattleEvent.POWERED.ability("empowered_push", (game, slot, target, source) -> {
            int opp = BattleGame.opposite(slot);
            BuddycardItem returnedCard = game.returnCard(opp);
            if (returnedCard != null) {
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(returnedCard.m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.empowered_push.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(returnedCard), TextureBattleIcon.returnIcon)));
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 25, Rarity.RARE, 7, 4, new BattleAbility.Builder().add(BattleEvent.DAMAGED.ability("prismarine_spines", (game, slot, target, source) -> {
            if (game.getCard(source) != null) {
                game.directAttack(source, slot, 1, false, false);
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(source).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.prismarine_spines.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(source)), TextureBattleIcon.subtractIcon(1))));
                game.updatePower(source);
            }
            return true;
        })).add(BattleEvent.TURN.ability("laser_gaze", (game, slot, target, source) -> {
            int opp = BattleGame.opposite(slot);
            if (game.getCard(opp) != null && game.container.turn / 2 % 2 == 1) {
                game.directAttack(opp, slot, 2);
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.laser_gaze.log1").m_7220_((Component)new TranslatableComponent(game.getCard(opp).m_5524_())).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.laser_gaze.log2")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.damageIcon(2), BuddycardBattleIcon.create(game.getCard(opp)))));
                game.updatePower(opp);
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 26, Rarity.EPIC, 8, 3, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("grand_creation", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            ArrayList<Pair> cards = new ArrayList<Pair>();
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                ItemStack card;
                if (game.getCard(i) != null) continue;
                ItemStack itemStack = card = BattleGame.getOwner(slot) ? game.container.deck1.m_7407_(BattleContainer.random.nextInt(16), 1) : game.container.deck2.m_7407_(BattleContainer.random.nextInt(16), 1);
                while (card.m_41619_()) {
                    card = BattleGame.getOwner(slot) ? game.container.deck1.m_7407_(BattleContainer.random.nextInt(16), 1) : game.container.deck2.m_7407_(BattleContainer.random.nextInt(16), 1);
                }
                cards.add(Pair.of((Object)i, (Object)card));
                icons.add(BuddycardBattleIcon.create((BuddycardItem)card.m_41720_()));
            }
            if (cards.size() > 0) {
                icons.add(TextureBattleIcon.playIcon);
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.grand_creation.log"), icons));
                game.updatePower();
                Object object = cards.iterator();
                while (object.hasNext()) {
                    Pair p = (Pair)object.next();
                    game.addCard((Integer)p.first, (ItemStack)p.second, (BuddycardItem)((ItemStack)p.second).m_41720_());
                }
            }
            return true;
        })).add(BattleEvent.DEATH.ability("craft_together", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            int power = 0;
            for (int i : (int[])BattleEvent.Distribution.ADJACENT.apply(slot, game)) {
                if (game.getCard(i) == null) continue;
                power += game.turnPower[i];
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
                game.removeCard(i);
            }
            if (power > 0) {
                int n = slot;
                game.turnPower[n] = game.turnPower[n] + power;
                icons.add(TextureBattleIcon.xIcon);
                icons.add(BuddycardBattleIcon.create(game.getCard(slot)));
                icons.add(TextureBattleIcon.addIcon(power));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.craft_together.log1").m_130946_("" + power).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.craft_together.log2")), icons));
                game.updatePower();
                return false;
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 27, Rarity.EPIC, 6, 3, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("smeltdown", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            ArrayList<Integer> cards = new ArrayList<Integer>();
            int power = 0;
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                if (slot == i || game.getCard(i) == null || game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_METAL)) continue;
                cards.add(i);
                power += 2;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (cards.size() > 0) {
                icons.add(TextureBattleIcon.deathIcon);
                icons.add(BuddycardBattleIcon.create(game.getCard(slot)));
                icons.add(TextureBattleIcon.addIcon(power));
                int n = slot;
                game.turnPower[n] = game.turnPower[n] + power;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.smeltdown.log1").m_130946_("" + power).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.smeltdown.log2")), icons));
                game.updatePower();
                Object object = cards.iterator();
                while (object.hasNext()) {
                    int i = (Integer)object.next();
                    if (!game.trigger(BattleEvent.DEATH, i)) continue;
                    game.removeCard(i);
                }
            }
            return true;
        })).add(BattleEvent.OBSERVE_DEATH.ability("flaming_forge", (game, slot, target, source) -> {
            if (!game.container.m_8020_(BattleGame.translateFrom(target)).m_204117_(BuddycardsMisc.BCB_FIRE)) {
                return true;
            }
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                if (i != slot && !game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_METAL)) continue;
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 2;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.addIcon(2));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.flaming_forge.log"), icons));
                game.updatePower();
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 28, Rarity.COMMON, 3, 2, new BattleAbility.Builder().add(BattleEvent.TURN.ability("thick_thicket", (game, slot, target, source) -> {
            for (int i : (int[])BattleEvent.Distribution.ADJACENT.apply(slot, game)) {
                if (game.getCard(i) != null) continue;
                return true;
            }
            int n = slot;
            game.turnPower[n] = game.turnPower[n] + 2;
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.thick_thicket.log"), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(2))));
            game.updatePower(slot);
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 29, Rarity.COMMON, 2, 2, new BattleAbility.Builder().add(BattleEvent.POWERED.ability("conduction", (game, slot, target, source) -> {
            int n = slot;
            game.turnPower[n] = game.turnPower[n] + 1;
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.conduction.log"), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(1))));
            game.updatePower(slot);
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 30, Rarity.COMMON, 2, 0, new BattleAbility.Builder().add(BattleEvent.DEATH.ability("courage_chime", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            ArrayList<Integer> cards = new ArrayList<Integer>();
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                if (i == slot || game.getCard(i) == null) continue;
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 1;
                cards.add(i);
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.addIcon(1));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.courage_chime.log"), icons));
                Object object = cards.iterator();
                while (object.hasNext()) {
                    int i = (Integer)object.next();
                    game.updatePower(i);
                }
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 31, Rarity.COMMON, 1, 2, new BattleAbility.Builder().add(BattleEvent.TURN.ability("drip_drop", (game, slot, target, source) -> {
            BuddycardItem returnedCard = game.returnCard(slot);
            if (returnedCard != null) {
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.drip_drop.log"), List.of(BuddycardBattleIcon.create(returnedCard), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(returnedCard), TextureBattleIcon.returnIcon)));
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 32, Rarity.UNCOMMON, 3, 1, new BattleAbility.Builder().add(BattleEvent.POWERED.ability("pulse_extender", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            ArrayList<Integer> cards = new ArrayList<Integer>();
            if (game.turnPower[slot] < 8) {
                for (int i : (int[])BattleEvent.Distribution.ADJACENT.apply(slot, game)) {
                    if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_REDSTONE)) continue;
                    cards.add(i);
                    icons.add(BuddycardBattleIcon.create(game.getCard(i)));
                    icons.add(TextureBattleIcon.doublePowerIcon);
                }
                icons.add(BuddycardBattleIcon.create(game.getCard(slot)));
                icons.add(TextureBattleIcon.addIcon(1));
                int n = slot;
                game.turnPower[n] = game.turnPower[n] + 1;
                game.updatePower(slot);
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.pulse_extender.log"), icons));
                Object object = cards.iterator();
                while (object.hasNext()) {
                    int i = (Integer)object.next();
                    game.trigger(BattleEvent.POWERED, i, i, slot);
                    game.trigger(BattleEvent.POWERED, i, i, slot);
                }
                return true;
            }
            icons.add(BuddycardBattleIcon.create(game.getCard(slot)));
            icons.add(TextureBattleIcon.deathIcon);
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.pulse_extender.log_2"), icons));
            game.trigger(BattleEvent.DEATH, slot, slot, slot);
            game.trigger(BattleEvent.OBSERVE_DEATH, slot, slot, slot, BattleEvent.Distribution.ALL);
            game.removeCard(slot);
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 33, Rarity.UNCOMMON, 4, 0, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("waiting_game", (game, slot, target, source) -> {
            int power = game.container.turn / 2;
            if (power > 0) {
                int n = slot;
                game.turnPower[n] = game.turnPower[n] + power;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.waiting_game.log1").m_130946_("" + power).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.waiting_game.log2")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(power))));
                game.updatePower();
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 34, Rarity.UNCOMMON, 4, 0, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("travel_game", (game, slot, target, source) -> {
            int power = 0;
            for (int i : (int[])BattleEvent.Distribution.ALL.apply(slot, game)) {
                if (game.getCard(i) == null) continue;
                ++power;
            }
            if (power > 0) {
                int n = slot;
                game.turnPower[n] = game.turnPower[n] + power;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.travel_game.log1").m_130946_("" + power).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.travel_game.log2")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(power))));
                game.updatePower();
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 35, Rarity.RARE, 4, 3, new BattleAbility.Builder().add(BattleEvent.KILL.ability("axo-regeneration", (game, slot, target, source) -> {
            game.state[slot].status = BattleStatusEffect.REGENERATION;
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.axo-regeneration.log"), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.statusIcon(BattleStatusEffect.REGENERATION))));
            game.updatePower();
            return true;
        })).add(BattleEvent.PLAYED.ability("rare_blue", (game, slot, target, source) -> {
            if (BattleContainer.random.nextInt(10) == 0) {
                int n = slot;
                game.turnPower[n] = game.turnPower[n] + 6;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.rare_blue.log"), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(6))));
                game.updatePower();
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(BASE_SET, 36, Rarity.RARE, 5, 3, new BattleAbility.Builder().add(BattleEvent.TURN.ability("railway", (game, slot, target, source) -> {
            for (int i : (int[])BattleEvent.Distribution.ADJACENT.apply(slot, game)) {
                if (game.getCard(i) != null) continue;
                BuddycardItem b = game.moveCard(slot, i);
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 2;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.railway.log"), List.of(BuddycardBattleIcon.create(b), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(b), TextureBattleIcon.returnIcon, TextureBattleIcon.addIcon(2))));
                game.updatePower(i);
                break;
            }
            return true;
        })).add(BattleEvent.POWERED.ability("mine_crash", (game, slot, target, source) -> {
            if (game.turnPower[slot] >= 10) {
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.mine_crash.log1").m_7220_(BattleGame.getOwner(slot) ? game.container.name2 : game.container.name1).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.mine_crash.log2")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.damageIcon(10))));
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 1, Rarity.COMMON, 4, 2, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("brick_toss", (game, slot, target, source) -> {
            int opp = BattleGame.opposite(slot);
            game.directAttack(opp, slot, 2);
            if (game.getCard(opp) != null) {
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.brick_toss.log1").m_7220_((Component)new TranslatableComponent(game.getCard(opp).m_5524_())).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.brick_toss.log2")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.damageIcon(2), BuddycardBattleIcon.create(game.getCard(opp)))));
                game.updatePower(opp);
            } else {
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.brick_toss.log1").m_7220_(BattleGame.getOwner(slot) ? game.container.name2 : game.container.name1).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.brick_toss.log2")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.damageIcon(2))));
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 2, Rarity.COMMON, 6, 3, new BattleAbility.Builder().add(BattleEvent.TURN.ability("tough_stuff", (game, slot, target, source) -> {
            int power = 3 - game.turnPower[slot];
            if (power > 0) {
                int n = slot;
                game.turnPower[n] = game.turnPower[n] + power;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.tough_stuff.log"), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(power))));
                game.updatePower();
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 3, Rarity.COMMON, 4, 2, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("radiant_glow", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ALL_ENEMY.apply(slot, game)) {
                if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_MONSTER)) continue;
                game.directAttack(BattleGame.opposite(slot), slot, 1, false, false);
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.subtractIcon(1));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.radiant_glow.log"), icons));
                game.updatePower();
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 4, Rarity.COMMON, 4, 2, new BattleAbility.Builder().add(BattleEvent.DEATH.ability("bounce_back", (game, slot, target, source) -> {
            BuddycardItem returnedCard = game.returnCard(slot);
            if (returnedCard != null) {
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.bounce_back"), List.of(BuddycardBattleIcon.create(returnedCard), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(returnedCard), TextureBattleIcon.returnIcon)));
                return false;
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 5, Rarity.COMMON, 5, 3, new BattleAbility.Builder().add(BattleEvent.DEATH.ability("hearty_bacon", (game, slot, target, source) -> {
            if (BattleGame.getOwner(slot)) {
                game.container.health1 += 2;
            } else {
                game.container.health2 += 2;
            }
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, TextureBattleIcon.healIcon(2)));
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                game.state[i].status = BattleStatusEffect.STRENGTH;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 3) {
                icons.add(TextureBattleIcon.statusIcon(BattleStatusEffect.STRENGTH));
            }
            game.container.addLog(new BattleComponent((Component)new TextComponent("").m_7220_(BattleGame.getOwner(slot) ? game.container.name1 : game.container.name2).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.hearty_bacon.log")), icons));
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 6, Rarity.COMMON, 3, 2, new BattleAbility.Builder().add(BattleEvent.KILL.ability("soul_steal", (game, slot, target, source) -> {
            if (BattleGame.getOwner(slot)) {
                ++game.container.health1;
            } else {
                ++game.container.health2;
            }
            game.container.addLog(new BattleComponent((Component)new TextComponent("").m_7220_(BattleGame.getOwner(slot) ? game.container.name1 : game.container.name2).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.soul_steal.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, TextureBattleIcon.healIcon(1))));
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 7, Rarity.COMMON, 3, 2, new BattleAbility.Builder().add(BattleEvent.FIGHT.ability("igneous_extrusion", (game, slot, target, source) -> {
            if (game.state[slot].status.equals((Object)BattleStatusEffect.FIRE)) {
                int n = slot;
                game.turnPower[n] = game.turnPower[n] + 2;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.igneous_extrusion.log"), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(2))));
                game.updatePower(slot);
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 8, Rarity.COMMON, 4, 3, new BattleAbility.Builder().add(BattleEvent.FIGHT.ability("warped_growth", (game, slot, target, source) -> {
            if (game.isP1() != BattleGame.getOwner(slot)) {
                return true;
            }
            for (int i : (int[])BattleEvent.Distribution.ROW_OTHER.apply(slot, game)) {
                if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_FUNGAL)) continue;
                int n = slot;
                game.turnPower[n] = game.turnPower[n] + 1;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.warped_growth.log"), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(1))));
                game.updatePower(slot);
                break;
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 9, Rarity.COMMON, 3, 2, new BattleAbility.Builder().add(BattleEvent.DEATH.ability("warping_spores", (game, slot, target, source) -> {
            if (source != slot && game.getCard(source) != null) {
                game.state[source].status = BattleStatusEffect.SLEEP;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(source).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.warping_spores.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(source)), TextureBattleIcon.statusIcon(BattleStatusEffect.SLEEP))));
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 10, Rarity.COMMON, 2, 1, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("spreading_spores", (game, slot, target, source) -> {
            for (int i : (int[])BattleEvent.Distribution.ROW_OTHER.apply(slot, game)) {
                if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_FUNGAL)) continue;
                if (!game.container.tryDrawCard(game.isP1())) break;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.warped_growth.log"), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, TextureBattleIcon.drawIcon)));
                break;
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 11, Rarity.COMMON, 2, 1, new BattleAbility.Builder().add(BattleEvent.DAMAGED.ability("spicy_flames", (game, slot, target, source) -> {
            if (source != slot && game.getCard(source) != null) {
                game.state[source].status = BattleStatusEffect.FIRE;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(source).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.spicy_flames.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(source)), TextureBattleIcon.statusIcon(BattleStatusEffect.FIRE))));
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 12, Rarity.COMMON, 6, 1, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("meltdown", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ALL.apply(slot, game)) {
                if (game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_FIRE)) continue;
                game.state[i].status = BattleStatusEffect.FIRE;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.statusIcon(BattleStatusEffect.FIRE));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.meltdown.log"), icons));
                game.updatePower();
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 13, Rarity.UNCOMMON, 5, 2, new BattleAbility.Builder().add(BattleEvent.FIGHT.ability("withering_strike", (game, slot, target, source) -> {
            int opp = BattleGame.opposite(slot);
            if (game.getCard(opp) != null) {
                game.state[opp].status = BattleStatusEffect.WITHER;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(opp).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.withering_strike.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(opp)), TextureBattleIcon.statusIcon(BattleStatusEffect.WITHER))));
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 14, Rarity.UNCOMMON, 6, 2, new BattleAbility.Builder().add(BattleEvent.ACTIVATED.ability("flaming_shot", (game, slot, target, source) -> {
            boolean p1 = BattleGame.getOwner(slot);
            int opp = BattleGame.opposite(slot);
            if (game.container.energy(p1) >= 1 && game.getCard(opp) != null) {
                game.container.spendEnergy(p1, 1);
                game.state[opp].status = BattleStatusEffect.FIRE;
                game.directAttack(opp, slot, 1, false, false);
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(opp).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.flaming_shot.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.energyIcon(1), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(opp)), TextureBattleIcon.statusIcon(BattleStatusEffect.FIRE), TextureBattleIcon.subtractIcon(1))));
                game.updatePower(opp);
                return true;
            }
            return false;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 15, Rarity.UNCOMMON, 4, 2, new BattleAbility.Builder().add(BattleEvent.POWERED.ability("subtraction", (game, slot, target, source) -> {
            int opp = BattleGame.opposite(slot);
            if (game.getCard(opp) != null) {
                game.directAttack(target, slot, 1, false, false);
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(target).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.subtraction.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(opp)), TextureBattleIcon.subtractIcon(1))));
                game.updatePower(target);
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 16, Rarity.UNCOMMON, 3, 2, new BattleAbility.Builder().add(BattleEvent.DEATH.ability("fire_resistance", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            ArrayList<Integer> cards = new ArrayList<Integer>();
            for (int i : (int[])BattleEvent.Distribution.ROW_OTHER.apply(slot, game)) {
                if (game.getCard(i) == null || !game.state[i].status.equals((Object)BattleStatusEffect.FIRE)) continue;
                game.state[i].status = BattleStatusEffect.EMPTY;
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 2;
                cards.add(i);
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.statusIcon(BattleStatusEffect.EMPTY));
                icons.add(TextureBattleIcon.addIcon(2));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.fire_resistance.log"), icons));
                Object object = cards.iterator();
                while (object.hasNext()) {
                    int i = (Integer)object.next();
                    game.updatePower(i);
                }
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 17, Rarity.UNCOMMON, 6, 4, new BattleAbility.Builder().add(BattleEvent.DAMAGED.ability("tough_tears", (game, slot, target, source) -> {
            int n = slot;
            game.turnPower[n] = game.turnPower[n] + 1;
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.tough_tears.log"), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(1))));
            game.updatePower(slot);
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 18, Rarity.UNCOMMON, 4, 1, new BattleAbility.Builder().add(BattleEvent.DAMAGED.ability("spirit_flames", (game, slot, target, source) -> {
            if (source != slot && game.getCard(source) != null) {
                game.state[source].status = BattleStatusEffect.FIRE;
                int n = source;
                game.turnPower[n] = game.turnPower[n] - 1;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(source).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.spirit_flames.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(source)), TextureBattleIcon.statusIcon(BattleStatusEffect.FIRE), TextureBattleIcon.subtractIcon(1))));
                game.updatePower(source);
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 19, Rarity.UNCOMMON, 5, 2, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("soul_light", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ALL_ENEMY.apply(slot, game)) {
                if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_MONSTER)) continue;
                int n = i;
                game.turnPower[n] = game.turnPower[n] - 1;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.subtractIcon(2));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.soul_light.log"), icons));
                game.updatePower();
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 20, Rarity.UNCOMMON, 8, 2, new BattleAbility.Builder().add(BattleEvent.ACTIVATED.ability("fire_spitball", (game, slot, target, source) -> {
            boolean p1 = BattleGame.getOwner(slot);
            int opp = BattleGame.opposite(slot);
            if (game.container.energy(p1) >= 2 && game.getCard(opp) != null) {
                game.container.spendEnergy(p1, 2);
                game.state[opp].status = BattleStatusEffect.FIRE;
                game.directAttack(opp, slot, 2, false, false);
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(opp).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.fire_spitball.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.energyIcon(2), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(opp)), TextureBattleIcon.statusIcon(BattleStatusEffect.FIRE), TextureBattleIcon.subtractIcon(2))));
                game.updatePower(opp);
                return true;
            }
            return false;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 21, Rarity.UNCOMMON, 5, 3, new BattleAbility.Builder().add(BattleEvent.FIGHT.ability("magmawalk", (game, slot, target, source) -> {
            for (int i : (int[])BattleEvent.Distribution.ROW_OTHER.apply(slot, game)) {
                if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_FIRE)) continue;
                int damage = game.turnPower[slot];
                if (BattleGame.getOwner(slot)) {
                    game.container.health2 -= damage;
                } else {
                    game.container.health1 -= damage;
                }
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(slot).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.magmawalk.log1")).m_130946_("" + damage).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.magmawalk.log2")).m_7220_(BattleGame.getOwner(slot) ? game.container.name2 : game.container.name1).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.magmawalk.log3")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.damageIcon(damage))));
                return false;
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 22, Rarity.RARE, 9, 3, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("furious_cocktail", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                BattleStatusEffect effect;
                if (game.getCard(i) == null) continue;
                game.state[i].status = effect = (switch (BattleContainer.random.nextInt(3)) {
                    case 0 -> BattleStatusEffect.STRENGTH;
                    case 1 -> BattleStatusEffect.REGENERATION;
                    default -> BattleStatusEffect.RESISTANCE;
                });
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
                icons.add(TextureBattleIcon.statusIcon(effect));
            }
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.furious_cocktail.log"), icons));
            return true;
        })).add(BattleEvent.ACTIVATED.ability("splashy_potion", (game, slot, target, source) -> {
            boolean p1 = BattleGame.getOwner(slot);
            if (game.container.energy(p1) >= 5) {
                ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.energyIcon(5), TextureBattleIcon.dividerIcon));
                for (int i : (int[])BattleEvent.Distribution.ROW_OTHER.apply(slot, game)) {
                    BattleStatusEffect effect;
                    if (game.getCard(i) == null) continue;
                    game.state[i].status = effect = (switch (BattleContainer.random.nextInt(3)) {
                        case 0 -> BattleStatusEffect.POISON;
                        case 1 -> BattleStatusEffect.WEAKNESS;
                        default -> BattleStatusEffect.WITHER;
                    });
                    icons.add(BuddycardBattleIcon.create(game.getCard(i)));
                    icons.add(TextureBattleIcon.statusIcon(effect));
                }
                if (icons.size() > 2) {
                    game.container.spendEnergy(p1, 5);
                    game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.splashy_potion.log"), icons));
                    return true;
                }
            }
            return false;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 23, Rarity.RARE, 10, 6, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("hellish_welcome", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                if (!((BuddycardItem)game.container.m_8020_(BattleGame.translateFrom(i)).m_41720_()).getSet().equals(NETHER_SET)) continue;
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 1;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.addIcon(1));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.hellish_welcome.log"), icons));
                game.updatePower();
            }
            return true;
        })).add(BattleEvent.DEATH.ability("unwelcome_guest", (game, slot, target, source) -> {
            BuddycardItem bc;
            Item patt67281$temp;
            ItemStack card;
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            ItemStack itemStack = card = BattleGame.getOwner(slot) ? game.container.deck1.m_7407_(BattleContainer.random.nextInt(16), 1) : game.container.deck2.m_7407_(BattleContainer.random.nextInt(16), 1);
            for (int override = 0; !((patt67281$temp = card.m_41720_()) instanceof BuddycardItem && (bc = (BuddycardItem)patt67281$temp).getSet().equals(NETHER_SET) || override >= 32); ++override) {
                card = BattleGame.getOwner(slot) ? game.container.deck1.m_7407_(BattleContainer.random.nextInt(16), 1) : game.container.deck2.m_7407_(BattleContainer.random.nextInt(16), 1);
                icons.add(BuddycardBattleIcon.create((BuddycardItem)card.m_41720_()));
            }
            Item patt67741$temp = card.m_41720_();
            if (patt67741$temp instanceof BuddycardItem && (bc = (BuddycardItem)patt67741$temp).getSet().equals(NETHER_SET)) {
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(slot).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.log.buddycards.death")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.deathIcon)));
                game.removeCard(slot);
                icons.add(TextureBattleIcon.playIcon);
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.grand_creation.log"), icons));
                game.updatePower();
                game.addCard(slot, card, (BuddycardItem)card.m_41720_());
                return false;
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 24, Rarity.RARE, 7, 4, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("withering_heights", (game, slot, target, source) -> {
            game.state[slot].status = BattleStatusEffect.AIRBORNE;
            game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.withering_heights.log"), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.statusIcon(BattleStatusEffect.AIRBORNE))));
            return true;
        })).add(BattleEvent.ACTIVATED.ability("withering_shot", (game, slot, target, source) -> {
            boolean p1 = BattleGame.getOwner(slot);
            int opp = BattleGame.opposite(slot);
            if (game.container.energy(p1) >= 2 && game.getCard(opp) != null) {
                game.container.spendEnergy(p1, 2);
                game.state[opp].status = BattleStatusEffect.WITHER;
                game.directAttack(opp, slot, 1, false, false);
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(opp).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.withering_shot.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.energyIcon(2), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(opp)), TextureBattleIcon.statusIcon(BattleStatusEffect.WITHER), TextureBattleIcon.subtractIcon(2))));
                game.updatePower(opp);
                return true;
            }
            return false;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 25, Rarity.RARE, 7, 4, new BattleAbility.Builder().add(BattleEvent.OBSERVE_DEATH.ability("charged_respawn", (game, slot, target, source) -> {
            if (game.turnPower[slot] > 0) {
                int n = slot;
                game.turnPower[n] = game.turnPower[n] - 1;
                game.turnPower[target] = 1;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(target).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.charged_respawn.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.subtractIcon(1), BuddycardBattleIcon.create(game.getCard(target)), TextureBattleIcon.equalsIcon(1))));
                game.updatePower(slot);
                game.updatePower(target);
                return false;
            }
            return true;
        })).add(BattleEvent.ACTIVATED.ability("respawn_recharge", (game, slot, target, source) -> {
            boolean p1 = BattleGame.getOwner(slot);
            if (game.container.energy(p1) >= 2) {
                game.container.spendEnergy(p1, 2);
                int n = slot;
                game.turnPower[n] = game.turnPower[n] + 1;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.respawn_recharge.log"), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.energyIcon(2), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(1))));
                game.updatePower(slot);
                return true;
            }
            return false;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 26, Rarity.EPIC, 10, 5, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("beacon_buff", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ROW_OTHER.apply(slot, game)) {
                if (game.getCard(i) == null) continue;
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 2;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
            }
            if (icons.size() > 2) {
                icons.add(TextureBattleIcon.addIcon(2));
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.beacon_buff.log"), icons));
                game.updatePower();
            }
            return true;
        })).add(BattleEvent.ACTIVATED.ability("color_shift", (game, slot, target, source) -> {
            boolean p1 = BattleGame.getOwner(slot);
            if (game.container.energy(p1) >= 4) {
                ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.energyIcon(4), TextureBattleIcon.dividerIcon));
                BattleStatusEffect effect = switch (BattleContainer.random.nextInt(3)) {
                    case 0 -> BattleStatusEffect.STRENGTH;
                    case 1 -> BattleStatusEffect.REGENERATION;
                    default -> BattleStatusEffect.RESISTANCE;
                };
                for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                    if (game.getCard(i) == null) continue;
                    game.state[i].status = effect;
                    icons.add(BuddycardBattleIcon.create(game.getCard(i)));
                }
                if (icons.size() > 3) {
                    icons.add(TextureBattleIcon.statusIcon(effect));
                    game.container.spendEnergy(p1, 4);
                    game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.color_shift.log"), icons));
                    return true;
                }
            }
            return false;
        })).build());
        BuddycardsItems.registerCard(NETHER_SET, 27, Rarity.EPIC, 9, 4, new BattleAbility.Builder().add(BattleEvent.PLAYED.ability("ancient_coating", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            ArrayList<Integer> cards = new ArrayList<Integer>();
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                if (game.getCard(i) == null) continue;
                cards.add(i);
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
                if (game.state[slot].status.equals((Object)BattleStatusEffect.FIRE) || game.container.m_8020_(BattleGame.translateFrom(BattleGame.opposite(i))).m_204117_(BuddycardsMisc.BCB_FIRE)) {
                    int n = i;
                    game.turnPower[n] = game.turnPower[n] + 4;
                    icons.add(TextureBattleIcon.addIcon(4));
                    continue;
                }
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 2;
                icons.add(TextureBattleIcon.addIcon(2));
            }
            if (cards.size() > 0) {
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.ancient_coating.log"), icons));
                Object object = cards.iterator();
                while (object.hasNext()) {
                    int i = (Integer)object.next();
                    game.updatePower(i);
                }
            }
            return true;
        })).add(BattleEvent.ACTIVATED.ability("gear_upgrade", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.xIcon, TextureBattleIcon.dividerIcon));
            ArrayList<Integer> cards = new ArrayList<Integer>();
            for (int i : (int[])BattleEvent.Distribution.ROW_OTHER.apply(slot, game)) {
                if (game.getCard(i) == null) continue;
                cards.add(i);
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
                if (game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_ENCHANTABLE)) {
                    int n = i;
                    game.turnPower[n] = game.turnPower[n] + game.turnPower[slot];
                    icons.add(TextureBattleIcon.addIcon(game.turnPower[slot]));
                    continue;
                }
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 1;
                icons.add(TextureBattleIcon.addIcon(1));
            }
            if (cards.size() > 0) {
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.gear_upgrade"), icons));
                game.removeCard(slot);
                Object object = cards.iterator();
                while (object.hasNext()) {
                    int i = (Integer)object.next();
                    game.updatePower(i);
                }
            }
            return true;
        })).build());
        BuddycardsItems.registerCard(END_SET, 1, Rarity.COMMON, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 2, Rarity.COMMON, 4, 2, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 3, Rarity.COMMON, 4, 2, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 4, Rarity.COMMON, 6, 4, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 5, Rarity.COMMON, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 6, Rarity.COMMON, 6, 4, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 7, Rarity.COMMON, 1, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 8, Rarity.COMMON, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 9, Rarity.COMMON, 2, 2, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 10, Rarity.COMMON, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 11, Rarity.COMMON, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 12, Rarity.COMMON, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 13, Rarity.UNCOMMON, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 14, Rarity.UNCOMMON, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 15, Rarity.UNCOMMON, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 16, Rarity.UNCOMMON, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 17, Rarity.UNCOMMON, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 18, Rarity.UNCOMMON, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 19, Rarity.UNCOMMON, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 20, Rarity.UNCOMMON, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 21, Rarity.UNCOMMON, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 22, Rarity.RARE, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 23, Rarity.RARE, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 24, Rarity.RARE, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 25, Rarity.RARE, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 26, Rarity.EPIC, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerCard(END_SET, 27, Rarity.EPIC, 2, 1, DEFAULT_NO_ABILITIES);
        BuddycardsItems.registerReprintCard(HOLIDAY_SET, 1, Rarity.UNCOMMON, HALLOWEEN_BUDDYCARD_REQUIREMENT, 4, 2, new BattleAbility.Builder().add(BattleEvent.FIGHT.ability("lazy_cat", (game, slot, target, source) -> {
            if (game.turnPower[slot] < 2 && game.isP1() == BattleGame.getOwner(slot)) {
                int n = slot;
                game.turnPower[n] = game.turnPower[n] + 2;
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.lazy_cat.log"), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.addIcon(2))));
                game.updatePower(slot);
                return false;
            }
            return true;
        })).build(), BASE_SET, 14);
        BuddycardsItems.registerReprintCard(HOLIDAY_SET, 2, Rarity.UNCOMMON, HALLOWEEN_BUDDYCARD_REQUIREMENT, 4, 1, new BattleAbility.Builder().add(BattleEvent.FIGHT.ability("spook_em", (game, slot, target, source) -> {
            if (target != slot && game.getCard(target) != null && game.isP1() == BattleGame.getOwner(slot)) {
                game.directAttack(target, slot, 1, false, false);
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent(game.getCard(target).m_5524_()).m_7220_((Component)new TranslatableComponent("battles.ability.buddycards.spook_em.log")), List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon, BuddycardBattleIcon.create(game.getCard(target)), TextureBattleIcon.subtractIcon(1))));
                game.updatePower(target);
            }
            return true;
        })).build(), BASE_SET, 21);
        BuddycardsItems.registerReprintCard(HOLIDAY_SET, 3, Rarity.COMMON, HALLOWEEN_BUDDYCARD_REQUIREMENT, 2, 1, DEFAULT_NO_ABILITIES, END_SET, 4);
        BuddycardsItems.registerReprintCard(HOLIDAY_SET, 4, Rarity.COMMON, CHRISTMAS_BUDDYCARD_REQUIREMENT, 3, 2, new BattleAbility.Builder().add(BattleEvent.DEATH.ability("stoke_flames", (game, slot, target, source) -> {
            ArrayList<IBattleIcon> icons = new ArrayList<IBattleIcon>(List.of(BuddycardBattleIcon.create(game.getCard(slot)), TextureBattleIcon.dividerIcon));
            for (int i : (int[])BattleEvent.Distribution.ROW.apply(slot, game)) {
                if (!game.container.m_8020_(BattleGame.translateFrom(i)).m_204117_(BuddycardsMisc.BCB_FIRE)) continue;
                int n = i;
                game.turnPower[n] = game.turnPower[n] + 1;
                icons.add(BuddycardBattleIcon.create(game.getCard(i)));
                icons.add(TextureBattleIcon.addIcon(1));
            }
            if (icons.size() > 2) {
                game.container.addLog(new BattleComponent((Component)new TranslatableComponent("battles.ability.buddycards.stoke_flames.log"), icons));
                game.updatePower();
            }
            return true;
        })).build(), BASE_SET, 4);
        BuddycardsItems.registerReprintCard(HOLIDAY_SET, 5, Rarity.COMMON, CHRISTMAS_BUDDYCARD_REQUIREMENT, 2, 1, DEFAULT_NO_ABILITIES, END_SET, 2);
        BuddycardsItems.registerCard(HOLIDAY_SET, 6, Rarity.UNCOMMON, CHRISTMAS_BUDDYCARD_REQUIREMENT, 2, 1, DEFAULT_NO_ABILITIES);
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static RegistryObject<BuddycardItem> registerCard(BuddycardSet set, int cardNumber, Rarity rarity, Item.Properties properties, BuddycardRequirement requirement, int cost, int power, ListMultimap<BattleEvent, BattleAbility> abilities) {
        Objects.requireNonNull(set);
        return ITEMS.register("buddycard_" + set.getName() + cardNumber, () -> new BuddycardItem(requirement, set, cardNumber, rarity, properties, cost, power, abilities));
    }

    public static RegistryObject<BuddycardItem> registerCard(BuddycardSet set, int cardNumber, Rarity rarity, BuddycardRequirement requirement, int cost, int power, ListMultimap<BattleEvent, BattleAbility> abilities) {
        return BuddycardsItems.registerCard(set, cardNumber, rarity, DEFAULT_CARD_PROPERTIES, requirement, cost, power, abilities);
    }

    public static RegistryObject<BuddycardItem> registerCard(BuddycardSet set, int cardNumber, Rarity rarity, int cost, int power, ListMultimap<BattleEvent, BattleAbility> abilities) {
        return BuddycardsItems.registerCard(set, cardNumber, rarity, DEFAULT_CARD_PROPERTIES, DEFAULT_BUDDYCARD_REQUIREMENT, cost, power, abilities);
    }

    public static RegistryObject<BuddycardItem> registerReprintCard(BuddycardSet set, int cardNumber, Rarity rarity, Item.Properties properties, BuddycardRequirement requirement, int cost, int power, ListMultimap<BattleEvent, BattleAbility> abilities, BuddycardSet originalSet, int originalCardNum) {
        Objects.requireNonNull(set);
        return ITEMS.register("buddycard_" + set.getName() + cardNumber, () -> new BuddycardReprintItem(requirement, set, cardNumber, rarity, properties, cost, power, abilities, originalSet, originalCardNum));
    }

    public static RegistryObject<BuddycardItem> registerReprintCard(BuddycardSet set, int cardNumber, Rarity rarity, BuddycardRequirement requirement, int cost, int power, ListMultimap<BattleEvent, BattleAbility> abilities, BuddycardSet originalSet, int originalCardNum) {
        return BuddycardsItems.registerReprintCard(set, cardNumber, rarity, DEFAULT_CARD_PROPERTIES, requirement, cost, power, abilities, originalSet, originalCardNum);
    }

    public static interface BuddycardRequirement {
        public boolean shouldLoad();
    }
}

