/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.savedata;

import com.wildcard.buddycards.core.BuddycardSet;
import com.wildcard.buddycards.core.BuddycardsAPI;
import com.wildcard.buddycards.item.BuddycardItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class BuddycardCollectionSaveData
extends SavedData {
    private static final Map<UUID, Map<String, Set<Integer>>> CARD_LISTS = new HashMap<UUID, Map<String, Set<Integer>>>();

    public BuddycardCollectionSaveData() {
    }

    public BuddycardCollectionSaveData(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("collections", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag playerDataNbt = list.m_128728_(i);
            ListTag setsNbt = playerDataNbt.m_128437_("sets", 10);
            HashMap playerData = new HashMap();
            for (int j = 0; j < setsNbt.size(); ++j) {
                CompoundTag setNbt = setsNbt.m_128728_(j);
                ListTag cardsNbt = setNbt.m_128437_("cards", 10);
                HashSet<Integer> cards = new HashSet<Integer>();
                for (int k = 0; k < cardsNbt.size(); ++k) {
                    CompoundTag cardNbt = cardsNbt.m_128728_(k);
                    cards.add(cardNbt.m_128451_("number"));
                }
                playerData.put(setNbt.m_128461_("name"), cards);
            }
            CARD_LISTS.put(playerDataNbt.m_128342_("uuid"), playerData);
        }
    }

    public static BuddycardCollectionSaveData get(ServerLevel world) {
        return (BuddycardCollectionSaveData)world.m_8895_().m_164861_(BuddycardCollectionSaveData::new, BuddycardCollectionSaveData::new, "buddycards_collections");
    }

    public static BuddycardCollectionSaveData getPerfect(ServerLevel world) {
        return (BuddycardCollectionSaveData)world.m_8895_().m_164861_(BuddycardCollectionSaveData::new, BuddycardCollectionSaveData::new, "buddycards_perfect_collections");
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (Map.Entry<UUID, Map<String, Set<Integer>>> i : CARD_LISTS.entrySet()) {
            CompoundTag playerData = new CompoundTag();
            ListTag sets = new ListTag();
            for (Map.Entry<String, Set<Integer>> j : i.getValue().entrySet()) {
                CompoundTag set = new CompoundTag();
                ListTag cards = new ListTag();
                for (int k : j.getValue()) {
                    CompoundTag card = new CompoundTag();
                    card.m_128405_("number", k);
                    cards.add((Object)card);
                }
                set.m_128359_("name", j.getKey());
                set.m_128365_("cards", (Tag)cards);
                sets.add((Object)set);
            }
            playerData.m_128362_("uuid", i.getKey());
            playerData.m_128365_("sets", (Tag)sets);
            list.add((Object)playerData);
        }
        nbt.m_128365_("collections", (Tag)list);
        return nbt;
    }

    public boolean checkPlayerSetCompleted(UUID uuid, BuddycardSet set) {
        return this.checkPlayerSetCompletion(uuid, set).calc() >= 1.0f;
    }

    public Fraction checkPlayerSetCompletion(UUID uuid, BuddycardSet set) {
        String setName = set.getName();
        int foundCards = 0;
        if (CARD_LISTS.containsKey(uuid) && CARD_LISTS.get(uuid).containsKey(setName)) {
            foundCards += CARD_LISTS.get(uuid).get(setName).size();
        }
        return new Fraction(foundCards, set.getCards().size());
    }

    public Fraction checkPlayerTotalCompletion(UUID uuid) {
        Map<String, Set<Integer>> playerCollection = CARD_LISTS.get(uuid);
        if (playerCollection != null) {
            int foundCards = 0;
            int totalCards = 0;
            for (BuddycardSet set : BuddycardsAPI.getAllCardsets()) {
                Set playerSet = playerCollection.getOrDefault(set.getName(), new HashSet());
                for (BuddycardItem card : set.getCards()) {
                    if (!card.shouldLoad()) continue;
                    ++totalCards;
                    if (!playerSet.contains(card.getCardNumber())) continue;
                    ++foundCards;
                }
            }
            return new Fraction(foundCards, totalCards);
        }
        return new Fraction(0, BuddycardsAPI.getAllCards().stream().filter(BuddycardItem::shouldLoad).toList().size());
    }

    public void addPlayerCardFound(UUID uuid, BuddycardItem item) {
        this.addPlayerCardFound(uuid, item.getSet(), item.getCardNumber());
    }

    public void addPlayerCardFound(UUID uuid, BuddycardSet set, int cardNumber) {
        CARD_LISTS.computeIfAbsent(uuid, key -> new HashMap()).computeIfAbsent(set.getName(), key -> new HashSet()).add(cardNumber);
        this.m_77762_();
    }

    public static class Fraction {
        public final int top;
        public final int bottom;

        Fraction(int i, int j) {
            this.top = i;
            this.bottom = j;
        }

        public float calc() {
            return (float)this.top / (float)this.bottom;
        }
    }
}

