/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wildcard.buddycards.battles.BattleComponent;
import com.wildcard.buddycards.battles.BuddycardBattleIcon;
import com.wildcard.buddycards.battles.IBattleIcon;
import com.wildcard.buddycards.battles.TextureBattleIcon;
import com.wildcard.buddycards.battles.game.BattleGame;
import com.wildcard.buddycards.battles.game.BattleStatusEffect;
import com.wildcard.buddycards.item.BuddycardItem;
import com.wildcard.buddycards.menu.PlaymatMenu;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PlaymatScreen
extends AbstractContainerScreen<PlaymatMenu> {
    public static final ResourceLocation TEXTURE1 = new ResourceLocation("buddycards", "textures/gui/playmat.png");
    public static final ResourceLocation smallFont = new ResourceLocation("buddycards", "smallnumbers");
    private float scrollPosition = 0.0f;

    public PlaymatScreen(PlaymatMenu container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 88;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 141, this.f_97736_ + 40, 20, 18, 176, 0, 18, TEXTURE1, btn -> this.sendButtonPress(1)));
        this.scrollPosition = 0.0f;
    }

    private void sendButtonPress(int buttonId) {
        this.f_96541_.f_91072_.m_105208_(((PlaymatMenu)this.f_97732_).f_38840_, buttonId);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ItemStack stack;
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        int selectedSlot = ((PlaymatMenu)this.f_97732_).selectedSlot.m_6501_();
        if (selectedSlot != -999 && !(stack = ((PlaymatMenu)this.f_97732_).container.m_8020_(selectedSlot)).m_41619_()) {
            PoseStack posestack = RenderSystem.m_157191_();
            posestack.m_85836_();
            posestack.m_85837_(0.0, 0.0, 32.0);
            RenderSystem.m_157182_();
            this.m_93250_(200);
            this.f_96542_.f_115093_ = 200.0f;
            this.f_96542_.m_115203_(stack, mouseX - 8, mouseY - 8);
            this.m_93250_(0);
            this.f_96542_.f_115093_ = 0.0f;
            posestack.m_85849_();
        }
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
        this.f_96547_.m_92889_(matrixStack, this.f_96539_, 8.0f, 6.0f, 0x404040);
        this.f_96547_.m_92883_(matrixStack, Integer.toString(((PlaymatMenu)this.f_97732_).opponentEnergy.m_6501_()), 20.0f, 22.0f, 0x404040);
        this.f_96547_.m_92883_(matrixStack, Integer.toString(((PlaymatMenu)this.f_97732_).opponentHealth.m_6501_()), 51.0f, 22.0f, 0x404040);
        this.f_96547_.m_92883_(matrixStack, Integer.toString(((PlaymatMenu)this.f_97732_).energy.m_6501_()), 20.0f, 40.0f, 0x404040);
        this.f_96547_.m_92883_(matrixStack, Integer.toString(((PlaymatMenu)this.f_97732_).health.m_6501_()), 51.0f, 40.0f, 0x404040);
        this.renderBattleLog(matrixStack, x, y);
        this.renderCardPower(matrixStack);
    }

    private void renderBattleLog(PoseStack poseStack, int mouseX, int mouseY) {
        int scale = (int)this.f_96541_.m_91268_().m_85449_();
        ScrollerData data = ScrollerData.fromScreen(this);
        RenderSystem.m_69488_((int)((this.f_97735_ - 103) * scale), (int)((this.f_97736_ - data.drawableHeight() + this.f_97727_ - 7) * scale), (int)(98 * scale), (int)((data.drawableHeight() + 4) * scale));
        int height = 6;
        ResourceLocation lastDraw = null;
        for (BattleComponent battleComponent : ((PlaymatMenu)this.m_6262_()).getBattleLog()) {
            int leftShift = -103;
            for (IBattleIcon battleIcon : battleComponent.getBattleIcons()) {
                if (battleIcon instanceof BuddycardBattleIcon) {
                    BuddycardBattleIcon buddycardBattleIcon = (BuddycardBattleIcon)battleIcon;
                    this.f_96542_.m_174229_((LivingEntity)this.f_96541_.f_91074_, buddycardBattleIcon.getItem().m_7968_(), leftShift - 4, height - 2 - data.scrollerOffset(this.scrollPosition), 0);
                    lastDraw = null;
                } else if (battleIcon instanceof TextureBattleIcon) {
                    TextureBattleIcon t = (TextureBattleIcon)battleIcon;
                    if (t.texture() != lastDraw) {
                        lastDraw = t.texture();
                        RenderSystem.m_157179_((int)0, (ResourceLocation)lastDraw);
                    }
                    this.m_93228_(poseStack, leftShift, height - data.scrollerOffset(this.scrollPosition), t.texturePosX(), t.texturePosY(), battleIcon.width(), 12);
                    poseStack.m_85836_();
                    RenderSystem.m_69465_();
                    for (TextureBattleIcon.BattleInfo battleInfo : t.info()) {
                        MutableComponent text = new TextComponent(battleInfo.display()).m_130938_(style -> style.m_131150_(smallFont));
                        this.f_96547_.m_92889_(poseStack, (Component)text, (float)(leftShift + battleInfo.x() - (battleInfo.isLeftAligned() ? 0 : this.f_96547_.m_92852_((FormattedText)text))), (float)(height + battleInfo.y() - data.scrollerOffset(this.scrollPosition)), battleInfo.color());
                    }
                    RenderSystem.m_69482_();
                    poseStack.m_85849_();
                }
                leftShift += battleIcon.width() + 2;
            }
            height += 14;
        }
        int xMouseScreen = mouseX - this.f_97735_;
        int yMouseScreen = mouseY - this.f_97736_;
        int tooltipRow = (yMouseScreen - 6 + data.scrollerOffset(this.scrollPosition)) / 14;
        List<BattleComponent> battleLog = ((PlaymatMenu)this.f_97732_).getBattleLog();
        RenderSystem.m_69471_();
        if (tooltipRow >= 0 && tooltipRow < battleLog.size() && yMouseScreen > 0 && mouseX > this.f_97735_ - 103 && mouseX < this.f_97735_) {
            this.m_96602_(poseStack, battleLog.get(tooltipRow).getHoverText(), xMouseScreen, yMouseScreen);
        }
    }

    private void renderCardPower(PoseStack poseStack) {
        BattleGame game = ((PlaymatMenu)this.m_6262_()).container.game;
        for (int i = 0; i < 6; ++i) {
            Slot slot = ((PlaymatMenu)this.m_6262_()).m_38853_(i + 5);
            ItemStack itemStack = slot.m_7993_();
            Item item = itemStack.m_41720_();
            if (!(item instanceof BuddycardItem)) continue;
            BuddycardItem card = (BuddycardItem)item;
            int position = ((PlaymatMenu)this.f_97732_).entity.p1 ? i : BattleGame.opposite(i);
            int power = game.state[position].power;
            ChatFormatting color = power == 0 ? ChatFormatting.RED : (power >= card.getPower() ? ChatFormatting.GREEN : ChatFormatting.YELLOW);
            MutableComponent text = new TextComponent("" + power).m_130938_(style -> style.m_131150_(smallFont));
            this.f_96547_.m_92889_(poseStack, (Component)text, (float)(slot.f_40220_ + 13), (float)(slot.f_40221_ + (i < 3 ? 8 : -1)), Objects.requireNonNull(color.m_126665_()).intValue());
            if (game.state[position].status.equals((Object)BattleStatusEffect.EMPTY)) continue;
            BattleStatusEffect status = game.state[position].status;
            text = new TextComponent(Character.toString(3792 + status.ordinal())).m_130938_(style -> style.m_131150_(smallFont));
            this.f_96547_.m_92889_(poseStack, (Component)text, (float)(slot.f_40220_ + 13), (float)(slot.f_40221_ + (i < 3 ? 2 : 5)), status.getColor());
        }
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE1);
        this.m_93228_(matrixStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int battleLogLength = ((PlaymatMenu)this.m_6262_()).getBattleLog().size();
        if (battleLogLength > 0) {
            ScrollerData scrollerData = ScrollerData.fromScreen(this);
            int height = 0;
            this.m_93228_(matrixStack, this.f_97735_ - 108, this.f_97736_ + height, 0, 88, 108, 5);
            if (scrollerData.needsScroller()) {
                this.m_93228_(matrixStack, this.f_97735_ - 118, this.f_97736_ + height, 108, 88, 10, 5);
            }
            height += 5;
            while (height < scrollerData.drawableHeight() + 5) {
                int drawnHeight = Math.min(14, scrollerData.drawableHeight() - height + 5);
                this.m_93228_(matrixStack, this.f_97735_ - 108, this.f_97736_ + height, 0, 98, 108, drawnHeight);
                if (scrollerData.needsScroller()) {
                    this.m_93228_(matrixStack, this.f_97735_ - 118, this.f_97736_ + height, 108, 98, 10, drawnHeight);
                }
                height += drawnHeight;
            }
            this.m_93228_(matrixStack, this.f_97735_ - 108, this.f_97736_ + height, 0, 93, 108, 5);
            if (scrollerData.needsScroller()) {
                this.m_93228_(matrixStack, this.f_97735_ - 118, this.f_97736_ + height, 108, 93, 10, 5);
                this.m_93228_(matrixStack, this.f_97735_ - 115, this.f_97736_ + (int)this.scrollPosition + 3, 118, 98, 4, 14);
            }
        }
    }

    public boolean m_6375_(double x, double y, int mouse) {
        if (this.updateScrollPosition(x, y, mouse)) {
            return true;
        }
        return super.m_6375_(x, y, mouse);
    }

    public boolean m_7979_(double x, double y, int mouse, double x2, double y2) {
        if (this.updateScrollPosition(x, y, mouse)) {
            return true;
        }
        return super.m_7979_(x, y, mouse, x2, y2);
    }

    public boolean m_6050_(double x, double y, double amount) {
        ScrollerData data = ScrollerData.fromScreen(this);
        if (data.needsScroller() && x >= (double)(this.f_97735_ - 123) && x < (double)this.f_97735_ && y >= (double)this.f_97736_ && y <= (double)this.f_96544_) {
            float scrollRatio = (float)(data.scrollerPosMax - data.scrollerPosMin) / ((float)(data.requiredHeight - data.availableHeight) * 0.065f);
            this.scrollPosition = Mth.m_14036_((float)(this.scrollPosition - (float)amount * scrollRatio), (float)0.0f, (float)(data.scrollerPosMax - data.scrollerPosMin));
            return true;
        }
        return super.m_6050_(x, y, amount);
    }

    private boolean updateScrollPosition(double x, double y, int mouse) {
        ScrollerData data = ScrollerData.fromScreen(this);
        if (mouse == 0 && data.needsScroller() && x >= (double)(this.f_97735_ - 123) && x <= (double)(this.f_97735_ - 103) && y >= (double)this.f_97736_ && y <= (double)this.f_96544_) {
            this.scrollPosition = Mth.m_14036_((float)((float)y - (float)data.scrollerPosMin), (float)0.0f, (float)(data.scrollerPosMax - data.scrollerPosMin));
            return true;
        }
        return false;
    }

    private record ScrollerData(int requiredHeight, int availableHeight, int scrollerPosMin, int scrollerPosMax) {
        private static ScrollerData fromScreen(PlaymatScreen screen) {
            return new ScrollerData(((PlaymatMenu)screen.m_6262_()).getBattleLog().size() * 14, screen.f_96544_ - screen.f_97736_ - 10, screen.f_97736_ + 10, screen.f_96544_ - 3 - 7);
        }

        private int drawableHeight() {
            return Math.min(this.availableHeight, this.requiredHeight);
        }

        private boolean needsScroller() {
            return this.requiredHeight > this.availableHeight;
        }

        private int scrollerOffset(float scrollerPos) {
            if (!this.needsScroller()) {
                return 0;
            }
            float offset = scrollerPos / (float)(this.scrollerPosMax - this.scrollerPosMin);
            return (int)((float)(this.requiredHeight - this.availableHeight) * offset);
        }
    }
}

