/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.util;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ConfigManager {
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec config;
    public static ForgeConfigSpec.DoubleValue zombieChance;
    public static ForgeConfigSpec.DoubleValue villagerChance;
    public static ForgeConfigSpec.DoubleValue zombieVillagerChance;
    public static ForgeConfigSpec.DoubleValue piglinChance;
    public static ForgeConfigSpec.DoubleValue zombiePiglinChance;
    public static ForgeConfigSpec.DoubleValue shulkerChance;
    public static ForgeConfigSpec.DoubleValue dragonChance;
    public static ForgeConfigSpec.IntValue dragonMaxPacks;
    public static ForgeConfigSpec.DoubleValue witherChance;
    public static ForgeConfigSpec.IntValue witherMaxPacks;
    public static ForgeConfigSpec.BooleanValue luminisVeins;
    public static ForgeConfigSpec.IntValue luminisChunks;
    public static ForgeConfigSpec.IntValue luminisBranchMin;
    public static ForgeConfigSpec.IntValue luminisBranchMax;
    public static ForgeConfigSpec.IntValue luminisBranchLengthMin;
    public static ForgeConfigSpec.IntValue luminisBranchLengthMax;
    public static ForgeConfigSpec.IntValue luminisToCrimsonAvg;
    public static ForgeConfigSpec.DoubleValue kineticSuccessRate;
    public static ForgeConfigSpec.DoubleValue luminisKineticCrimsonOdds;
    public static ForgeConfigSpec.DoubleValue luminisKineticSpecialtyOdds;
    public static ForgeConfigSpec.DoubleValue enderlingChanceOverworld;
    public static ForgeConfigSpec.DoubleValue enderlingChanceNether;
    public static ForgeConfigSpec.DoubleValue enderlingChanceEnd;
    public static ForgeConfigSpec.IntValue deckLimitCommon;
    public static ForgeConfigSpec.IntValue deckLimitUncommon;
    public static ForgeConfigSpec.IntValue deckLimitRare;
    public static ForgeConfigSpec.IntValue deckLimitEpic;

    public static void loadConfig(String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    public static void init() {
        builder.comment("Buddycards Core config");
        zombieChance = builder.comment("\nOdds of baby zombie dropping base set packs, 0 for 0%, 1 for 100%, default is 5%").defineInRange("mobDrops.zombieChance", 0.05, 0.0, 1.0);
        villagerChance = builder.comment("\nOdds of baby villager dropping base set packs, 0 for 0%, 1 for 100%, default is 5%").defineInRange("mobDrops.villagerChance", 0.05, 0.0, 1.0);
        zombieVillagerChance = builder.comment("\nOdds of baby zombie villager dropping base set packs, 0 for 0%, 1 for 100%, default is 10%").defineInRange("mobDrops.zombieVillagerChance", 0.1, 0.0, 1.0);
        piglinChance = builder.comment("\nOdds of baby piglin dropping nether set packs, 0 for 0%, 1 for 100%, default is 5%").defineInRange("mobDrops.piglinChance", 0.05, 0.0, 1.0);
        zombiePiglinChance = builder.comment("\nOdds of baby zombie piglin dropping nether set , 0 for 0%, 1 for 100%, default is 5%").defineInRange("mobDrops.zombiePiglinChance", 0.05, 0.0, 1.0);
        shulkerChance = builder.comment("\nOdds of shulkers dropping end set packs, 0 for 0%, 1 for 100%, default is 5%").defineInRange("mobDrops.shulkerChance", 0.05, 0.0, 1.0);
        dragonChance = builder.comment("\nOdds of ender dragons dropping end set packs, 0 for 0%, 1 for 100%, default is 100%").defineInRange("mobDrops.dragonChance", 1.0, 0.0, 1.0);
        dragonMaxPacks = builder.comment("\nMaximum amount of packs dropped when a dragon drops packs, default is 4").defineInRange("mobDrops.dragonMaxPacks", 4, 1, 16);
        witherChance = builder.comment("\nOdds of withers dropping nether set packs, 0 for 0%, 1 for 100%, default is 50%").defineInRange("mobDrops.witherChance", 0.5, 0.0, 1.0);
        witherMaxPacks = builder.comment("\nMaximum amount of packs dropped when a wither drops packs, default is 3").defineInRange("mobDrops.witherMaxPacks", 3, 1, 16);
        luminisVeins = builder.comment("\nEnable Luminis vein generation, default is true").define("luminis.enableVeins", true);
        luminisChunks = builder.comment("\nDistance between chunks that can spawn Luminis veins, under right conditions, default is 3").defineInRange("luminis.veinChunkDistance", 3, 1, 16);
        luminisBranchMin = builder.comment("\nMinimum amount of branches in a Luminis vein, default is 3").defineInRange("luminis.veinBranchAmtMin", 3, 1, 16);
        luminisBranchMax = builder.comment("\nMaximum amount of branches in a Luminis vein, default is 6").defineInRange("luminis.veinBranchAmtMax", 6, 1, 32);
        luminisBranchLengthMin = builder.comment("\nMinimum length of branches in a Luminis vein, default is 8").defineInRange("luminis.veinBranchLengthMin", 8, 1, 32);
        luminisBranchLengthMax = builder.comment("\nMaximum length of branches in a Luminis vein, default is 32").defineInRange("luminis.veinBranchLengthMax", 32, 1, 64);
        luminisToCrimsonAvg = builder.comment("\nAmount of Luminis blocks, on average, needed to make 1 Crimson Luminis in an explosion, default is 2").defineInRange("luminis.explodeCrimsonAvg", 2, 1, 16);
        kineticSuccessRate = builder.comment("\nOdds of an explosion triggering a Kinetic Chamber to activate, default is 50%").defineInRange("luminis.kineticSuccessOdds", 0.5, 0.0, 1.0);
        luminisKineticCrimsonOdds = builder.comment("\nOdds of a kinetic chamber properly converting Luminis blocks to Crimson Luminis, default is 75% \nWARNING: FAILURE WILL CONSUME").defineInRange("luminis.kineticCrimsonOdds", 0.75, 0.0, 1.0);
        luminisKineticSpecialtyOdds = builder.comment("\nOdds of a kinetic chamber properly converting Crimson Luminis blocks to specialty items, default is 85% \nWARNING: FAILURE WILL CONSUME").defineInRange("luminis.kineticSpecialtyOdds", (double)0.85f, 0.0, 1.0);
        enderlingChanceEnd = builder.comment("\nOdds for an Enderling to spawn with an Enderman in the End, 0-1, default is 0.5%").defineInRange("enderling.endOdds", 0.005, 0.0, 1.0);
        enderlingChanceNether = builder.comment("\nOdds for an Enderling to spawn with an Enderman in the Nether, 0-1, default is 0.5%").defineInRange("enderling.netherOdds", 0.005, 0.0, 1.0);
        enderlingChanceOverworld = builder.comment("\nOdds for an Enderling to spawn with an Enderman in the Overworld, 0-1, default is 1.5%").defineInRange("enderling.overOdds", 0.015, 0.0, 1.0);
        deckLimitCommon = builder.comment("\nMax duplicates of a common card for a Buddycards deck, 0-16, default is 4").defineInRange("deckBuilding.commonDupeLimit", 4, 1, 16);
        deckLimitUncommon = builder.comment("\nMax duplicates of an uncommon card for a Buddycards deck, 0-16, default is 3").defineInRange("deckBuilding.uncommonDupeLimit", 3, 1, 16);
        deckLimitRare = builder.comment("\nMax duplicates of a rare card for a Buddycards deck, 0-16, default is 2").defineInRange("deckBuilding.rareDupeLimit", 2, 1, 16);
        deckLimitEpic = builder.comment("\nMax duplicates of an epic card for a Buddycards deck, 0-16, default is 1").defineInRange("deckBuilding.epicDupeLimit", 1, 1, 16);
    }

    static {
        ConfigManager.init();
        config = builder.build();
    }
}

