/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.util;

import com.wildcard.buddycards.registries.BuddycardsBlocks;
import com.wildcard.buddycards.registries.BuddycardsEntities;
import com.wildcard.buddycards.registries.BuddycardsItems;
import com.wildcard.buddycards.util.ConfigManager;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ExplosionHandler {
    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Detonate event) {
        int luminisBlocks = 0;
        ArrayList<BlockPos> replacedExplosion = new ArrayList<BlockPos>();
        for (int i = 0; i < event.getAffectedBlocks().size(); ++i) {
            BlockPos blockPos = (BlockPos)event.getAffectedBlocks().get(i);
            BlockState targetBlock = event.getWorld().m_8055_(blockPos);
            Level level = event.getWorld();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                if (targetBlock.m_60734_().equals(BuddycardsBlocks.KINETIC_CHAMBER.get())) {
                    event.getWorld().m_141902_(blockPos, (BlockEntityType)BuddycardsEntities.KINETIC_CHAMBER_TILE.get()).ifPresent(be -> be.absorbExplosion(server));
                    continue;
                }
            }
            if (targetBlock.m_60734_().equals(BuddycardsBlocks.LUMINIS_BLOCK.get())) {
                ++luminisBlocks;
                event.getWorld().m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 11);
                replacedExplosion.add(blockPos);
                continue;
            }
            replacedExplosion.add(blockPos);
        }
        event.getExplosion().m_46080_();
        event.getAffectedBlocks().addAll(replacedExplosion);
        double rng = event.getWorld().m_5822_().nextFloat() * 2.0f;
        int amt = (int)((double)luminisBlocks * rng / (double)((Integer)ConfigManager.luminisToCrimsonAvg.get()).intValue());
        if (amt >= 1) {
            event.getWorld().m_7967_((Entity)new ItemEntity(event.getWorld(), event.getExplosion().getPosition().f_82479_, event.getExplosion().getPosition().f_82480_, event.getExplosion().getPosition().f_82481_, new ItemStack((ItemLike)BuddycardsItems.CRIMSON_LUMINIS.get(), amt)));
        }
    }
}

