/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.client.screen.ChangeEnumScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.EditListScreen;
import com.mrcrayfish.configured.client.screen.EditStringScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class ConfigScreen
extends ListMenuScreen {
    public static final int TOOLTIP_WIDTH = 200;
    public static final Comparator<ListMenuScreen.Item> SORT_ALPHABETICALLY = (o1, o2) -> {
        if (o1 instanceof FolderItem && o2 instanceof FolderItem) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
        if (!(o1 instanceof FolderItem) && o2 instanceof FolderItem) {
            return 1;
        }
        if (o1 instanceof FolderItem) {
            return -1;
        }
        return o1.getLabel().compareTo(o2.getLabel());
    };
    protected final FolderEntry folderEntry;
    protected ModConfig config;
    protected Button saveButton;
    protected Button restoreButton;

    private ConfigScreen(Screen parent, Component title, ResourceLocation background, FolderEntry folderEntry) {
        super(parent, title, background, 24);
        this.folderEntry = folderEntry;
    }

    public ConfigScreen(Screen parent, Component title, ModConfig config, ResourceLocation background) {
        super(parent, title, background, 24);
        this.folderEntry = new FolderEntry(((ForgeConfigSpec)config.getSpec()).getValues(), (ForgeConfigSpec)config.getSpec());
        this.config = config;
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        ArrayList<ListMenuScreen.Item> configEntries = new ArrayList<ListMenuScreen.Item>();
        this.folderEntry.getEntries().forEach(c -> {
            if (c instanceof FolderEntry) {
                configEntries.add(new FolderItem((FolderEntry)c));
            } else if (c instanceof ValueEntry) {
                ValueEntry configValueEntry = (ValueEntry)c;
                Object value = ((ValueEntry)c).getHolder().getValue();
                if (value instanceof Boolean) {
                    configEntries.add(new BooleanItem(configValueEntry.getHolder()));
                } else if (value instanceof Integer) {
                    configEntries.add(new IntegerItem(configValueEntry.getHolder()));
                } else if (value instanceof Double) {
                    configEntries.add(new DoubleItem(configValueEntry.getHolder()));
                } else if (value instanceof Long) {
                    configEntries.add(new LongItem(configValueEntry.getHolder()));
                } else if (value instanceof Enum) {
                    configEntries.add(new EnumItem(configValueEntry.getHolder()));
                } else if (value instanceof String) {
                    configEntries.add(new StringItem(configValueEntry.getHolder()));
                } else if (value instanceof List) {
                    configEntries.add(new ListItem((ListValueHolder)configValueEntry.getHolder()));
                } else {
                    Configured.LOGGER.info("Unsupported config value: " + configValueEntry.getHolder().configValue.getPath());
                }
            }
        });
        configEntries.sort(SORT_ALPHABETICALLY);
        entries.addAll(configEntries);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        if (this.folderEntry.isRoot()) {
            this.saveButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_96543_ / 2 - 140, this.f_96544_ - 29, 22, 0, 90, (Component)Component.m_237115_((String)"configured.gui.save"), button -> {
                if (this.config != null) {
                    this.saveConfig();
                }
                this.f_96541_.m_91152_(this.parent);
            }));
            this.restoreButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_96543_ / 2 - 45, this.f_96544_ - 29, 0, 0, 90, (Component)Component.m_237115_((String)"configured.gui.reset_all"), button -> {
                if (this.folderEntry.isRoot()) {
                    this.showRestoreScreen();
                }
            }));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 50, this.f_96544_ - 29, 90, 20, CommonComponents.f_130656_, button -> {
                if (this.isChanged(this.folderEntry)) {
                    this.f_96541_.m_91152_((Screen)new ConfirmationScreen(this, (Component)Component.m_237115_((String)"configured.gui.unsaved_changes"), result -> {
                        if (!result.booleanValue()) {
                            return true;
                        }
                        this.f_96541_.m_91152_(this.parent);
                        return false;
                    }).setBackground(this.background));
                } else {
                    this.f_96541_.m_91152_(this.parent);
                }
            }));
            this.updateButtons();
        } else {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 75, this.f_96544_ - 29, 150, 20, CommonComponents.f_130660_, button -> this.f_96541_.m_91152_(this.parent)));
        }
    }

    private void saveConfig() {
        if (!this.isChanged(this.folderEntry)) {
            return;
        }
        CommentedConfig newConfig = CommentedConfig.copy((UnmodifiableCommentedConfig)this.config.getConfigData());
        ArrayDeque<FolderEntry> found = new ArrayDeque<FolderEntry>();
        found.add(this.folderEntry);
        while (!found.isEmpty()) {
            FolderEntry folder = (FolderEntry)found.poll();
            for (IEntry entry : folder.getEntries()) {
                ListValueHolder listHolder;
                Function<List<?>, List<?>> converter;
                ValueEntry valueEntry;
                ValueHolder<?> holder;
                if (entry instanceof FolderEntry) {
                    found.offer((FolderEntry)entry);
                    continue;
                }
                if (!(entry instanceof ValueEntry) || !(holder = (valueEntry = (ValueEntry)entry).getHolder()).isChanged()) continue;
                List path = holder.configValue.getPath();
                if (holder instanceof ListValueHolder && (converter = (listHolder = (ListValueHolder)holder).getConverter()) != null) {
                    List<?> convertedList = converter.apply((List)listHolder.getValue());
                    newConfig.set(path, convertedList);
                    continue;
                }
                newConfig.set(path, holder.getValue());
            }
        }
        this.config.getConfigData().putAll((UnmodifiableConfig)newConfig);
        if (this.config.getType() == ModConfig.Type.SERVER) {
            if (!ListMenuScreen.isPlayingGame()) {
                this.config.getHandler().unload(this.config.getFullPath().getParent(), this.config);
                ConfigHelper.setConfigData(this.config, null);
            }
        } else {
            Configured.LOGGER.info("Sending config reloading event for {}", (Object)this.config.getFileName());
            this.config.getSpec().afterReload();
            ConfigHelper.fireEvent(this.config, (ModConfigEvent)new ModConfigEvent.Reloading(this.config));
        }
    }

    private void showRestoreScreen() {
        ConfirmationScreen confirmScreen = new ConfirmationScreen(this, (Component)Component.m_237115_((String)"configured.gui.restore_message"), result -> {
            if (!result.booleanValue()) {
                return true;
            }
            this.restoreDefaults(this.folderEntry);
            this.updateButtons();
            return true;
        });
        confirmScreen.setBackground(this.background);
        confirmScreen.setPositiveText((Component)Component.m_237115_((String)"configured.gui.reset_all").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        confirmScreen.setNegativeText(CommonComponents.f_130656_);
        Minecraft.m_91087_().m_91152_((Screen)confirmScreen);
    }

    private void restoreDefaults(FolderEntry entry) {
        entry.getEntries().forEach(e -> {
            if (e instanceof FolderEntry) {
                this.restoreDefaults((FolderEntry)e);
            } else if (e instanceof ValueEntry) {
                ((ValueEntry)e).getHolder().restoreDefaultValue();
            }
        });
    }

    private void updateButtons() {
        if (this.folderEntry.isRoot()) {
            if (this.saveButton != null) {
                this.saveButton.f_93623_ = this.isChanged(this.folderEntry);
            }
            if (this.restoreButton != null) {
                this.restoreButton.f_93623_ = this.isModified(this.folderEntry);
            }
        }
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.m_7333_(poseStack);
        this.list.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.searchTextField.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        ConfigScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)7, (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    @Nullable
    private List<FormattedText> getTranslatableComment(ICommentedTranslatable entry) {
        String rawComment = entry.getComment();
        String key = entry.getTranslationKey();
        if (key != null && I18n.m_118936_((String)(key + ".tooltip"))) {
            MutableComponent comment = Component.m_237115_((String)(key + ".tooltip"));
            if (rawComment != null) {
                int rangeIndex = rawComment.indexOf("Range: ");
                int allowedValIndex = rawComment.indexOf("Allowed Values: ");
                if (rangeIndex >= 0 || allowedValIndex >= 0) {
                    comment.m_7220_((Component)Component.m_237113_((String)rawComment.substring(Math.max(rangeIndex, allowedValIndex) - 1)));
                }
            }
            return ConfigScreen.splitTooltip((FormattedText)comment);
        }
        return rawComment != null ? ConfigScreen.splitTooltip((FormattedText)Component.m_237113_((String)rawComment)) : null;
    }

    private static <V> V lastValue(List<V> list, V defaultValue) {
        if (list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return defaultValue;
    }

    private static String createLabelFromHolder(ValueHolder<?> holder) {
        if (holder.valueSpec.getTranslationKey() != null && I18n.m_118936_((String)holder.valueSpec.getTranslationKey())) {
            return Component.m_237115_((String)holder.valueSpec.getTranslationKey()).getString();
        }
        return ConfigScreen.createLabel(ConfigScreen.lastValue(holder.configValue.getPath(), ""));
    }

    public static String createLabel(String input) {
        int i;
        String valueName = input;
        String[] words = valueName.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        valueName = Strings.join((String[])words, (String)" ");
        words = valueName.split("_");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        return Strings.join((String[])words, (String)" ").replaceAll("\\s++", " ");
    }

    private static List<FormattedText> splitTooltip(FormattedText text) {
        return Minecraft.m_91087_().f_91062_.m_92865_().m_92414_(text, 200, Style.f_131099_);
    }

    public boolean m_6913_() {
        return this.config == null || this.config.getType() != ModConfig.Type.SERVER;
    }

    public boolean isModified(FolderEntry folder) {
        for (IEntry entry : folder.getEntries()) {
            if (!(entry instanceof FolderEntry ? this.isModified((FolderEntry)entry) : entry instanceof ValueEntry && !((ValueEntry)entry).getHolder().isDefaultValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isChanged(FolderEntry folder) {
        for (IEntry entry : folder.getEntries()) {
            if (!(entry instanceof FolderEntry ? this.isChanged((FolderEntry)entry) : entry instanceof ValueEntry && ((ValueEntry)entry).getHolder().isChanged())) continue;
            return true;
        }
        return false;
    }

    public class FolderEntry
    implements IEntry,
    ICommentedTranslatable {
        private final List<String> path;
        private final UnmodifiableConfig config;
        private final ForgeConfigSpec spec;
        private List<IEntry> entries;

        public FolderEntry(UnmodifiableConfig config, ForgeConfigSpec spec) {
            this(new ArrayList<String>(), config, spec);
        }

        public FolderEntry(List<String> path, UnmodifiableConfig config, ForgeConfigSpec spec) {
            this.path = path;
            this.config = config;
            this.spec = spec;
            this.init();
        }

        private void init() {
            if (this.entries == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.config.valueMap().forEach((s, o) -> {
                    if (o instanceof UnmodifiableConfig) {
                        ArrayList<String> path = new ArrayList<String>(this.path);
                        path.add((String)s);
                        builder.add((Object)new FolderEntry(path, (UnmodifiableConfig)o, this.spec));
                    } else if (o instanceof ForgeConfigSpec.ConfigValue) {
                        ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)o;
                        ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath());
                        builder.add((Object)new ValueEntry(configValue, valueSpec));
                    }
                });
                this.entries = builder.build();
            }
        }

        public boolean isRoot() {
            return this.path.isEmpty();
        }

        public boolean isInitialized() {
            return this.entries != null;
        }

        public List<IEntry> getEntries() {
            return this.entries;
        }

        public String getLabel() {
            return ConfigScreen.lastValue(this.path, "Root");
        }

        @Override
        @Nullable
        public String getComment() {
            return this.spec.getLevelComment(this.path);
        }

        @Override
        @Nullable
        public String getTranslationKey() {
            return this.spec.getLevelTranslationKey(this.path);
        }
    }

    public static interface IEntry {
    }

    public class ValueEntry
    implements IEntry {
        private final ValueHolder<?> holder;

        public ValueEntry(ForgeConfigSpec.ConfigValue<?> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            this.holder = configValue.get() instanceof List ? new ListValueHolder((ForgeConfigSpec.ConfigValue<List<?>>)configValue, valueSpec) : new ValueHolder(configValue, valueSpec);
        }

        public ValueHolder<?> getHolder() {
            return this.holder;
        }
    }

    public class ValueHolder<T>
    implements ICommentedTranslatable {
        private final ForgeConfigSpec.ConfigValue<T> configValue;
        private final ForgeConfigSpec.ValueSpec valueSpec;
        private final T initialValue;
        protected T value;

        public ValueHolder(ForgeConfigSpec.ConfigValue<T> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            this.configValue = configValue;
            this.valueSpec = valueSpec;
            this.initialValue = configValue.get();
            this.setValue(configValue.get());
        }

        protected void setValue(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public void restoreDefaultValue() {
            this.setValue(this.valueSpec.getDefault());
            ConfigScreen.this.updateButtons();
        }

        public boolean isDefaultValue() {
            return this.value.equals(this.valueSpec.getDefault());
        }

        public boolean isChanged() {
            return !this.value.equals(this.initialValue);
        }

        public ForgeConfigSpec.ConfigValue<T> getConfigValue() {
            return this.configValue;
        }

        public ForgeConfigSpec.ValueSpec getSpec() {
            return this.valueSpec;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.valueSpec.getComment();
        }

        @Override
        @Nullable
        public String getTranslationKey() {
            return this.valueSpec.getTranslationKey();
        }
    }

    public class ListValueHolder
    extends ValueHolder<List<?>> {
        @Nullable
        private final Function<List<?>, List<?>> converter;

        public ListValueHolder(ForgeConfigSpec.ConfigValue<List<?>> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(configValue, valueSpec);
            this.converter = this.createConverter(configValue);
        }

        @Nullable
        private Function<List<?>, List<?>> createConverter(ForgeConfigSpec.ConfigValue<List<?>> configValue) {
            List original = (List)configValue.get();
            if (original instanceof ArrayList) {
                return ArrayList::new;
            }
            if (original instanceof LinkedList) {
                return LinkedList::new;
            }
            return null;
        }

        @Override
        protected void setValue(List<?> value) {
            this.value = new ArrayList(value);
        }

        @Nullable
        public Function<List<?>, List<?>> getConverter() {
            return this.converter;
        }
    }

    public static interface ICommentedTranslatable {
        @Nullable
        public String getComment();

        @Nullable
        public String getTranslationKey();
    }

    public class FolderItem
    extends ListMenuScreen.Item {
        private final Button button;

        public FolderItem(FolderEntry folderEntry) {
            super((ListMenuScreen)ConfigScreen.this, FolderItem.createLabelForFolderEntry(folderEntry));
            this.button = new Button(10, 5, 44, 20, (Component)Component.m_237113_((String)this.getLabel()).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.WHITE), onPress -> {
                MutableComponent newTitle = ConfigScreen.this.f_96539_.m_6881_().m_130946_(" > " + this.getLabel());
                ConfigScreen.this.f_96541_.m_91152_((Screen)new ConfigScreen((Screen)ConfigScreen.this, (Component)newTitle, ConfigScreen.this.background, folderEntry));
            });
            if (folderEntry.getComment() != null) {
                this.tooltip = Language.m_128107_().m_128112_(ConfigScreen.this.getTranslatableComment(folderEntry));
            }
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.button);
        }

        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            if (this.m_5953_(mouseX, mouseY)) {
                ConfigScreen.this.setActiveTooltip(this.tooltip);
            }
            this.button.f_93620_ = left - 1;
            this.button.f_93621_ = top;
            this.button.m_93674_(width);
            this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        private static Component createLabelForFolderEntry(FolderEntry folderEntry) {
            if (folderEntry.getTranslationKey() != null && I18n.m_118936_((String)folderEntry.getTranslationKey())) {
                return Component.m_237115_((String)folderEntry.getTranslationKey());
            }
            return Component.m_237113_((String)ConfigScreen.createLabel(folderEntry.getLabel()));
        }
    }

    public class BooleanItem
    extends ConfigItem<Boolean> {
        private final Button button;

        public BooleanItem(ValueHolder<Boolean> holder) {
            super(holder);
            this.button = new Button(10, 5, 46, 20, CommonComponents.m_130666_((boolean)holder.getValue()), button -> {
                holder.setValue((Boolean)holder.getValue() == false);
                button.m_93666_(CommonComponents.m_130666_((boolean)((Boolean)holder.getValue())));
                ConfigScreen.this.updateButtons();
            });
            this.eventListeners.add(this.button);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.f_93620_ = left + width - 69;
            this.button.f_93621_ = top;
            this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onResetValue() {
            this.button.m_93666_(CommonComponents.m_130666_((boolean)((Boolean)this.holder.getValue())));
        }
    }

    public class IntegerItem
    extends NumberItem<Integer> {
        public IntegerItem(ValueHolder<Integer> holder) {
            super(holder, Integer::parseInt);
        }
    }

    public class DoubleItem
    extends NumberItem<Double> {
        public DoubleItem(ValueHolder<Double> holder) {
            super(holder, Double::parseDouble);
        }
    }

    public class LongItem
    extends NumberItem<Long> {
        public LongItem(ValueHolder<Long> holder) {
            super(holder, Long::parseLong);
        }
    }

    public class EnumItem
    extends ConfigItem<Enum<?>> {
        private final Button button;

        public EnumItem(ValueHolder<Enum<?>> holder) {
            super(holder);
            this.button = new Button(10, 5, 46, 20, (Component)Component.m_237115_((String)"configured.gui.change"), button -> Minecraft.m_91087_().m_91152_((Screen)new ChangeEnumScreen(ConfigScreen.this, this.label, ConfigScreen.this.background, (Enum)holder.getValue(), e -> {
                holder.setValue((Enum<?>)e);
                ConfigScreen.this.updateButtons();
            })));
            this.eventListeners.add(this.button);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.f_93620_ = left + width - 69;
            this.button.f_93621_ = top;
            this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public class StringItem
    extends ConfigItem<String> {
        private final Button button;

        public StringItem(ValueHolder<String> holder) {
            super(holder);
            this.button = new Button(10, 5, 46, 20, (Component)Component.m_237115_((String)"configured.gui.edit"), button -> Minecraft.m_91087_().m_91152_((Screen)new EditStringScreen(ConfigScreen.this, ConfigScreen.this.background, this.label, (String)holder.getValue(), arg_0 -> ((ForgeConfigSpec.ValueSpec)holder.valueSpec).test(arg_0), s -> {
                holder.setValue((String)s);
                ConfigScreen.this.updateButtons();
            })));
            this.eventListeners.add(this.button);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.f_93620_ = left + width - 69;
            this.button.f_93621_ = top;
            this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public class ListItem
    extends ConfigItem<List<?>> {
        private final Button button;

        public ListItem(ListValueHolder holder) {
            super(holder);
            this.button = new Button(10, 5, 46, 20, (Component)Component.m_237115_((String)"configured.gui.edit"), button -> Minecraft.m_91087_().m_91152_((Screen)new EditListScreen(ConfigScreen.this, this.label, holder, ConfigScreen.this.background)));
            this.eventListeners.add(this.button);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.f_93620_ = left + width - 69;
            this.button.f_93621_ = top;
            this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public abstract class NumberItem<T extends Number>
    extends ConfigItem<T> {
        private final ListMenuScreen.FocusedEditBox textField;

        public NumberItem(ValueHolder<T> holder, Function<String, Number> parser) {
            super(holder);
            this.textField = new ListMenuScreen.FocusedEditBox(ConfigScreen.this, ConfigScreen.this.f_96547_, 0, 0, 44, 18, this.label);
            this.textField.m_94144_(((Number)holder.getValue()).toString());
            this.textField.m_94151_(s -> {
                try {
                    Number n = (Number)parser.apply((String)s);
                    if (holder.valueSpec.test((Object)n)) {
                        this.textField.m_94202_(0xE0E0E0);
                        holder.setValue(n);
                        ConfigScreen.this.updateButtons();
                    } else {
                        this.textField.m_94202_(0xFF0000);
                    }
                }
                catch (Exception ignored) {
                    this.textField.m_94202_(0xFF0000);
                }
            });
            this.eventListeners.add(this.textField);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.textField.f_93620_ = left + width - 68;
            this.textField.f_93621_ = top + 1;
            this.textField.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onResetValue() {
            this.textField.m_94144_(((Number)this.holder.getValue()).toString());
        }
    }

    public abstract class ConfigItem<T>
    extends ListMenuScreen.Item {
        protected final ValueHolder<T> holder;
        protected final List<GuiEventListener> eventListeners;
        protected final Button resetButton;

        public ConfigItem(ValueHolder<T> holder) {
            super((ListMenuScreen)ConfigScreen.this, ConfigScreen.createLabelFromHolder(holder));
            this.eventListeners = new ArrayList<GuiEventListener>();
            this.holder = holder;
            if (this.holder.getComment() != null) {
                this.tooltip = this.createToolTip(holder);
            }
            int maxTooltipWidth = Math.max(ConfigScreen.this.f_96543_ / 2 - 43, 170);
            Button.OnTooltip tooltip = ScreenUtil.createButtonTooltip(ConfigScreen.this, (Component)Component.m_237115_((String)"configured.gui.reset"), maxTooltipWidth);
            this.resetButton = new IconButton(0, 0, 0, 0, onPress -> {
                this.holder.restoreDefaultValue();
                this.onResetValue();
            }, tooltip);
            this.eventListeners.add((GuiEventListener)this.resetButton);
        }

        protected void onResetValue() {
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return this.eventListeners;
        }

        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            Minecraft.m_91087_().f_91062_.m_92889_(poseStack, this.getTrimmedLabel(width - 75), (float)left, (float)(top + 6), 0xFFFFFF);
            if (this.m_5953_(mouseX, mouseY) && mouseX < ConfigScreen.this.list.m_5747_() + ConfigScreen.this.list.m_5759_() - 67) {
                ConfigScreen.this.setActiveTooltip(this.tooltip);
            }
            this.resetButton.f_93623_ = !this.holder.isDefaultValue();
            this.resetButton.f_93620_ = left + width - 21;
            this.resetButton.f_93621_ = top;
            this.resetButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        private Component getTrimmedLabel(int maxWidth) {
            if (((ConfigScreen)ConfigScreen.this).f_96541_.f_91062_.m_92852_((FormattedText)this.label) > maxWidth) {
                return Component.m_237113_((String)(((ConfigScreen)ConfigScreen.this).f_96541_.f_91062_.m_92854_((FormattedText)this.label, maxWidth).getString() + "..."));
            }
            return this.label;
        }

        private List<FormattedCharSequence> createToolTip(ValueHolder<T> holder) {
            List<FormattedText> lines = ConfigScreen.this.getTranslatableComment(holder);
            if (lines != null) {
                String name = ConfigScreen.lastValue(holder.configValue.getPath(), "");
                lines.add(0, (FormattedText)Component.m_237113_((String)name).m_130940_(ChatFormatting.YELLOW));
                for (int i = 1; i < lines.size(); ++i) {
                    String text = lines.get(i).getString();
                    if (!text.startsWith("Range: ") && !text.startsWith("Allowed Values: ")) continue;
                    for (int j = i; j < lines.size(); ++j) {
                        lines.set(j, (FormattedText)Component.m_237113_((String)lines.get(j).getString()).m_130940_(ChatFormatting.GRAY));
                    }
                    break;
                }
                return Language.m_128107_().m_128112_(lines);
            }
            return null;
        }
    }
}

