/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.api.simple;

import com.electronwill.nightconfig.core.ConfigSpec;
import com.google.common.base.Preconditions;
import com.mrcrayfish.configured.api.simple.ConfigProperty;
import com.mrcrayfish.configured.api.simple.validate.Validator;

public final class StringProperty
extends ConfigProperty<String> {
    StringProperty(String defaultValue, Validator<String> validator) {
        super(defaultValue, validator);
    }

    @Override
    public void defineSpec(ConfigSpec spec) {
        Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Config property is not initialized yet");
        spec.define(this.data.getPath(), this.defaultValue, e -> {
            String s;
            return e instanceof String && this.isValid(s = (String)e);
        });
    }

    @Override
    public boolean isValid(String value) {
        return value != null && (this.validator == null || this.validator.test(value));
    }

    public static StringProperty create(String defaultValue) {
        return StringProperty.create(defaultValue, null);
    }

    public static <V extends Validator<String>> StringProperty create(String defaultValue, V validator) {
        return new StringProperty(defaultValue, validator);
    }
}

