/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.Config;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigProvider;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.api.util.ConfigScreenHelper;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.impl.simple.SimpleConfigManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.gui.ModListScreen;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;

@Mod.EventBusSubscriber(modid="configured", value={Dist.CLIENT})
public class ClientHandler {
    public static final KeyMapping KEY_OPEN_MOD_LIST = new KeyMapping("key.configured.open_mod_list", -1, "key.categories.configured");
    private static final Set<IConfigProvider> PROVIDERS = new HashSet<IConfigProvider>();

    public static void init() {
        ClientRegistry.registerKeyBinding((KeyMapping)KEY_OPEN_MOD_LIST);
        ListMenuScreen.registerTooltipFactory();
        ClientHandler.loadProviders();
        ClientHandler.generateConfigFactories();
    }

    private static void loadProviders() {
        ModList.get().forEachModContainer((id, container) -> {
            Object raw = container.getModInfo().getModProperties().get("configuredProviders");
            if (raw instanceof String) {
                PROVIDERS.add(ClientHandler.createProviderInstance(container, raw.toString()));
                Configured.LOGGER.info("Successfully loaded config provider: {}", (Object)raw.toString());
            } else if (raw instanceof List) {
                List providers = (List)raw;
                for (Object provider : providers) {
                    PROVIDERS.add(ClientHandler.createProviderInstance(container, provider.toString()));
                    Configured.LOGGER.info("Successfully loaded config provider: {}", (Object)provider.toString());
                }
            } else if (raw != null) {
                throw new RuntimeException("Config provider definition must be either a String or Array of Strings");
            }
        });
    }

    private static IConfigProvider createProviderInstance(ModContainer container, String classPath) {
        try {
            Class<?> providerClass = Class.forName(classPath);
            Object obj = providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(obj instanceof IConfigProvider)) {
                throw new RuntimeException("Config providers must implement IConfigProvider");
            }
            IConfigProvider provider = (IConfigProvider)obj;
            return provider;
        }
        catch (Exception e) {
            Configured.LOGGER.error("Failed to load config provider from mod: {}", (Object)container.getModId());
            throw new RuntimeException("Failed to load config provider", e);
        }
    }

    private static void generateConfigFactories() {
        Configured.LOGGER.info("Creating config GUI factories...");
        ModList.get().forEachModContainer((modId, container) -> {
            if (container.getCustomExtension(ConfigGuiHandler.ConfigGuiFactory.class).isPresent() && !((Boolean)Config.CLIENT.forceConfiguredMenu.get()).booleanValue()) {
                return;
            }
            Map<ConfigType, Set<IModConfig>> modConfigMap = ClientHandler.createConfigMap(container);
            if (!modConfigMap.isEmpty()) {
                long count = modConfigMap.values().stream().mapToLong(Set::size).sum();
                Configured.LOGGER.info("Registering config factory for mod {}. Found {} config(s)", modId, (Object)count);
                String displayName = container.getModInfo().getDisplayName();
                ResourceLocation backgroundTexture = ClientHandler.getBackgroundTexture(container.getModInfo());
                container.registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((mc, screen) -> ConfigScreenHelper.createSelectionScreen(screen, (Component)new TextComponent(displayName), modConfigMap, backgroundTexture)));
            }
        });
    }

    public static Map<ConfigType, Set<IModConfig>> createConfigMap(ModContainer container) {
        HashMap<ConfigType, Set<IModConfig>> modConfigMap = new HashMap<ConfigType, Set<IModConfig>>();
        Set<IModConfig> configs = PROVIDERS.stream().flatMap(p -> p.getConfigurationsForMod(container).stream()).collect(Collectors.toSet());
        configs.forEach(config -> modConfigMap.computeIfAbsent(config.getType(), type -> new LinkedHashSet()).add(config));
        return modConfigMap;
    }

    private static Stream<IModConfig> streamConfigsFromProvider(ModContainer container, IConfigProvider provider) {
        try {
            return provider.getConfigurationsForMod(container).stream();
        }
        catch (Exception e) {
            Configured.LOGGER.error("An error occurred when loading configs from provider: {}", (Object)provider.getClass().getName(), (Object)e);
            return Stream.empty();
        }
    }

    private static ResourceLocation getBackgroundTexture(IModInfo info) {
        Optional optional;
        String configBackground = (String)info.getModProperties().get("configuredBackground");
        if (configBackground != null) {
            return new ResourceLocation(configBackground);
        }
        if (info instanceof ModInfo && (optional = ((ModInfo)info).getConfigElement(new String[]{"configBackground"})).isPresent()) {
            return new ResourceLocation((String)optional.get());
        }
        return Screen.f_93096_;
    }

    public static void updateAbstractListTexture(AbstractSelectionList<?> list) {
        if (list instanceof IBackgroundTexture) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)((IBackgroundTexture)list).getBackgroundTexture());
        }
    }

    public static void updateScreenTexture(Screen screen) {
        if (screen instanceof IBackgroundTexture) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)((IBackgroundTexture)screen).getBackgroundTexture());
        }
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent.KeyInputEvent event) {
        if (event.getAction() == 1 && KEY_OPEN_MOD_LIST.m_90857_()) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ == null) {
                return;
            }
            Screen oldScreen = minecraft.f_91080_;
            minecraft.m_91152_((Screen)new ModListScreen(oldScreen));
        }
    }

    @SubscribeEvent
    public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        SimpleConfigManager.getInstance().onClientDisconnect(event.getConnection());
    }
}

