/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.forge;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.api.IConfigProvider;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.util.OptiFineHelper;
import com.mrcrayfish.configured.impl.forge.ForgeConfig;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

public class ForgeConfigProvider
implements IConfigProvider {
    @Override
    public Set<IModConfig> getConfigurationsForMod(ModContainer container) {
        HashSet<IModConfig> configs = new HashSet<IModConfig>();
        ForgeConfigProvider.addForgeConfigSetToMap(container, ModConfig.Type.CLIENT, configs::add);
        ForgeConfigProvider.addForgeConfigSetToMap(container, ModConfig.Type.COMMON, configs::add);
        ForgeConfigProvider.addForgeConfigSetToMap(container, ModConfig.Type.SERVER, configs::add);
        return configs;
    }

    private static void addForgeConfigSetToMap(ModContainer container, ModConfig.Type type, Consumer<IModConfig> consumer) {
        if (type == ModConfig.Type.CLIENT && OptiFineHelper.isLoaded() && container.getModId().equals("forge")) {
            Configured.LOGGER.info("Ignoring Forge's client config since OptiFine was detected");
            return;
        }
        for (ModConfig config : (Set)ConfigTracker.INSTANCE.configSets().get(type)) {
            ForgeConfigSpec forgeConfigSpec;
            if (!config.getModId().equals(container.getModId()) || (forgeConfigSpec = ConfigHelper.findForgeConfigSpec((UnmodifiableConfig)config.getSpec())) == null) continue;
            ForgeConfig forgeConfig = new ForgeConfig(config, forgeConfigSpec);
            consumer.accept(forgeConfig);
        }
    }
}

