/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.network;

import com.mrcrayfish.configured.impl.simple.SimpleConfigManager;
import com.mrcrayfish.configured.network.HandshakeHandler;
import com.mrcrayfish.configured.network.HandshakeMessages;
import com.mrcrayfish.configured.network.message.MessageRequestSimpleConfig;
import com.mrcrayfish.configured.network.message.MessageResponseSimpleConfig;
import com.mrcrayfish.configured.network.message.MessageSessionData;
import com.mrcrayfish.configured.network.message.MessageSyncForgeConfig;
import com.mrcrayfish.configured.network.message.MessageSyncSimpleConfig;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    private static final SimpleChannel HANDSHAKE_CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("configured", "handshake")).networkProtocolVersion(() -> "1").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
    private static final SimpleChannel PLAY_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("configured", "play"), () -> "1", s -> true, "1"::equals);
    private static int nextId = 0;

    public static void registerMessages() {
        HANDSHAKE_CHANNEL.messageBuilder(HandshakeMessages.C2SAcknowledge.class, 99).loginIndex(HandshakeMessages.LoginIndexedMessage::getLoginIndex, HandshakeMessages.LoginIndexedMessage::setLoginIndex).decoder(HandshakeMessages.C2SAcknowledge::decode).encoder(HandshakeMessages.C2SAcknowledge::encode).consumer(net.minecraftforge.network.HandshakeHandler.indexFirst((handler, msg, s) -> HandshakeHandler.handleAcknowledge(msg, s))).add();
        HANDSHAKE_CHANNEL.messageBuilder(HandshakeMessages.S2CConfigData.class, 1).loginIndex(HandshakeMessages.LoginIndexedMessage::getLoginIndex, HandshakeMessages.LoginIndexedMessage::setLoginIndex).decoder(HandshakeMessages.S2CConfigData::decode).encoder(HandshakeMessages.S2CConfigData::encode).consumer(net.minecraftforge.network.HandshakeHandler.biConsumerFor((handler, msg, supplier) -> HandshakeHandler.handleConfigData(msg, supplier))).buildLoginPacketList(SimpleConfigManager.getInstance()::getMessagesForLogin).add();
        PacketHandler.registerPlayMessage(null, MessageSyncForgeConfig.class, MessageSyncForgeConfig::encode, MessageSyncForgeConfig::decode, MessageSyncForgeConfig::handle);
        PacketHandler.registerPlayMessage(null, MessageSyncSimpleConfig.class, MessageSyncSimpleConfig::encode, MessageSyncSimpleConfig::decode, MessageSyncSimpleConfig::handle);
        PacketHandler.registerPlayMessage(NetworkDirection.PLAY_TO_SERVER, MessageRequestSimpleConfig.class, MessageRequestSimpleConfig::encode, MessageRequestSimpleConfig::decode, MessageRequestSimpleConfig::handle);
        PacketHandler.registerPlayMessage(NetworkDirection.PLAY_TO_CLIENT, MessageResponseSimpleConfig.class, MessageResponseSimpleConfig::encode, MessageResponseSimpleConfig::decode, MessageResponseSimpleConfig::handle);
        PacketHandler.registerPlayMessage(NetworkDirection.PLAY_TO_CLIENT, MessageSessionData.class, MessageSessionData::encode, MessageSessionData::decode, MessageSessionData::handle);
    }

    private static <T> void registerPlayMessage(@Nullable NetworkDirection direction, Class<T> clazz, BiConsumer<T, FriendlyByteBuf> encode, Function<FriendlyByteBuf, T> decode, BiConsumer<T, Supplier<NetworkEvent.Context>> consumer) {
        PLAY_CHANNEL.registerMessage(nextId++, clazz, encode, decode, consumer, Optional.ofNullable(direction));
    }

    public static SimpleChannel getHandshakeChannel() {
        return HANDSHAKE_CHANNEL;
    }

    public static SimpleChannel getPlayChannel() {
        return PLAY_CHANNEL;
    }
}

