/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ActiveConfirmationScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.EditStringScreen;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.IEditing;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class EditListScreen
extends Screen
implements IBackgroundTexture,
IEditing {
    private static final Map<IConfigValue<?>, ListType> TYPE_CACHE = new HashMap();
    private final Screen parent;
    private final IModConfig config;
    private final List<StringHolder> initialValues = new ArrayList<StringHolder>();
    private final List<StringHolder> values = new ArrayList<StringHolder>();
    private final ResourceLocation background;
    private final IConfigValue<List<?>> holder;
    private final IListType listType;
    private ObjectList list;

    public EditListScreen(Screen parent, IModConfig config, Component titleIn, IConfigValue<List<?>> holder, ResourceLocation background) {
        super(titleIn);
        this.parent = parent;
        this.config = config;
        this.holder = holder;
        this.listType = EditListScreen.getType(holder);
        this.initialValues.addAll(holder.get().stream().map(o -> new StringHolder(this.listType.getStringParser().apply(o))).toList());
        this.values.addAll(this.initialValues);
        this.background = background;
    }

    protected void m_7856_() {
        boolean readOnly;
        this.list = new ObjectList();
        this.list.m_93488_(!ConfigHelper.isPlayingGame());
        this.m_7787_((GuiEventListener)this.list);
        if (!this.config.isReadOnly()) {
            this.m_142416_((GuiEventListener)new IconButton(this.f_96543_ / 2 - 140, this.f_96544_ - 29, 0, 44, 90, (Component)Component.m_237115_((String)"configured.gui.apply"), button -> {
                List newValues = this.values.stream().map(StringHolder::getValue).map(s -> this.listType.getValueParser().apply((String)s)).collect(Collectors.toList());
                this.holder.set(newValues);
                this.f_96541_.m_91152_(this.parent);
            }));
            this.m_142416_((GuiEventListener)new IconButton(this.f_96543_ / 2 - 45, this.f_96544_ - 29, 22, 33, 90, (Component)Component.m_237115_((String)"configured.gui.add_value"), button -> this.f_96541_.m_91152_((Screen)new EditStringScreen(this, this.config, this.background, (Component)Component.m_237115_((String)"configured.gui.edit_value"), "", s -> {
                Object value = this.listType.getValueParser().apply((String)s);
                if (value != null) {
                    if (this.holder.isValid(Collections.singletonList(value))) {
                        return Pair.of((Object)true, (Object)CommonComponents.f_237098_);
                    }
                    return Pair.of((Object)false, (Object)this.holder.getValidationHint());
                }
                return Pair.of((Object)false, (Object)this.listType.getHint());
            }, s -> {
                StringHolder holder = new StringHolder((String)s);
                this.values.add(holder);
                this.list.addEntry(new StringEntry(this.list, holder));
            }))));
        }
        int cancelWidth = (readOnly = this.config.isReadOnly()) ? 150 : 90;
        int cancelOffset = readOnly ? -75 : 50;
        Component cancelLabel = readOnly ? Component.m_237115_((String)"configured.gui.close") : CommonComponents.f_130656_;
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + cancelOffset, this.f_96544_ - 29, cancelWidth, 20, cancelLabel, button -> {
            if (this.isModified()) {
                ActiveConfirmationScreen confirmScreen = new ActiveConfirmationScreen(this, this.config, (Component)Component.m_237115_((String)"configured.gui.list_changed"), ConfirmationScreen.Icon.WARNING, result -> {
                    if (!result.booleanValue()) {
                        return true;
                    }
                    this.f_96541_.m_91152_(this.parent);
                    return false;
                });
                this.f_96541_.m_91152_((Screen)confirmScreen);
            } else {
                this.f_96541_.m_91152_(this.parent);
            }
        }));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        this.list.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        EditListScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)14, (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public IModConfig getActiveConfig() {
        return this.config;
    }

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.background;
    }

    public boolean isModified() {
        if (this.initialValues.size() != this.values.size()) {
            return true;
        }
        for (int i = 0; i < this.initialValues.size(); ++i) {
            String s2;
            String s1 = this.initialValues.get(i).getValue();
            if (s1.equals(s2 = this.values.get(i).getValue())) continue;
            return true;
        }
        return false;
    }

    protected static IListType getType(IConfigValue<?> holder) {
        ListTypeProvider provider;
        IListType type;
        if (holder instanceof ListTypeProvider && (type = (provider = (ListTypeProvider)((Object)holder)).getListType()) != null) {
            return type;
        }
        return TYPE_CACHE.computeIfAbsent(holder, value -> ListType.fromHolder(holder));
    }

    public static interface IListType {
        public Function<Object, String> getStringParser();

        public Function<String, ?> getValueParser();

        public Component getHint();
    }

    public class ObjectList
    extends ContainerObjectSelectionList<StringEntry>
    implements IBackgroundTexture {
        public ObjectList() {
            super(EditListScreen.this.f_96541_, EditListScreen.this.f_96543_, EditListScreen.this.f_96544_, 36, EditListScreen.this.f_96544_ - 36, 24);
            EditListScreen.this.values.forEach(value -> this.addEntry(new StringEntry(this, (StringHolder)value)));
        }

        protected int m_5756_() {
            return this.f_93388_ / 2 + 144;
        }

        public int m_5759_() {
            return 260;
        }

        public int addEntry(StringEntry entry) {
            return super.m_7085_((AbstractSelectionList.Entry)entry);
        }

        public boolean removeEntry(StringEntry entry) {
            return super.m_93502_((AbstractSelectionList.Entry)entry);
        }

        public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            this.m_6702_().forEach(entry -> entry.m_6702_().forEach(o -> {
                if (o instanceof Button) {
                    ((Button)o).m_7428_(poseStack, mouseX, mouseY);
                }
            }));
        }

        @Override
        public ResourceLocation getBackgroundTexture() {
            return EditListScreen.this.background;
        }
    }

    public static class StringHolder {
        private String value;

        public StringHolder(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static interface ListTypeProvider {
        @Nullable
        public IListType getListType();
    }

    public static enum ListType implements IListType
    {
        BOOLEAN(Object::toString, Boolean::valueOf, "configured.parser.not_a_boolean"),
        INTEGER(Object::toString, Ints::tryParse, "configured.parser.not_a_number"),
        LONG(Object::toString, Longs::tryParse, "configured.parser.not_a_number"),
        DOUBLE(Object::toString, Doubles::tryParse, "configured.parser.not_a_number"),
        STRING(Object::toString, o -> o, "configured.parser.not_a_value"),
        UNKNOWN(Object::toString, o -> o, "configured.parser.not_a_value");

        final Function<Object, String> stringParser;
        final Function<String, ?> valueParser;
        final String hintKey;

        private ListType(Function<Object, String> stringParser, Function<String, ?> valueParser, String hintKey) {
            this.stringParser = stringParser;
            this.valueParser = valueParser;
            this.hintKey = hintKey;
        }

        @Override
        public Function<Object, String> getStringParser() {
            return this.stringParser;
        }

        @Override
        public Function<String, ?> getValueParser() {
            return this.valueParser;
        }

        @Override
        public Component getHint() {
            return Component.m_237115_((String)this.hintKey);
        }

        public static ListType fromHolder(IConfigValue<List<?>> holder) {
            ListType type = UNKNOWN;
            List<?> defaultList = holder.getDefault();
            if (!defaultList.isEmpty()) {
                type = ListType.fromObject(defaultList.get(0));
            }
            if (type == UNKNOWN) {
                type = ListType.fromElementValidator(holder);
            }
            return type;
        }

        private static ListType fromObject(Object o) {
            if (o instanceof Boolean) {
                return BOOLEAN;
            }
            if (o instanceof Integer) {
                return INTEGER;
            }
            if (o instanceof Long) {
                return LONG;
            }
            if (o instanceof Double) {
                return DOUBLE;
            }
            if (o instanceof String) {
                return STRING;
            }
            return UNKNOWN;
        }

        private static ListType fromElementValidator(IConfigValue<List<?>> spec) {
            if (spec.isValid(Collections.singletonList("s"))) {
                return STRING;
            }
            if (spec.isValid(Collections.singletonList(true))) {
                return BOOLEAN;
            }
            if (spec.isValid(Collections.singletonList(0.0))) {
                return DOUBLE;
            }
            if (spec.isValid(Collections.singletonList(0L))) {
                return LONG;
            }
            if (spec.isValid(Collections.singletonList(0))) {
                return INTEGER;
            }
            return UNKNOWN;
        }
    }

    public class StringEntry
    extends ContainerObjectSelectionList.Entry<StringEntry> {
        private final StringHolder holder;
        private final ObjectList list;
        private final Button editButton;
        private final Button deleteButton;

        public StringEntry(ObjectList list, StringHolder holder) {
            this.list = list;
            this.holder = holder;
            this.editButton = new IconButton(0, 0, 1, 22, 20, CommonComponents.f_237098_, onPress -> EditListScreen.this.f_96541_.m_91152_((Screen)new EditStringScreen(EditListScreen.this, EditListScreen.this.config, EditListScreen.this.background, (Component)Component.m_237115_((String)"configured.gui.edit_value"), this.holder.getValue(), s -> {
                Object value = EditListScreen.this.listType.getValueParser().apply((String)s);
                if (value != null) {
                    if (EditListScreen.this.holder.isValid(Collections.singletonList(value))) {
                        return Pair.of((Object)true, (Object)CommonComponents.f_237098_);
                    }
                    return Pair.of((Object)false, (Object)EditListScreen.this.holder.getValidationHint());
                }
                return Pair.of((Object)false, (Object)EditListScreen.this.listType.getHint());
            }, this.holder::setValue)), (button, matrixStack, mouseX, mouseY) -> {
                if (button.f_93623_ && button.m_198029_()) {
                    EditListScreen.this.m_96617_(matrixStack, ((EditListScreen)EditListScreen.this).f_96541_.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"configured.gui.edit"), Math.max(EditListScreen.this.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
                }
            });
            this.editButton.f_93623_ = !EditListScreen.this.config.isReadOnly();
            this.deleteButton = new IconButton(0, 0, 11, 0, onPress -> {
                EditListScreen.this.values.remove(this.holder);
                this.list.removeEntry(this);
            }, (button, matrixStack, mouseX, mouseY) -> {
                if (button.f_93623_ && button.m_198029_()) {
                    EditListScreen.this.m_96617_(matrixStack, ((EditListScreen)EditListScreen.this).f_96541_.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"configured.gui.remove"), Math.max(EditListScreen.this.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
                }
            });
            this.deleteButton.f_93623_ = !EditListScreen.this.config.isReadOnly();
        }

        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean selected, float partialTicks) {
            if (x % 2 != 0) {
                Screen.m_93172_((PoseStack)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + 24), (int)0x55000000);
            }
            ((EditListScreen)EditListScreen.this).f_96541_.f_91062_.m_92889_(poseStack, (Component)Component.m_237113_((String)this.holder.getValue()), (float)(left + 5), (float)(top + 8), 0xFFFFFF);
            this.editButton.f_93624_ = true;
            this.editButton.f_93620_ = left + width - 44;
            this.editButton.f_93621_ = top + 2;
            this.editButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            this.deleteButton.f_93624_ = true;
            this.deleteButton.f_93620_ = left + width - 22;
            this.deleteButton.f_93621_ = top + 2;
            this.deleteButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.editButton, (Object)this.deleteButton);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput output) {
                    output.m_169143_(NarratedElementType.TITLE, StringEntry.this.holder.getValue());
                }
            }, (Object)this.editButton, (Object)this.deleteButton);
        }
    }
}

