/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.simple;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.ValueEntry;
import com.mrcrayfish.configured.api.simple.EnumProperty;
import com.mrcrayfish.configured.api.simple.ListProperty;
import com.mrcrayfish.configured.impl.forge.ForgeValue;
import com.mrcrayfish.configured.impl.simple.SimpleConfigManager;
import com.mrcrayfish.configured.impl.simple.SimpleEnumValue;
import com.mrcrayfish.configured.impl.simple.SimpleListValue;
import com.mrcrayfish.configured.impl.simple.SimpleValue;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class SimpleFolderEntry
implements IConfigEntry {
    private final SimpleConfigManager.PropertyMap map;
    private List<IConfigEntry> entries;

    public SimpleFolderEntry(SimpleConfigManager.PropertyMap map) {
        this.map = map;
    }

    @Override
    public List<IConfigEntry> getChildren() {
        if (this.entries == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.map.getConfigMaps().forEach(pair -> builder.add((Object)new SimpleFolderEntry((SimpleConfigManager.PropertyMap)pair.getRight())));
            this.map.getConfigProperties().forEach(property -> {
                if (property instanceof ListProperty) {
                    ListProperty listProperty = (ListProperty)property;
                    builder.add((Object)new ValueEntry(new SimpleListValue(listProperty)));
                } else if (property instanceof EnumProperty) {
                    EnumProperty enumProperty = (EnumProperty)property;
                    builder.add((Object)new ValueEntry(new SimpleEnumValue(enumProperty)));
                } else {
                    builder.add((Object)new ValueEntry(new SimpleValue(property)));
                }
            });
            this.entries = builder.build();
        }
        return this.entries;
    }

    @Override
    public boolean isRoot() {
        return this.map.getPath().isEmpty();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    @Nullable
    public IConfigValue<?> getValue() {
        return null;
    }

    @Override
    public String getEntryName() {
        return ForgeValue.lastValue(this.map.getPath(), "Root");
    }

    @Override
    @Nullable
    public Component getTooltip() {
        String key = this.map.getTranslationKey() + ".tooltip";
        if (I18n.m_118936_((String)key)) {
            return Component.m_237115_((String)key);
        }
        String comment = this.map.getComment();
        if (comment != null) {
            return Component.m_237113_((String)comment);
        }
        return null;
    }

    @Override
    @Nullable
    public String getTranslationKey() {
        return this.map.getTranslationKey();
    }
}

