/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="configured", value={Dist.CLIENT})
public abstract class TooltipScreen
extends Screen {
    private static final List<Component> DUMMY_TOOLTIP = ImmutableList.of((Object)Component.m_237119_());
    @Nullable
    protected List<FormattedCharSequence> tooltipText;
    @Nullable
    private Integer tooltipOutlineColour;

    protected TooltipScreen(Component title) {
        super(title);
    }

    protected void resetTooltip() {
        this.tooltipText = null;
        this.tooltipOutlineColour = null;
    }

    public void setActiveTooltip(@Nullable List<FormattedCharSequence> tooltip) {
        this.resetTooltip();
        this.tooltipText = tooltip;
    }

    public void setActiveTooltip(Component text) {
        this.resetTooltip();
        this.tooltipText = this.f_96541_.f_91062_.m_92923_((FormattedText)text, 200);
    }

    public void setActiveTooltip(Component text, int outlineColour) {
        this.resetTooltip();
        this.tooltipText = this.f_96541_.f_91062_.m_92923_((FormattedText)text, 200);
        this.tooltipOutlineColour = outlineColour;
    }

    protected void drawTooltip(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.tooltipText != null) {
            this.m_257959_(this.tooltipText);
        }
    }

    public static void registerTooltipFactory(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(ListMenuTooltipComponent.class, ListMenuTooltipComponent::asClientTextTooltip);
    }

    @SubscribeEvent
    public static void onGatherTooltipComponents(RenderTooltipEvent.GatherComponents event) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (!(screen instanceof TooltipScreen)) {
            return;
        }
        TooltipScreen screen2 = (TooltipScreen)screen;
        if (screen2.tooltipText == null) {
            return;
        }
        event.getTooltipElements().clear();
        for (FormattedCharSequence text : screen2.tooltipText) {
            event.getTooltipElements().add(Either.right((Object)new ListMenuTooltipComponent(text)));
        }
    }

    @SubscribeEvent
    public static void onGetTooltipColor(RenderTooltipEvent.Color event) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (!(screen instanceof TooltipScreen)) {
            return;
        }
        TooltipScreen screen2 = (TooltipScreen)screen;
        if (screen2.tooltipText == null) {
            return;
        }
        if (screen2.tooltipOutlineColour == null) {
            return;
        }
        event.setBorderStart(screen2.tooltipOutlineColour.intValue());
        event.setBorderEnd(screen2.tooltipOutlineColour.intValue());
    }

    private record ListMenuTooltipComponent(FormattedCharSequence text) implements TooltipComponent
    {
        public ClientTextTooltip asClientTextTooltip() {
            return new ClientTextTooltip(this.text);
        }
    }
}

