/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.forge;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.impl.forge.ForgeFolderEntry;
import com.mrcrayfish.configured.impl.forge.ForgeListValue;
import com.mrcrayfish.configured.impl.forge.ForgeValue;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class ForgeConfig
implements IModConfig {
    protected static final EnumMap<ModConfig.Type, ConfigType> TYPE_RESOLVER = (EnumMap)Util.m_137469_(new EnumMap(ModConfig.Type.class), map -> {
        map.put(ModConfig.Type.CLIENT, ConfigType.CLIENT);
        map.put(ModConfig.Type.COMMON, ConfigType.UNIVERSAL);
        map.put(ModConfig.Type.SERVER, ConfigType.WORLD_SYNC);
    });
    protected final ModConfig config;
    protected final ForgeConfigSpec spec;
    protected final List<ForgeValueEntry> allConfigValues;

    public ForgeConfig(ModConfig config, ForgeConfigSpec spec) {
        this.config = config;
        Objects.requireNonNull(spec, "spec is null");
        this.spec = spec;
        this.allConfigValues = ForgeConfig.getAllConfigValues(this.spec);
    }

    @Override
    public void update(IConfigEntry entry) {
        Set<IConfigValue<?>> changedValues = ConfigHelper.getChangedValues(entry);
        if (!changedValues.isEmpty()) {
            CommentedConfig newConfig = CommentedConfig.copy((UnmodifiableCommentedConfig)this.config.getConfigData());
            changedValues.forEach(value -> {
                if (value instanceof ForgeValue) {
                    ForgeListValue forgeList;
                    List converted;
                    ForgeValue forge = (ForgeValue)value;
                    if (forge instanceof ForgeListValue && (converted = (forgeList = (ForgeListValue)forge).getConverted()) != null) {
                        newConfig.set(forge.configValue.getPath(), converted);
                        return;
                    }
                    newConfig.set(forge.configValue.getPath(), value.get());
                }
            });
            this.config.getConfigData().putAll((UnmodifiableConfig)newConfig);
        }
        if (this.getType() == ConfigType.WORLD_SYNC) {
            if (!ConfigHelper.isPlayingGame()) {
                this.config.getHandler().unload(this.config.getFullPath().getParent(), this.config);
                ConfigHelper.setForgeConfigData(this.config, null);
            }
        } else if (!changedValues.isEmpty()) {
            Configured.LOGGER.info("Sending config reloading event for {}", (Object)this.config.getFileName());
            this.spec.afterReload();
            ConfigHelper.fireForgeConfigEvent(this.config, (ModConfigEvent)new ModConfigEvent.Reloading(this.config));
        }
    }

    @Override
    public IConfigEntry getRoot() {
        return new ForgeFolderEntry(this.spec.getValues(), this.spec);
    }

    @Override
    public ConfigType getType() {
        return TYPE_RESOLVER.get(this.config.getType());
    }

    @Override
    public String getFileName() {
        return this.config.getFileName();
    }

    @Override
    public String getModId() {
        return this.config.getModId();
    }

    @Override
    public void loadWorldConfig(Path path, Consumer<IModConfig> result) {
        CommentedFileConfig data = (CommentedFileConfig)this.config.getHandler().reader(path).apply(this.config);
        ConfigHelper.setForgeConfigData(this.config, (CommentedConfig)data);
        result.accept(this);
    }

    @Override
    public void stopEditing() {
        if (this.config != null && this.getType() == ConfigType.WORLD && !ConfigHelper.isPlayingGame()) {
            this.config.getHandler().unload(this.config.getFullPath().getParent(), this.config);
            ConfigHelper.setForgeConfigData(this.config, null);
        }
    }

    @Override
    public boolean isChanged() {
        if (ConfigHelper.isWorldConfig(this) && this.config.getConfigData() == null) {
            return false;
        }
        return this.allConfigValues.stream().anyMatch(entry -> !Objects.equals(entry.value.get(), entry.spec.getDefault()));
    }

    @Override
    public void restoreDefaults() {
        if (ConfigHelper.isWorldConfig(this) && this.config.getConfigData() == null) {
            return;
        }
        CommentedConfig newConfig = CommentedConfig.copy((UnmodifiableCommentedConfig)this.config.getConfigData());
        this.allConfigValues.forEach(entry -> newConfig.set(entry.value.getPath(), entry.spec.getDefault()));
        this.config.getConfigData().putAll((UnmodifiableConfig)newConfig);
        this.allConfigValues.forEach(pair -> pair.value.clearCache());
    }

    protected static List<ForgeValueEntry> getAllConfigValues(ForgeConfigSpec spec) {
        return ConfigHelper.gatherAllForgeConfigValues(spec.getValues(), (UnmodifiableConfig)spec).stream().map(pair -> new ForgeValueEntry((ForgeConfigSpec.ConfigValue)pair.getLeft(), (ForgeConfigSpec.ValueSpec)pair.getRight())).toList();
    }

    protected record ForgeValueEntry(ForgeConfigSpec.ConfigValue<?> value, ForgeConfigSpec.ValueSpec spec) {
    }
}

