/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client;

import com.mrcrayfish.configured.client.ClientHandler;
import com.mrcrayfish.configured.client.EditingTracker;
import com.mrcrayfish.configured.impl.framework.message.MessageFramework;
import com.mrcrayfish.configured.network.message.MessageSessionData;
import com.mrcrayfish.configured.platform.Services;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_634;

public class ClientConfigured
implements ClientModInitializer {
    public void onInitializeClient() {
        ClientHandler.init();
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> EditingTracker.instance().onScreenOpen(screen));
        if (this.isModListInstalled()) {
            KeyBindingHelper.registerKeyBinding((class_304)ClientHandler.KEY_OPEN_MOD_LIST);
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                while (ClientHandler.KEY_OPEN_MOD_LIST.method_1436()) {
                    this.openModList();
                }
            });
        }
        ClientPlayNetworking.registerGlobalReceiver((class_2960)MessageSessionData.ID, (client, handler, buf, responseSender) -> MessageSessionData.handle(MessageSessionData.decode(buf), arg_0 -> ((class_310)client).execute(arg_0)));
        if (Services.PLATFORM.isModLoaded("framework")) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)MessageFramework.Response.ID, (client, handler, buf, responseSender) -> MessageFramework.Response.handle(MessageFramework.Response.decode(buf), arg_0 -> ((class_310)client).execute(arg_0), (class_1657)client.field_1724, arg_0 -> ((class_634)handler).method_10839(arg_0)));
        }
    }

    private boolean isModListInstalled() {
        return FabricLoader.getInstance().isModLoaded("catalogue") || FabricLoader.getInstance().isModLoaded("modmenu");
    }

    private void openModList() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null || minecraft.field_1755 != null) {
            return;
        }
        class_437 newScreen = null;
        if (FabricLoader.getInstance().isModLoaded("catalogue")) {
            newScreen = this.createModListScreen("com.mrcrayfish.catalogue.client.screen.CatalogueModListScreen");
        } else if (FabricLoader.getInstance().isModLoaded("modmenu")) {
            newScreen = this.createModListScreen("com.terraformersmc.modmenu.gui.ModsScreen");
        }
        if (newScreen != null) {
            minecraft.method_1507(newScreen);
        }
    }

    private class_437 createModListScreen(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (class_437)clazz.getDeclaredConstructor(class_437.class).newInstance(null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

