/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ActiveConfirmationScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.EditStringScreen;
import com.mrcrayfish.configured.client.screen.IEditing;
import com.mrcrayfish.configured.client.screen.list.IListType;
import com.mrcrayfish.configured.client.screen.list.ListTypes;
import com.mrcrayfish.configured.client.screen.widget.ConfiguredButton;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import org.apache.commons.lang3.tuple.Pair;

public class EditListScreen<T>
extends class_437
implements IEditing {
    private final class_437 parent;
    private final IModConfig config;
    private final List<StringHolder> initialValues = new ArrayList<StringHolder>();
    private final List<StringHolder> values = new ArrayList<StringHolder>();
    private final IConfigValue<List<T>> holder;
    private final IListType<T> listType;
    private ObjectList list;

    public EditListScreen(class_437 parent, IModConfig config, class_2561 titleIn, IConfigValue<List<T>> holder) {
        super(titleIn);
        this.parent = parent;
        this.config = config;
        this.holder = holder;
        this.listType = ListTypes.getType(holder);
        this.initialValues.addAll(holder.get().stream().map(o -> new StringHolder(this.listType.getStringParser().apply(o))).toList());
        this.values.addAll(this.initialValues);
    }

    protected void method_25426() {
        boolean readOnly;
        this.list = new ObjectList();
        this.method_25429((class_364)this.list);
        if (!this.config.isReadOnly()) {
            this.method_37063((class_364)new IconButton(this.field_22789 / 2 - 140, this.field_22790 - 29, 0, 44, 90, (class_2561)class_2561.method_43471((String)"configured.gui.apply"), button -> {
                List newValues = this.values.stream().map(StringHolder::getValue).map(s -> this.listType.getValueParser().apply((String)s)).collect(Collectors.toList());
                this.holder.set(newValues);
                this.field_22787.method_1507(this.parent);
            }));
            this.method_37063((class_364)new IconButton(this.field_22789 / 2 - 45, this.field_22790 - 29, 22, 33, 90, (class_2561)class_2561.method_43471((String)"configured.gui.add_value"), button -> this.field_22787.method_1507((class_437)new EditStringScreen(this, this.config, (class_2561)class_2561.method_43471((String)"configured.gui.edit_value"), "", s -> {
                T value = this.listType.getValueParser().apply((String)s);
                if (value != null) {
                    if (this.holder.isValid(Collections.singletonList(value))) {
                        return Pair.of((Object)true, (Object)class_5244.field_39003);
                    }
                    return Pair.of((Object)false, (Object)this.holder.getValidationHint());
                }
                return Pair.of((Object)false, (Object)this.listType.getHint());
            }, s -> {
                StringHolder holder = new StringHolder((String)s);
                this.values.add(holder);
                this.list.addEntry(new StringEntry(this.list, holder));
            }))));
        }
        int cancelWidth = (readOnly = this.config.isReadOnly()) ? 150 : 90;
        int cancelOffset = readOnly ? -75 : 50;
        class_2561 cancelLabel = readOnly ? class_2561.method_43471((String)"configured.gui.close") : class_5244.field_24335;
        this.method_37063((class_364)ScreenUtil.button(this.field_22789 / 2 + cancelOffset, this.field_22790 - 29, cancelWidth, 20, cancelLabel, button -> {
            if (this.isModified()) {
                ActiveConfirmationScreen confirmScreen = new ActiveConfirmationScreen(this, this.config, (class_2561)class_2561.method_43471((String)"configured.gui.list_changed"), ConfirmationScreen.Icon.WARNING, result -> {
                    if (!result.booleanValue()) {
                        return true;
                    }
                    this.field_22787.method_1507(this.parent);
                    return false;
                });
                this.field_22787.method_1507((class_437)confirmScreen);
            } else {
                this.field_22787.method_1507(this.parent);
            }
        }));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.list.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 14, 0xFFFFFF);
    }

    @Override
    public IModConfig getActiveConfig() {
        return this.config;
    }

    public boolean isModified() {
        if (this.initialValues.size() != this.values.size()) {
            return true;
        }
        for (int i = 0; i < this.initialValues.size(); ++i) {
            String s2;
            String s1 = this.initialValues.get(i).getValue();
            if (s1.equals(s2 = this.values.get(i).getValue())) continue;
            return true;
        }
        return false;
    }

    public class ObjectList
    extends class_4265<StringEntry> {
        public ObjectList() {
            super(EditListScreen.this.field_22787, EditListScreen.this.field_22789, EditListScreen.this.field_22790 - 36 - 36, 36, 24);
            EditListScreen.this.values.forEach(value -> this.addEntry(new StringEntry(this, (StringHolder)value)));
        }

        protected int method_25329() {
            return this.field_22758 / 2 + 144;
        }

        public int method_25322() {
            return 260;
        }

        public int addEntry(StringEntry entry) {
            return super.method_25321((class_350.class_351)entry);
        }

        public boolean removeEntry(StringEntry entry) {
            return super.method_25330((class_350.class_351)entry);
        }
    }

    public static class StringHolder {
        private String value;

        public StringHolder(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public class StringEntry
    extends class_4265.class_4266<StringEntry> {
        private final StringHolder holder;
        private final ObjectList list;
        private final ConfiguredButton editButton;
        private final ConfiguredButton deleteButton;

        public StringEntry(ObjectList list, StringHolder holder) {
            this.list = list;
            this.holder = holder;
            this.editButton = new IconButton(0, 0, 1, 22, 20, class_5244.field_39003, onPress -> EditListScreen.this.field_22787.method_1507((class_437)new EditStringScreen(EditListScreen.this, EditListScreen.this.config, (class_2561)class_2561.method_43471((String)"configured.gui.edit_value"), this.holder.getValue(), s -> {
                Object value = EditListScreen.this.listType.getValueParser().apply((String)s);
                if (value != null) {
                    if (EditListScreen.this.holder.isValid(Collections.singletonList(value))) {
                        return Pair.of((Object)true, (Object)class_5244.field_39003);
                    }
                    return Pair.of((Object)false, (Object)EditListScreen.this.holder.getValidationHint());
                }
                return Pair.of((Object)false, (Object)EditListScreen.this.listType.getHint());
            }, this.holder::setValue)));
            this.editButton.setTooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"configured.gui.edit")), btn -> btn.method_37303() && btn.method_25367());
            this.editButton.field_22763 = !EditListScreen.this.config.isReadOnly();
            this.deleteButton = new IconButton(0, 0, 11, 0, onPress -> {
                EditListScreen.this.values.remove(this.holder);
                this.list.removeEntry(this);
            });
            this.deleteButton.setTooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"configured.gui.remove")), btn -> btn.method_37303() && btn.method_25367());
            this.deleteButton.field_22763 = !EditListScreen.this.config.isReadOnly();
        }

        public void method_25343(class_332 graphics, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean selected, float partialTicks) {
            if (x % 2 != 0) {
                graphics.method_25294(left, top, left + width, top + 24, 0x55000000);
            }
            graphics.method_27535(((EditListScreen)EditListScreen.this).field_22787.field_1772, (class_2561)class_2561.method_43470((String)this.holder.getValue()), left + 5, top + 8, 0xFFFFFF);
            this.editButton.field_22764 = true;
            this.editButton.method_46421(left + width - 44);
            this.editButton.method_46419(top + 2);
            this.editButton.method_25394(graphics, mouseX, mouseY, partialTicks);
            this.deleteButton.field_22764 = true;
            this.deleteButton.method_46421(left + width - 22);
            this.deleteButton.method_46419(top + 2);
            this.deleteButton.method_25394(graphics, mouseX, mouseY, partialTicks);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)((Object)this.editButton), (Object)((Object)this.deleteButton));
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 output) {
                    output.method_37033(class_6381.field_33788, StringEntry.this.holder.getValue());
                }
            }, (Object)((Object)this.editButton), (Object)((Object)this.deleteButton));
        }
    }
}

