/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.Environment;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.SessionData;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.RequestScreen;
import com.mrcrayfish.configured.client.screen.WorldSelectionScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.platform.Services;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_746;
import org.apache.commons.io.FilenameUtils;

public class ModConfigSelectionScreen
extends ListMenuScreen {
    private final Map<ConfigType, Set<IModConfig>> configMap;

    public ModConfigSelectionScreen(class_437 parent, class_2561 title, Map<ConfigType, Set<IModConfig>> configMap) {
        super(parent, title, 30);
        this.configMap = configMap;
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        Set<IModConfig> remoteConfigs;
        Set<IModConfig> localConfigs = this.getLocalConfigs();
        if (!localConfigs.isEmpty()) {
            entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(class_2561.method_43471((String)"configured.gui.title.client_configuration").getString()));
            ArrayList localEntries = new ArrayList();
            localConfigs.forEach(config -> localEntries.add(new FileItem((IModConfig)config)));
            Collections.sort(localEntries);
            entries.addAll(localEntries);
        }
        if (!((remoteConfigs = this.getRemoteConfigs()).isEmpty() || ConfigHelper.isPlayingGame() && !ConfigHelper.isConfiguredInstalledOnServer())) {
            class_746 player = class_310.method_1551().field_1724;
            if (ConfigHelper.isPlayingGame() && ModConfigSelectionScreen.isPlayingRemotely()) {
                if (SessionData.isLan()) {
                    entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(class_2561.method_43471((String)"configured.gui.title.server_configuration").getString()));
                    entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((class_2561)class_2561.method_43471((String)"configured.gui.lan_server")));
                    return;
                }
                if (!ConfigHelper.isOperator((class_1657)player)) {
                    return;
                }
                if (!SessionData.isDeveloper((class_1657)player)) {
                    entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(class_2561.method_43471((String)"configured.gui.title.server_configuration").getString()));
                    entries.add(new ListMenuScreen.MultiTextItem((class_2561)class_2561.method_43471((String)"configured.gui.no_developer_status"), (class_2561)class_2561.method_43469((String)"configured.gui.developer_details", (Object[])new Object[]{class_2561.method_43470((String)"configured.developer.toml").method_27692(class_124.field_1065).method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)))}).method_27692(class_124.field_1080).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"configured.gui.developer_file"))))));
                    return;
                }
            }
            entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(class_2561.method_43471((String)"configured.gui.title.server_configuration").getString()));
            ArrayList remoteEntries = new ArrayList();
            remoteConfigs.forEach(config -> remoteEntries.add(new FileItem((IModConfig)config)));
            Collections.sort(remoteEntries);
            entries.addAll(remoteEntries);
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)ScreenUtil.button(this.field_22789 / 2 - 75, this.field_22790 - 29, 150, 20, class_5244.field_24339, button -> this.field_22787.method_1507(this.parent)));
    }

    private Set<IModConfig> getLocalConfigs() {
        return this.configMap.entrySet().stream().filter(entry -> !((ConfigType)((Object)((Object)entry.getKey()))).isServer()).flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    private Set<IModConfig> getRemoteConfigs() {
        return this.configMap.entrySet().stream().filter(entry -> {
            ConfigType type = (ConfigType)((Object)((Object)entry.getKey()));
            return type.isServer() && type.getEnv().orElse(null) != Environment.DEDICATED_SERVER;
        }).flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    public static String createLabelFromModConfig(IModConfig config) {
        if (config.getTranslationKey() != null) {
            return class_1074.method_4662((String)config.getTranslationKey(), (Object[])new Object[0]);
        }
        String fileName = config.getFileName();
        if ((fileName = fileName.replace(config.getModId() + "-", "")).endsWith(".toml")) {
            fileName = fileName.substring(0, fileName.length() - ".toml".length());
        }
        fileName = FilenameUtils.getName((String)fileName);
        fileName = ConfigScreen.createLabel(fileName);
        return fileName;
    }

    public static boolean canEditConfig(@Nullable class_1657 player, IModConfig config) {
        return switch (config.getType()) {
            default -> throw new MatchException(null, null);
            case ConfigType.CLIENT -> {
                if (Services.PLATFORM.getEnvironment() == Environment.CLIENT) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.UNIVERSAL, ConfigType.MEMORY -> true;
            case ConfigType.SERVER, ConfigType.WORLD, ConfigType.SERVER_SYNC, ConfigType.WORLD_SYNC -> {
                if (!ConfigHelper.isPlayingGame() || ModConfigSelectionScreen.isRunningLocalServer() || ConfigHelper.isOperator(player) && SessionData.isDeveloper(player)) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.DEDICATED_SERVER -> false;
        };
    }

    public static boolean canRestoreConfig(class_1657 player, IModConfig config) {
        return switch (config.getType()) {
            default -> throw new MatchException(null, null);
            case ConfigType.CLIENT, ConfigType.UNIVERSAL, ConfigType.MEMORY -> true;
            case ConfigType.SERVER, ConfigType.SERVER_SYNC -> {
                if (!ConfigHelper.isPlayingGame() || ModConfigSelectionScreen.isRunningLocalServer()) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.WORLD, ConfigType.WORLD_SYNC -> ModConfigSelectionScreen.isRunningLocalServer();
            case ConfigType.DEDICATED_SERVER -> false;
        };
    }

    public static boolean isRunningLocalServer() {
        return class_310.method_1551().method_1496();
    }

    public static boolean isPlayingRemotely() {
        class_634 listener = class_310.method_1551().method_1562();
        return listener != null && !listener.method_48296().method_10756();
    }

    public class FileItem
    extends ListMenuScreen.Item {
        protected final IModConfig config;
        protected final class_2561 title;
        protected final class_2561 fileName;
        protected final class_4185 modifyButton;
        @Nullable
        protected final class_4185 restoreButton;

        public FileItem(IModConfig config) {
            super(ModConfigSelectionScreen.createLabelFromModConfig(config));
            this.config = config;
            this.title = this.createTrimmedFileName(ModConfigSelectionScreen.createLabelFromModConfig(config));
            this.fileName = this.createTrimmedFileName(config.getFileName()).method_27692(class_124.field_1063);
            this.modifyButton = this.createModifyButton(config);
            this.modifyButton.field_22763 = ModConfigSelectionScreen.canEditConfig((class_1657)class_310.method_1551().field_1724, config);
            this.restoreButton = this.createRestoreButton(config);
            this.updateRestoreDefaultButton();
        }

        private void showRestoreScreen() {
            ConfirmationScreen confirmScreen = new ConfirmationScreen(ModConfigSelectionScreen.this, (class_2561)class_2561.method_43471((String)"configured.gui.restore_message"), ConfirmationScreen.Icon.WARNING, result -> {
                if (!result.booleanValue()) {
                    return true;
                }
                this.config.restoreDefaults();
                this.updateRestoreDefaultButton();
                return true;
            });
            confirmScreen.setPositiveText((class_2561)class_2561.method_43471((String)"configured.gui.restore").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}));
            confirmScreen.setNegativeText(class_5244.field_24335);
            class_310.method_1551().method_1507((class_437)confirmScreen);
        }

        private class_5250 createTrimmedFileName(String fileName) {
            class_5250 trimmedFileName = class_2561.method_43470((String)fileName);
            if (class_310.method_1551().field_1772.method_1727(fileName) > 150) {
                trimmedFileName = class_2561.method_43470((String)(class_310.method_1551().field_1772.method_27523(fileName, 140) + "..."));
            }
            return trimmedFileName;
        }

        private class_4185 createModifyButton(IModConfig config) {
            int width = ModConfigSelectionScreen.canRestoreConfig((class_1657)class_310.method_1551().field_1724, config) ? 60 : 82;
            return new IconButton(0, 0, this.getModifyIconU(config), this.getModifyIconV(config), width, this.getModifyLabel(config), button -> {
                if (!button.method_37303() || !button.field_22764) {
                    return;
                }
                if (!ConfigHelper.isPlayingGame()) {
                    if (ConfigHelper.isWorldConfig(config)) {
                        class_310.method_1551().method_1507((class_437)new WorldSelectionScreen((class_437)ModConfigSelectionScreen.this, config, this.title));
                    } else if (config.getType() != ConfigType.DEDICATED_SERVER) {
                        class_5250 newTitle = ModConfigSelectionScreen.this.field_22785.method_27661().method_10852((class_2561)class_2561.method_43470((String)" > ").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).method_10852(this.title);
                        class_310.method_1551().method_1507((class_437)new ConfigScreen((class_437)ModConfigSelectionScreen.this, (class_2561)newTitle, config));
                    }
                    return;
                }
                if (ModConfigSelectionScreen.isPlayingRemotely() && config.getType().isServer() && !config.getType().isSync()) {
                    if (Services.PLATFORM.isModLoaded(config.getModId())) {
                        class_5250 newTitle = ModConfigSelectionScreen.this.field_22785.method_27661().method_10852((class_2561)class_2561.method_43470((String)" > ").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).method_10852(this.title);
                        class_310.method_1551().method_1507((class_437)new RequestScreen((class_437)ModConfigSelectionScreen.this, (class_2561)newTitle, config));
                    }
                    return;
                }
                if (Services.PLATFORM.isModLoaded(config.getModId())) {
                    class_5250 newTitle = ModConfigSelectionScreen.this.field_22785.method_27661().method_10852((class_2561)class_2561.method_43470((String)" > ").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).method_10852(this.title);
                    class_310.method_1551().method_1507((class_437)new ConfigScreen((class_437)ModConfigSelectionScreen.this, (class_2561)newTitle, config));
                }
            });
        }

        private int getModifyIconU(IModConfig config) {
            if (!ConfigHelper.isPlayingGame() && ConfigHelper.isWorldConfig(config)) {
                return 11;
            }
            return 0;
        }

        private int getModifyIconV(IModConfig config) {
            if (ConfigHelper.isPlayingGame() ? config.isReadOnly() : config.isReadOnly() && !ConfigHelper.isWorldConfig(config)) {
                return 33;
            }
            return 22;
        }

        private class_2561 getModifyLabel(IModConfig config) {
            if (!ConfigHelper.isPlayingGame() && ConfigHelper.isWorldConfig(config)) {
                return class_2561.method_43471((String)"configured.gui.select_world");
            }
            if (config.isReadOnly()) {
                return class_2561.method_43471((String)"configured.gui.view");
            }
            return class_2561.method_43471((String)"configured.gui.modify");
        }

        private class_4185 createRestoreButton(IModConfig config) {
            if (ModConfigSelectionScreen.canRestoreConfig((class_1657)class_310.method_1551().field_1724, config)) {
                IconButton restoreButton = new IconButton(0, 0, 0, 0, onPress -> this.showRestoreScreen());
                restoreButton.field_22763 = !config.isReadOnly() && ConfigHelper.hasPermissionToEdit((class_1657)class_310.method_1551().field_1724, config);
                return restoreButton;
            }
            return null;
        }

        @Override
        public void method_25343(class_332 graphics, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            graphics.method_27535(class_310.method_1551().field_1772, this.title, left + 28, top + 2, 0xFFFFFF);
            graphics.method_27535(class_310.method_1551().field_1772, this.fileName, left + 28, top + 12, 0xFFFFFF);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.method_25293(IconButton.ICONS, left + 4, top, 18, 22, (float)this.getIconU(), (float)this.getIconV(), 9, 11, 64, 64);
            if (this.config.isReadOnly()) {
                graphics.method_25293(IconButton.ICONS, left + 1, top + 15, 11, 11, 0.0f, 33.0f, 11, 11, 64, 64);
            }
            this.modifyButton.method_46421(left + width - 83);
            this.modifyButton.method_46419(top);
            this.modifyButton.method_25394(graphics, mouseX, mouseY, partialTicks);
            if (this.restoreButton != null) {
                this.restoreButton.method_46421(left + width - 21);
                this.restoreButton.method_46419(top);
                this.restoreButton.method_25394(graphics, mouseX, mouseY, partialTicks);
            }
            if (this.config.isReadOnly() && ScreenUtil.isMouseWithin(left - 1, top + 15, 11, 11, mouseX, mouseY)) {
                ModConfigSelectionScreen.this.setActiveTooltip((class_2561)class_2561.method_43471((String)"configured.gui.read_only_config"), -14785178);
            }
        }

        private int getIconU() {
            return this.config.getType().ordinal() % 3 * 9 + 33;
        }

        private int getIconV() {
            return this.config.getType().ordinal() / 3 * 11;
        }

        @Override
        public List<? extends class_364> method_25396() {
            if (this.restoreButton != null) {
                return ImmutableList.of((Object)this.modifyButton, (Object)this.restoreButton);
            }
            return ImmutableList.of((Object)this.modifyButton);
        }

        private void updateRestoreDefaultButton() {
            if (this.config != null && this.restoreButton != null && ModConfigSelectionScreen.canRestoreConfig((class_1657)class_310.method_1551().field_1724, this.config)) {
                this.restoreButton.field_22763 = !this.config.isReadOnly() && this.config.isChanged();
            }
        }
    }
}

