/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.ModConfigSelectionScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.platform.Services;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_332;
import net.minecraft.class_34;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5218;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.apache.commons.io.file.PathUtils;

public class WorldSelectionScreen
extends ListMenuScreen {
    private static final class_5218 SERVER_CONFIG_FOLDER = Services.CONFIG.getServerConfigResource();
    private static final class_2960 MISSING_ICON = new class_2960("textures/misc/unknown_server.png");
    private final IModConfig config;

    public WorldSelectionScreen(class_437 parent, IModConfig config, class_2561 title) {
        super(parent, (class_2561)class_2561.method_43469((String)"configured.gui.edit_world_config", (Object[])new Object[]{title.method_27662().method_27695(new class_124[]{class_124.field_1067, class_124.field_1065})}), 30);
        this.config = config;
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        try {
            class_32 source = class_310.method_1551().method_1586();
            ArrayList levels = new ArrayList((Collection)source.method_43417(source.method_235()).join());
            if (levels.size() > 6) {
                entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((class_2561)class_2561.method_43471((String)"configured.gui.title.recently_played").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054})));
                List<class_34> recent = levels.stream().sorted(Comparator.comparing(s -> -s.method_249())).limit(3L).toList();
                recent.forEach(summary -> entries.add(new WorldItem((class_34)summary)));
                levels.removeAll(recent);
                entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((class_2561)class_2561.method_43471((String)"configured.gui.title.other_worlds").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054})));
            }
            levels.stream().sorted(Comparator.comparing(class_34::method_252)).forEach(summary -> entries.add(new WorldItem((class_34)summary)));
        }
        catch (class_33 e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)ScreenUtil.button(this.field_22789 / 2 - 75, this.field_22790 - 29, 150, 20, class_5244.field_24339, button -> this.field_22787.method_1507(this.parent)));
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)(this.field_22789 - 30), 15.0f, 0.0f);
        graphics.method_51448().method_22905(2.5f, 2.5f, 2.5f);
        graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"?").method_27692(class_124.field_1067), 0, 0, 0xFFFFFF);
        graphics.method_51448().method_22909();
    }

    @Override
    protected void updateTooltip(int mouseX, int mouseY) {
        super.updateTooltip(mouseX, mouseY);
        if (ScreenUtil.isMouseWithin(this.field_22789 - 30, 15, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip((class_2561)class_2561.method_43471((String)"configured.gui.server_config_info"));
        }
    }

    public void method_25419() {
        super.method_25419();
        this.entries.forEach(item -> {
            if (item instanceof WorldItem) {
                ((WorldItem)item).disposeIcon();
            }
        });
    }

    public class WorldItem
    extends ListMenuScreen.Item {
        private final class_2561 worldName;
        private final class_2561 folderName;
        private final class_2960 iconId;
        private Path iconFile;
        private final class_1043 texture;
        private final class_4185 modifyButton;

        public WorldItem(class_34 summary) {
            super(summary.method_252());
            this.worldName = class_2561.method_43470((String)summary.method_252());
            this.folderName = class_2561.method_43470((String)summary.method_248()).method_27692(class_124.field_1063);
            this.iconId = new class_2960("minecraft", "worlds/" + class_156.method_30309((String)summary.method_248(), class_2960::method_29184) + "/" + String.valueOf(Hashing.sha1().hashUnencodedChars((CharSequence)summary.method_248())) + "/icon");
            this.iconFile = summary.method_27020();
            if (!Files.isRegularFile(this.iconFile, new LinkOption[0])) {
                this.iconFile = null;
            }
            this.texture = this.loadWorldIcon();
            this.modifyButton = new IconButton(0, 0, 0, this.getIconV(), 60, this.getButtonLabel(), onPress -> this.loadWorldConfig(summary.method_248(), summary.method_252()));
        }

        private class_2561 getButtonLabel() {
            if (WorldSelectionScreen.this.config.isReadOnly()) {
                return class_2561.method_43471((String)"configured.gui.view");
            }
            return class_2561.method_43471((String)"configured.gui.select");
        }

        private int getIconV() {
            if (WorldSelectionScreen.this.config.isReadOnly()) {
                return 33;
            }
            return 22;
        }

        @Override
        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.modifyButton);
        }

        @Override
        public void method_25343(class_332 graphics, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            if (x % 2 != 0) {
                graphics.method_25294(left, top, left + width, top + 24, 0x55000000);
            }
            if (this.modifyButton.method_25405((double)mouseX, (double)mouseY)) {
                graphics.method_25294(left - 1, top - 1, left + 25, top + 25, -1);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.method_25293(this.texture != null ? this.iconId : MISSING_ICON, left, top, 24, 24, 0.0f, 0.0f, 64, 64, 64, 64);
            graphics.method_27535(((WorldSelectionScreen)WorldSelectionScreen.this).field_22787.field_1772, this.worldName, left + 30, top + 3, 0xFFFFFF);
            graphics.method_27535(((WorldSelectionScreen)WorldSelectionScreen.this).field_22787.field_1772, this.folderName, left + 30, top + 13, 0xFFFFFF);
            this.modifyButton.method_46421(left + width - 61);
            this.modifyButton.method_46419(top + 2);
            this.modifyButton.method_25394(graphics, mouseX, mouseY, partialTicks);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private class_1043 loadWorldIcon() {
            if (this.iconFile == null) {
                return null;
            }
            try (InputStream is = Files.newInputStream(this.iconFile, new OpenOption[0]);){
                class_1043 class_10432;
                block19: {
                    class_1011 image;
                    block17: {
                        class_1043 class_10433;
                        block18: {
                            image = class_1011.method_4309((InputStream)is);
                            try {
                                if (image.method_4307() == 64 && image.method_4323() == 64) break block17;
                                class_10433 = null;
                                if (image == null) break block18;
                            }
                            catch (Throwable throwable) {
                                if (image != null) {
                                    try {
                                        image.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            image.close();
                        }
                        return class_10433;
                    }
                    class_1043 texture = new class_1043(image);
                    WorldSelectionScreen.this.field_22787.method_1531().method_4616(this.iconId, (class_1044)texture);
                    class_10432 = texture;
                    if (image == null) break block19;
                    image.close();
                }
                return class_10432;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public void disposeIcon() {
            if (this.texture != null) {
                this.texture.close();
            }
        }

        private void loadWorldConfig(String worldFileName, String worldName) {
            try (class_32.class_5143 storageAccess = class_310.method_1551().method_1586().method_27002(worldFileName);){
                Path worldConfigPath = storageAccess.method_27010(SERVER_CONFIG_FOLDER);
                PathUtils.createParentDirectories((Path)worldConfigPath, (FileAttribute[])new FileAttribute[0]);
                if (!Files.isDirectory(worldConfigPath, new LinkOption[0])) {
                    Files.createDirectory(worldConfigPath, new FileAttribute[0]);
                }
                WorldSelectionScreen.this.config.loadWorldConfig(worldConfigPath, (IModConfig T) -> {
                    if (Services.PLATFORM.isModLoaded(T.getModId())) {
                        class_5250 configName = class_2561.method_43470((String)ModConfigSelectionScreen.createLabelFromModConfig(WorldSelectionScreen.this.config));
                        class_5250 newTitle = class_2561.method_43470((String)worldName).method_27661().method_10852((class_2561)class_2561.method_43470((String)" > ").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).method_10852((class_2561)configName);
                        WorldSelectionScreen.this.field_22787.method_1507((class_437)new ConfigScreen(WorldSelectionScreen.this.parent, (class_2561)newTitle, (IModConfig)T));
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

