/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured;

import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.simple.BoolProperty;
import com.mrcrayfish.configured.api.simple.EnumProperty;
import com.mrcrayfish.configured.api.simple.ListProperty;
import com.mrcrayfish.configured.api.simple.SimpleConfig;
import com.mrcrayfish.configured.api.simple.SimpleProperty;
import com.mrcrayfish.configured.api.simple.validate.Validator;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public class Config {
    @SimpleConfig(id="configured", name="client", type=ConfigType.CLIENT)
    public static final Client CLIENT = new Client();
    @SimpleConfig(id="configured", name="developer", type=ConfigType.DEDICATED_SERVER, readOnly=true)
    public static final Developer DEVELOPER = new Developer();

    public static class Client {
        @SimpleProperty(name="force_configured_menu", comment="Forces all config menus to be overridden and generated by Configured. This requires the game to be restarted for the changes to apply.", gameRestart=true)
        public final BoolProperty forceConfiguredMenu = BoolProperty.create(false);
        @SimpleProperty(name="include_folders_in_search", comment="Include folders when searching in config menus. By default, only entries that link to a config property are shown in searches.")
        public final BoolProperty includeFoldersInSearch = BoolProperty.create(false);
        @SimpleProperty(name="changed_formatting", comment="The formatting to apply to the label of a config property that has been changed")
        public final EnumProperty<class_124> changedFormatting = EnumProperty.create(class_124.field_1056, Set.of(class_124.values()));
    }

    public static class Developer {
        @SimpleProperty(name="enabled", comment="Developer mode. This enables the ability to edit server configs on dedicated servers.\nYou will have to restart your server for developer mode to be updated.\n############ READ ME ################################################################\nYou should only enable this mode only if you are developing the server. It is       #\nrecommended that this mode is turned off if your server is public or have players on#\nyour server you don't trust, as leaving this mode enabled is considered insecure in #\nthose scenarios.                                                                    #\n#####################################################################################")
        public final BoolProperty enabled = BoolProperty.create(false);
        @SimpleProperty(name="developers", comment="A list of UUIDs of players who are developers for this server. The players will\nadditionally need to have operator permissions. Developers will have the ability to\nedit server configs on your dedicated server. Only add players you trust.")
        public final ListProperty<String> developers = ListProperty.create(ListProperty.STRING, new Validator<String>(){
            private static final Pattern UUID_PATTERN = Pattern.compile("^[\\da-fA-F]{8}\\b-[\\da-fA-F]{4}\\b-[\\da-fA-F]{4}\\b-[\\da-fA-F]{4}\\b-[\\da-fA-F]{12}$");

            @Override
            public boolean test(String value) {
                return value != null && UUID_PATTERN.matcher(value).matches();
            }

            @Override
            public class_2561 getHint() {
                return class_2561.method_43471((String)"Invalid UUID");
            }
        });
        @SimpleProperty(name="broadcastLogs", comment="Broadcasts messages to all developers about changes applied to server configs")
        public final BoolProperty broadcastLogs = BoolProperty.create(true);
    }
}

