/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;

public class CheckBoxButton
extends AbstractButton {
    public static final ResourceLocation ICONS = new ResourceLocation("configured:textures/gui/icons.png");
    private final OnPress onPress;
    private boolean selected;

    public CheckBoxButton(int x, int y, OnPress onPress) {
        super(x, y, 14, 14, CommonComponents.EMPTY);
        this.onPress = onPress;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void onPress() {
        this.selected = !this.selected;
        this.onPress.onPress(this);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionColorTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        graphics.blit(ICONS, this.getX(), this.getY(), this.isHoveredOrFocused() ? 50.0f : 36.0f, this.isSelected() ? 49.0f : 35.0f, 14, 14, 64, 64);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public static interface OnPress {
        public void onPress(CheckBoxButton var1);
    }
}

