/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.forge;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.ValueEntry;
import com.mrcrayfish.configured.impl.forge.ForgeEnumValue;
import com.mrcrayfish.configured.impl.forge.ForgeListValue;
import com.mrcrayfish.configured.impl.forge.ForgeValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

public class ForgeFolderEntry
implements IConfigEntry {
    protected final List<String> path;
    protected final UnmodifiableConfig config;
    protected final ForgeConfigSpec spec;
    protected List<IConfigEntry> entries;

    public ForgeFolderEntry(UnmodifiableConfig config, ForgeConfigSpec spec) {
        this(new ArrayList<String>(), config, spec);
    }

    public ForgeFolderEntry(List<String> path, UnmodifiableConfig config, ForgeConfigSpec spec) {
        this.path = path;
        this.config = config;
        this.spec = spec;
    }

    @Override
    public List<IConfigEntry> getChildren() {
        if (this.entries == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.config.valueMap().forEach((s, o) -> {
                if (o instanceof UnmodifiableConfig) {
                    ArrayList<String> path = new ArrayList<String>(this.path);
                    path.add((String)s);
                    builder.add((Object)new ForgeFolderEntry(path, (UnmodifiableConfig)o, this.spec));
                } else if (o instanceof ForgeConfigSpec.ConfigValue) {
                    ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)o;
                    if (configValue.get() instanceof List) {
                        builder.add((Object)new ValueEntry(new ForgeListValue(configValue, (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath()))));
                    } else if (configValue.get() instanceof Enum) {
                        builder.add((Object)new ValueEntry(new ForgeEnumValue((ForgeConfigSpec.EnumValue)configValue, (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath()))));
                    } else {
                        builder.add((Object)new ValueEntry(new ForgeValue(configValue, (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath()))));
                    }
                }
            });
            this.entries = builder.build();
        }
        return this.entries;
    }

    @Override
    public boolean isRoot() {
        return this.path.isEmpty();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public IConfigValue<?> getValue() {
        return null;
    }

    @Override
    public String getEntryName() {
        return ForgeValue.lastValue(this.path, "Root");
    }

    @Override
    @Nullable
    public Component getTooltip() {
        String tooltipKey;
        String translationKey = this.getTranslationKey();
        if (translationKey != null && I18n.exists((String)(tooltipKey = translationKey + ".tooltip"))) {
            return Component.translatable((String)tooltipKey);
        }
        String comment = this.spec.getLevelComment(this.path);
        if (comment != null) {
            return Component.literal((String)comment);
        }
        return null;
    }

    @Override
    @Nullable
    public String getTranslationKey() {
        return this.spec.getLevelTranslationKey(this.path);
    }
}

