/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class ConfirmationScreen
extends Screen {
    private static final ResourceLocation MENU_LIST_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/menu_list_background.png");
    private static final ResourceLocation IN_GAME_MENU_LIST_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/inworld_menu_list_background.png");
    private static final int FADE_LENGTH = 4;
    private static final int BRIGHTNESS = 32;
    private static final int MESSAGE_PADDING = 10;
    private final Screen parent;
    private final Component message;
    private final Icon icon;
    private final Function<Boolean, Boolean> handler;
    private Component positiveText = CommonComponents.GUI_YES;
    private Component negativeText = CommonComponents.GUI_NO;
    private int startY;
    private int endY;

    public ConfirmationScreen(Screen parent, Component message, Icon icon, Function<Boolean, Boolean> handler) {
        super(message);
        this.parent = parent;
        this.message = message;
        this.icon = icon;
        this.handler = handler;
    }

    protected void init() {
        List lines = this.font.split((FormattedText)this.message, 300);
        int n = this.height / 2 - 10;
        int n2 = lines.size();
        Objects.requireNonNull(this.font);
        this.startY = n - n2 * (9 + 2) / 2 - 10 - 1;
        int n3 = lines.size();
        Objects.requireNonNull(this.font);
        this.endY = this.startY + n3 * (9 + 2) + 20;
        int offset = this.negativeText != null ? 105 : 50;
        this.addRenderableWidget((GuiEventListener)ScreenUtil.button(this.width / 2 - offset, this.endY + 10, 100, 20, this.positiveText, button -> {
            if (this.handler.apply(true).booleanValue()) {
                this.minecraft.setScreen(this.parent);
            }
        }));
        if (this.negativeText != null) {
            this.addRenderableWidget((GuiEventListener)ScreenUtil.button(this.width / 2 + 5, this.endY + 10, 100, 20, this.negativeText, button -> {
                if (this.handler.apply(false).booleanValue()) {
                    this.minecraft.setScreen(this.parent);
                }
            }));
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        List lines = this.font.split((FormattedText)this.message, 300);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(IconButton.ICONS, this.width / 2 - 10, this.startY - 30, 20, 20, (float)this.icon.u(), (float)this.icon.v(), 10, 10, 64, 64);
        ConfirmationScreen.drawListBackground(graphics, 0, this.width, this.startY, this.endY);
        for (int i = 0; i < lines.size(); ++i) {
            int lineWidth = this.font.width((FormattedCharSequence)lines.get(i));
            FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines.get(i);
            int n = this.width / 2 - lineWidth / 2;
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, formattedCharSequence, n, this.startY + 10 + i * (9 + 2) + 1, 0xFFFFFF);
        }
    }

    public void setPositiveText(Component positiveText) {
        this.positiveText = positiveText;
    }

    public void setNegativeText(@Nullable Component negativeText) {
        this.negativeText = negativeText;
    }

    public static void drawListBackground(GuiGraphics graphics, int startX, int endX, int startY, int endY) {
        boolean inGame = Minecraft.getInstance().level != null;
        RenderSystem.enableBlend();
        ResourceLocation backgroundTexture = !inGame ? MENU_LIST_BACKGROUND : IN_GAME_MENU_LIST_BACKGROUND;
        ResourceLocation headerTexture = !inGame ? Screen.HEADER_SEPARATOR : Screen.INWORLD_HEADER_SEPARATOR;
        ResourceLocation footerTexture = !inGame ? Screen.FOOTER_SEPARATOR : Screen.INWORLD_FOOTER_SEPARATOR;
        graphics.blit(backgroundTexture, startX, startY, (float)endX, (float)endY, endX - startX, endY - startY, 32, 32);
        graphics.blit(headerTexture, startX, startY - 2, 0.0f, 0.0f, endX - startX, 2, 32, 2);
        graphics.blit(footerTexture, startX, endY, 0.0f, 0.0f, endX - startX, 2, 32, 2);
        RenderSystem.disableBlend();
    }

    public static enum Icon {
        INFO(11, 44),
        WARNING(0, 11),
        ERROR(11, 11);

        private final int u;
        private final int v;

        private Icon(int u, int v) {
            this.u = u;
            this.v = v;
        }

        public int u() {
            return this.u;
        }

        public int v() {
            return this.v;
        }
    }
}

