/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.network;

import com.mrcrayfish.configured.impl.framework.message.MessageFramework;
import com.mrcrayfish.configured.network.message.MessageSessionData;
import com.mrcrayfish.configured.network.message.play.MessageSyncForgeConfig;
import com.mrcrayfish.framework.api.Environment;
import com.mrcrayfish.framework.api.util.TaskRunner;
import com.mrcrayfish.framework.util.Utils;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.SimpleChannel;
import org.jetbrains.annotations.Nullable;

public class ForgeNetwork {
    private static SimpleChannel channel;
    @Nullable
    private static WeakReference<RegistryAccess> access;

    public static void init() {
        channel = ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"configured", (String)"play")).clientAcceptedVersions((status, version) -> true).serverAcceptedVersions((status, version) -> true).networkProtocolVersion(1).simpleChannel();
        channel.play(protocol -> {
            protocol.clientbound(flow -> flow.add(MessageSessionData.class, MessageSessionData.STREAM_CODEC, (message, ctx) -> {
                MessageSessionData.handle(message, arg_0 -> ((CustomPayloadEvent.Context)ctx).enqueueWork(arg_0));
                ctx.setPacketHandled(true);
            }));
            protocol.bidirectional(flow -> flow.add(MessageSyncForgeConfig.class, MessageSyncForgeConfig.STREAM_CODEC, MessageSyncForgeConfig::handle));
        });
        if (ModList.get().isLoaded("framework")) {
            channel.play(protocol -> {
                protocol.serverbound(flow -> {
                    flow.add(MessageFramework.Sync.class, MessageFramework.Sync.STREAM_CODEC, (message, ctx) -> {
                        MessageFramework.Sync.handle(message, arg_0 -> ((CustomPayloadEvent.Context)ctx).enqueueWork(arg_0), (Player)ctx.getSender(), arg_0 -> ((Connection)ctx.getConnection()).disconnect(arg_0));
                        ctx.setPacketHandled(true);
                    });
                    flow.add(MessageFramework.Request.class, MessageFramework.Request.STREAM_CODEC, (message, ctx) -> {
                        MessageFramework.Request.handle(message, arg_0 -> ((CustomPayloadEvent.Context)ctx).enqueueWork(arg_0), (Player)ctx.getSender(), arg_0 -> ((Connection)ctx.getConnection()).disconnect(arg_0));
                        ctx.setPacketHandled(true);
                    });
                });
                protocol.clientbound(flow -> flow.add(MessageFramework.Response.class, MessageFramework.Response.STREAM_CODEC, (message, ctx) -> {
                    MessageFramework.Response.handle(message, arg_0 -> ((CustomPayloadEvent.Context)ctx).enqueueWork(arg_0), (Player)ctx.getSender(), arg_0 -> ((Connection)ctx.getConnection()).disconnect(arg_0));
                    ctx.setPacketHandled(true);
                }));
            });
        }
        MinecraftForge.EVENT_BUS.addListener(event -> {
            access = new WeakReference<RegistryAccess.Frozen>(event.getServer().registryAccess());
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            access = null;
        });
    }

    private static RegistryFriendlyByteBuf wrapBuf(FriendlyByteBuf buf) {
        return (RegistryFriendlyByteBuf)RegistryFriendlyByteBuf.decorator((RegistryAccess)ForgeNetwork.getRegistryAccess()).apply(buf);
    }

    private static RegistryAccess getRegistryAccess() {
        return (RegistryAccess)Utils.or((Object)Optional.ofNullable(access).map(Reference::get).orElse(null), (Object)((RegistryAccess)TaskRunner.callIf((Environment)Environment.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.getInstance();
            return mc.level != null ? mc.level.registryAccess() : null;
        }))).orElseThrow(() -> new RuntimeException("Failed to retrieve registry access"));
    }

    public static SimpleChannel getChannel() {
        return channel;
    }

    static {
        access = null;
    }
}

