/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.api.IAllowedEnums;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.IEditing;
import com.mrcrayfish.configured.client.screen.ILabelProvider;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.TooltipScreen;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ChangeEnumScreen
extends TooltipScreen
implements IBackgroundTexture,
IEditing {
    private final Screen parent;
    private final IModConfig config;
    private final Consumer<Enum<?>> onSave;
    private final ResourceLocation background;
    private final IConfigValue<Enum<?>> holder;
    private Enum<?> selectedValue;
    private EnumList list;
    private List<Entry> entries;
    private EditBox searchTextField;

    protected ChangeEnumScreen(Screen parent, IModConfig config, Component title, ResourceLocation background, Enum<?> value, IConfigValue<Enum<?>> holder, Consumer<Enum<?>> onSave) {
        super(title);
        this.parent = parent;
        this.config = config;
        this.onSave = onSave;
        this.background = background;
        this.holder = holder;
        this.selectedValue = value;
    }

    protected void init() {
        this.constructEntries();
        this.list = new EnumList(this.entries);
        this.list.setRenderBackground(!ConfigHelper.isPlayingGame());
        this.list.setSelected((AbstractSelectionList.Entry)((Entry)this.list.children().stream().filter(entry -> entry.getEnumValue() == this.selectedValue).findFirst().orElse(null)));
        this.addWidget((GuiEventListener)this.list);
        this.searchTextField = new EditBox(this.font, this.width / 2 - 110, 22, 220, 20, (Component)Component.translatable((String)"configured.gui.search"));
        this.searchTextField.setResponder(s -> {
            ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, s, this.entries);
            this.list.replaceEntries(s.isEmpty() ? this.entries : (Collection)this.entries.stream().filter(entry -> entry.getFormattedLabel().getString().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList()));
            if (!s.isEmpty()) {
                this.list.setScrollAmount(0.0);
            }
        });
        this.addWidget((GuiEventListener)this.searchTextField);
        ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, "", this.entries);
        if (!this.config.isReadOnly()) {
            this.addRenderableWidget((GuiEventListener)ScreenUtil.button(this.width / 2 - 155, this.height - 29, 150, 20, CommonComponents.GUI_DONE, btn -> {
                if (this.list.getSelected() != null) {
                    this.onSave.accept(((Entry)this.list.getSelected()).enumValue);
                }
                this.minecraft.setScreen(this.parent);
            }));
        }
        int cancelOffset = this.config.isReadOnly() ? -75 : 5;
        Component cancelLabel = this.config.isReadOnly() ? CommonComponents.GUI_BACK : CommonComponents.GUI_CANCEL;
        this.addRenderableWidget((GuiEventListener)ScreenUtil.button(this.width / 2 + cancelOffset, this.height - 29, 150, 20, cancelLabel, button -> this.minecraft.setScreen(this.parent)));
    }

    private void constructEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        if (this.holder instanceof IAllowedEnums) {
            ((IAllowedEnums)((Object)this.holder)).getAllowedValues().forEach(e -> entries.add(new Entry((Enum)e)));
        } else {
            Enum<?> value = this.selectedValue;
            if (value != null) {
                ?[] enums;
                for (Object e2 : enums = value.getDeclaringClass().getEnumConstants()) {
                    entries.add(new Entry((Enum)e2));
                }
            }
        }
        entries.sort(Comparator.comparing(entry -> entry.getFormattedLabel().getString()));
        this.entries = ImmutableList.copyOf(entries);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.list.render(graphics, mouseX, mouseY, partialTicks);
        this.searchTextField.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 7, 0xFFFFFF);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(ListMenuScreen.CONFIGURED_LOGO, 10, 13, 0, 0.0f, 0.0f, 23, 23, 32, 32);
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip((Component)Component.translatable((String)"configured.gui.info"));
        }
        this.drawTooltip(graphics, mouseX, mouseY);
    }

    @Override
    public IModConfig getActiveConfig() {
        return this.config;
    }

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.background;
    }

    public class EnumList
    extends AbstractSelectionList<Entry>
    implements IBackgroundTexture {
        public EnumList(List<Entry> entries) {
            super(ChangeEnumScreen.this.minecraft, ChangeEnumScreen.this.width, ChangeEnumScreen.this.height - 36 - 50, 50, 20);
            entries.forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
        }

        public void replaceEntries(Collection<Entry> entries) {
            super.replaceEntries(entries);
        }

        @Override
        public ResourceLocation getBackgroundTexture() {
            return ChangeEnumScreen.this.background;
        }

        protected void updateWidgetNarration(NarrationElementOutput output) {
            if (this.getSelected() != null) {
                output.add(NarratedElementType.TITLE, ((Entry)this.getSelected()).label);
            }
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            if (ChangeEnumScreen.this.config.isReadOnly()) {
                return false;
            }
            return super.isMouseOver(mouseX, mouseY);
        }
    }

    public class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements ILabelProvider {
        private final Enum<?> enumValue;
        private final Component label;

        public Entry(Enum<?> enumValue) {
            this.enumValue = enumValue;
            this.label = Component.literal((String)ConfigScreen.createLabel(enumValue.name().toLowerCase(Locale.ENGLISH)));
        }

        public Enum<?> getEnumValue() {
            return this.enumValue;
        }

        @Override
        public String getLabel() {
            return this.label.getString();
        }

        public Component getFormattedLabel() {
            return this.label;
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            MutableComponent label = Component.literal((String)this.label.getString()).withStyle(ChangeEnumScreen.this.list.getSelected() == this ? ChatFormatting.YELLOW : ChatFormatting.WHITE);
            graphics.drawString(((ChangeEnumScreen)ChangeEnumScreen.this).minecraft.font, (Component)label, left + 5, top + 4, 0xFFFFFF);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            ChangeEnumScreen.this.list.setSelected((AbstractSelectionList.Entry)this);
            ChangeEnumScreen.this.selectedValue = this.enumValue;
            return true;
        }

        public Component getNarration() {
            return this.label;
        }
    }
}

