/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.Config;
import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ActiveConfirmationScreen;
import com.mrcrayfish.configured.client.screen.ChangeEnumScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.EditListScreen;
import com.mrcrayfish.configured.client.screen.EditStringScreen;
import com.mrcrayfish.configured.client.screen.IEditing;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.widget.CheckBoxButton;
import com.mrcrayfish.configured.client.screen.widget.ConfiguredButton;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigScreen
extends ListMenuScreen
implements IEditing {
    public static final int TOOLTIP_WIDTH = 200;
    public static final Comparator<ListMenuScreen.Item> SORT_ALPHABETICALLY = (o1, o2) -> {
        if (o1 instanceof FolderItem && o2 instanceof FolderItem) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
        if (!(o1 instanceof FolderItem) && o2 instanceof FolderItem) {
            return 1;
        }
        if (o1 instanceof FolderItem) {
            return -1;
        }
        return o1.getLabel().compareTo(o2.getLabel());
    };
    protected final IConfigEntry folderEntry;
    protected final IModConfig config;
    protected final Map<String, String> cachedTextMap = new HashMap<String, String>();
    protected Button saveButton;
    protected Button restoreButton;
    protected CheckBoxButton deepSearchCheckBox;

    private ConfigScreen(Screen parent, Component title, IModConfig config, ResourceLocation background, IConfigEntry folderEntry) {
        super(parent, title, background, 24);
        this.config = config;
        this.folderEntry = folderEntry;
    }

    public ConfigScreen(Screen parent, Component title, IModConfig config, ResourceLocation background) {
        super(parent, title, background, 24);
        this.config = config;
        this.folderEntry = config.getRoot();
    }

    @Override
    public IModConfig getActiveConfig() {
        return this.config;
    }

    public void removed() {
        this.cachedTextMap.clear();
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        ArrayList<ListMenuScreen.Item> configEntries = new ArrayList<ListMenuScreen.Item>();
        this.folderEntry.getChildren().forEach(entry -> {
            ListMenuScreen.Item item = this.createItemFromEntry((IConfigEntry)entry);
            if (item != null) {
                configEntries.add(item);
            }
        });
        configEntries.sort(SORT_ALPHABETICALLY);
        entries.addAll(configEntries);
    }

    @Nullable
    private ListMenuScreen.Item createItemFromEntry(IConfigEntry entry) {
        if (entry.isLeaf()) {
            IConfigValue<Boolean> value = entry.getValue();
            if (value != null) {
                Object object = value.get();
                if (object instanceof Boolean) {
                    return new BooleanItem(value);
                }
                if (object instanceof Integer) {
                    return new IntegerItem((IConfigValue<Integer>)value);
                }
                if (object instanceof Double) {
                    return new DoubleItem((IConfigValue<Double>)value);
                }
                if (object instanceof Long) {
                    return new LongItem((IConfigValue<Long>)value);
                }
                if (object instanceof Enum) {
                    return new EnumItem((IConfigValue<Enum<?>>)value);
                }
                if (object instanceof String) {
                    return new StringItem((IConfigValue<String>)value);
                }
                if (object instanceof List) {
                    return new ListItem((IConfigValue<List<?>>)value);
                }
                Constants.LOG.info("Unsupported config value: " + value.getName());
            }
            return null;
        }
        return new FolderItem(entry);
    }

    @Override
    protected void init() {
        super.init();
        if (this.folderEntry.isRoot()) {
            this.saveButton = (Button)this.addRenderableWidget((GuiEventListener)new IconButton(this.width / 2 - 140, this.height - 29, 22, 0, 90, (Component)Component.translatable((String)"configured.gui.save"), button -> {
                this.saveConfig();
                if (ConfigHelper.getChangedValues(this.folderEntry).stream().anyMatch(IConfigValue::requiresGameRestart)) {
                    ConfirmationScreen confirm = new ConfirmationScreen(this.parent, (Component)Component.translatable((String)"configured.gui.game_restart_needed"), ConfirmationScreen.Icon.INFO, result -> true);
                    confirm.setPositiveText((Component)Component.translatable((String)"configured.gui.close"));
                    confirm.setNegativeText(null);
                    this.minecraft.setScreen((Screen)confirm);
                } else if (this.minecraft.level != null && ConfigHelper.getChangedValues(this.folderEntry).stream().anyMatch(IConfigValue::requiresWorldRestart)) {
                    ConfirmationScreen confirm = new ConfirmationScreen(this.parent, (Component)Component.translatable((String)"configured.gui.world_restart_needed"), ConfirmationScreen.Icon.INFO, result -> true);
                    confirm.setPositiveText((Component)Component.translatable((String)"configured.gui.close"));
                    confirm.setNegativeText(null);
                    this.minecraft.setScreen((Screen)confirm);
                } else {
                    this.minecraft.setScreen(this.parent);
                }
            }));
            this.restoreButton = (Button)this.addRenderableWidget((GuiEventListener)new IconButton(this.width / 2 - 45, this.height - 29, 0, 0, 90, (Component)Component.translatable((String)"configured.gui.reset_all"), button -> {
                if (this.folderEntry.isRoot()) {
                    this.showRestoreScreen();
                }
            }));
            this.addRenderableWidget((GuiEventListener)ScreenUtil.button(this.width / 2 + 50, this.height - 29, 90, 20, CommonComponents.GUI_CANCEL, button -> {
                if (this.isChanged(this.folderEntry)) {
                    this.minecraft.setScreen((Screen)new ActiveConfirmationScreen(this, this.config, (Component)Component.translatable((String)"configured.gui.unsaved_changes"), ConfirmationScreen.Icon.WARNING, result -> {
                        if (!result.booleanValue()) {
                            return true;
                        }
                        this.minecraft.setScreen(this.parent);
                        return false;
                    }).setBackground(this.background));
                } else {
                    this.minecraft.setScreen(this.parent);
                }
            }));
            this.updateButtons();
        } else {
            this.addRenderableWidget((GuiEventListener)new IconButton(this.width / 2 - 130, this.height - 29, 22, 44, 128, (Component)Component.translatable((String)"configured.gui.home"), button -> {
                ConfigScreen target = this;
                while (target.parent instanceof ConfigScreen) {
                    target = (ConfigScreen)target.parent;
                }
                this.minecraft.setScreen((Screen)target);
            }));
            this.addRenderableWidget((GuiEventListener)ScreenUtil.button(this.width / 2 + 2, this.height - 29, 128, 20, CommonComponents.GUI_BACK, button -> this.minecraft.setScreen(this.parent)));
        }
        this.deepSearchCheckBox = new CheckBoxButton(this.width / 2 + 115, 25, button -> this.updateSearchResults());
        this.addRenderableWidget((GuiEventListener)this.deepSearchCheckBox);
    }

    private void saveConfig() {
        if (!this.isChanged(this.folderEntry) || this.config == null) {
            return;
        }
        this.config.update(this.folderEntry);
    }

    private void showRestoreScreen() {
        ActiveConfirmationScreen confirmScreen = new ActiveConfirmationScreen(this, this.config, (Component)Component.translatable((String)"configured.gui.restore_message"), ConfirmationScreen.Icon.WARNING, result -> {
            if (!result.booleanValue()) {
                return true;
            }
            this.restoreDefaults(this.folderEntry);
            this.updateButtons();
            return true;
        });
        confirmScreen.setBackground(this.background);
        confirmScreen.setPositiveText((Component)Component.translatable((String)"configured.gui.reset_all").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        confirmScreen.setNegativeText(CommonComponents.GUI_CANCEL);
        Minecraft.getInstance().setScreen((Screen)confirmScreen);
    }

    private void restoreDefaults(IConfigEntry entry) {
        for (IConfigEntry child : entry.getChildren()) {
            if (child.isLeaf()) {
                IConfigValue<?> value = child.getValue();
                if (value == null) continue;
                value.restore();
                continue;
            }
            this.restoreDefaults(child);
        }
    }

    private void updateButtons() {
        if (this.folderEntry.isRoot()) {
            if (this.saveButton != null) {
                boolean bl = this.saveButton.active = !this.config.isReadOnly() && this.isChanged(this.folderEntry);
            }
            if (this.restoreButton != null) {
                this.restoreButton.active = !this.config.isReadOnly() && this.isModified(this.folderEntry);
            }
        }
    }

    @Override
    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.config.isReadOnly()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.blit(IconButton.ICONS, this.width - 30, 14, 20, 20, 0.0f, 33.0f, 10, 10, 64, 64);
            if (ScreenUtil.isMouseWithin(this.width - 30, 14, 20, 20, mouseX, mouseY)) {
                this.setActiveTooltip((Component)Component.translatable((String)"configured.gui.read_only_config"), -14785178);
            }
        }
        if (this.deepSearchCheckBox.isMouseOver(mouseX, mouseY)) {
            this.setActiveTooltip((Component)Component.translatable((String)"configured.gui.deep_search"));
        }
    }

    @Override
    protected Collection<ListMenuScreen.Item> getSearchResults(String s) {
        ArrayList<ListMenuScreen.Item> entries = this.entries;
        if (this.deepSearchCheckBox.isSelected()) {
            ArrayList<ListMenuScreen.Item> allEntries = new ArrayList<ListMenuScreen.Item>();
            ConfigHelper.gatherAllConfigEntries(this.folderEntry).forEach(entry -> {
                ListMenuScreen.Item item = this.createItemFromEntry((IConfigEntry)entry);
                if (item instanceof ConfigItem) {
                    allEntries.add(item);
                }
            });
            allEntries.sort(SORT_ALPHABETICALLY);
            entries = allEntries;
        }
        return entries.stream().filter(item -> {
            if (item instanceof ListMenuScreen.IIgnoreSearch) {
                return false;
            }
            if (item instanceof FolderItem && !Config.isIncludeFoldersInSearch()) {
                return false;
            }
            return item.getLabel().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH));
        }).collect(Collectors.toList());
    }

    private static String createLabelFromHolder(IConfigValue<?> holder) {
        if (holder.getTranslationKey() != null && I18n.exists((String)holder.getTranslationKey())) {
            return Component.translatable((String)holder.getTranslationKey()).getString();
        }
        return ConfigScreen.createLabel(holder.getName());
    }

    public static String createLabel(String input) {
        int i;
        String valueName = input;
        String[] words = valueName.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        valueName = Strings.join((String[])words, (String)" ");
        words = valueName.split("[_\\-.]");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        return Strings.join((String[])words, (String)" ").replaceAll("\\s++", " ");
    }

    private static List<FormattedText> splitTooltip(FormattedText text) {
        return Minecraft.getInstance().font.getSplitter().splitLines(text, 200, Style.EMPTY);
    }

    public boolean shouldCloseOnEsc() {
        return this.config == null || this.config.getType() != ConfigType.WORLD;
    }

    public boolean isModified(IConfigEntry entry) {
        if (entry.isLeaf()) {
            IConfigValue<?> value = entry.getValue();
            return value != null && !value.isDefault();
        }
        for (IConfigEntry child : entry.getChildren()) {
            if (!this.isModified(child)) continue;
            return true;
        }
        return false;
    }

    public boolean isChanged(IConfigEntry entry) {
        if (entry.isLeaf()) {
            IConfigValue<?> value = entry.getValue();
            return value != null && value.isChanged();
        }
        for (IConfigEntry child : entry.getChildren()) {
            if (!this.isChanged(child)) continue;
            return true;
        }
        return false;
    }

    public class BooleanItem
    extends ConfigItem<Boolean> {
        private final Button button;

        public BooleanItem(IConfigValue<Boolean> holder) {
            super(holder);
            this.button = ScreenUtil.button(10, 5, 46, 20, CommonComponents.optionStatus((boolean)holder.get()), button -> {
                holder.set((Boolean)holder.get() == false);
                button.setMessage(CommonComponents.optionStatus((boolean)((Boolean)holder.get())));
                ConfigScreen.this.updateButtons();
            });
            this.button.active = !ConfigScreen.this.config.isReadOnly();
            this.eventListeners.add(this.button);
        }

        @Override
        public void render(GuiGraphics graphics, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.render(graphics, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.setX(left + width - 69);
            this.button.setY(top);
            this.button.render(graphics, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onResetValue() {
            this.button.setMessage(CommonComponents.optionStatus((boolean)((Boolean)this.holder.get())));
        }
    }

    public class IntegerItem
    extends NumberItem<Integer> {
        public IntegerItem(IConfigValue<Integer> holder) {
            super(holder, Integer::parseInt);
        }
    }

    public class DoubleItem
    extends NumberItem<Double> {
        public DoubleItem(IConfigValue<Double> holder) {
            super(holder, Double::parseDouble);
        }
    }

    public class LongItem
    extends NumberItem<Long> {
        public LongItem(IConfigValue<Long> holder) {
            super(holder, Long::parseLong);
        }
    }

    public class EnumItem
    extends ConfigItem<Enum<?>> {
        private final Button button;

        public EnumItem(IConfigValue<Enum<?>> holder) {
            super(holder);
            MutableComponent buttonText = ConfigScreen.this.config.isReadOnly() ? Component.translatable((String)"configured.gui.view") : Component.translatable((String)"configured.gui.change");
            this.button = ScreenUtil.button(10, 5, 46, 20, (Component)buttonText, button -> Minecraft.getInstance().setScreen((Screen)new ChangeEnumScreen(ConfigScreen.this, ConfigScreen.this.config, this.label, ConfigScreen.this.background, (Enum)holder.get(), holder, e -> {
                holder.set((Enum<?>)e);
                ConfigScreen.this.updateButtons();
            })));
            this.eventListeners.add(this.button);
        }

        @Override
        public void render(GuiGraphics graphics, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.render(graphics, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.setX(left + width - 69);
            this.button.setY(top);
            this.button.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public class StringItem
    extends ConfigItem<String> {
        private final Button button;

        public StringItem(IConfigValue<String> holder) {
            super(holder);
            MutableComponent buttonText = ConfigScreen.this.config.isReadOnly() ? Component.translatable((String)"configured.gui.view") : Component.translatable((String)"configured.gui.edit");
            this.button = ScreenUtil.button(10, 5, 46, 20, (Component)buttonText, button -> Minecraft.getInstance().setScreen((Screen)new EditStringScreen(ConfigScreen.this, ConfigScreen.this.config, ConfigScreen.this.background, this.label, (String)holder.get(), s -> holder.isValid((String)s) ? Pair.of((Object)true, (Object)CommonComponents.EMPTY) : Pair.of((Object)false, (Object)holder.getValidationHint()), s -> {
                holder.set((String)s);
                ConfigScreen.this.updateButtons();
            })));
            this.eventListeners.add(this.button);
        }

        @Override
        public void render(GuiGraphics graphics, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.render(graphics, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.setX(left + width - 69);
            this.button.setY(top);
            this.button.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public class ListItem
    extends ConfigItem<List<?>> {
        private final Button button;

        public ListItem(IConfigValue<List<?>> holder) {
            super(holder);
            MutableComponent buttonText = ConfigScreen.this.config.isReadOnly() ? Component.translatable((String)"configured.gui.view") : Component.translatable((String)"configured.gui.edit");
            this.button = ScreenUtil.button(10, 5, 46, 20, (Component)buttonText, button -> Minecraft.getInstance().setScreen(new EditListScreen(ConfigScreen.this, ConfigScreen.this.config, this.label, holder, ConfigScreen.this.background)));
            this.eventListeners.add(this.button);
        }

        @Override
        public void render(GuiGraphics graphics, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.render(graphics, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.setX(left + width - 69);
            this.button.setY(top);
            this.button.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public class FolderItem
    extends ListMenuScreen.Item {
        private final IconButton button;

        public FolderItem(IConfigEntry entry) {
            super((ListMenuScreen)ConfigScreen.this, FolderItem.createLabelForFolderEntry(entry));
            this.button = new IconButton(10, 5, 11, 33, 0, (Component)Component.literal((String)this.getLabel()).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.WHITE), onPress -> {
                MutableComponent newTitle = ConfigScreen.this.title.copy().append((Component)Component.literal((String)" > ").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).append(this.getLabel());
                ConfigScreen.this.minecraft.setScreen((Screen)new ConfigScreen(ConfigScreen.this, (Component)newTitle, ConfigScreen.this.config, ConfigScreen.this.background, entry));
            });
            if (entry.getTooltip() != null) {
                this.tooltip = Language.getInstance().getVisualOrder(ConfigScreen.splitTooltip((FormattedText)entry.getTooltip()));
            }
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)((Object)this.button));
        }

        @Override
        public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.render(graphics, index, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            this.button.setX(left - 1);
            this.button.setY(top);
            this.button.setWidth(width);
            this.button.render(graphics, mouseX, mouseY, partialTicks);
        }

        private static Component createLabelForFolderEntry(IConfigEntry entry) {
            String key = entry.getTranslationKey();
            if (key != null && I18n.exists((String)key)) {
                return Component.translatable((String)key);
            }
            return Component.literal((String)ConfigScreen.createLabel(entry.getEntryName()));
        }
    }

    public abstract class ConfigItem<T>
    extends ListMenuScreen.Item {
        protected final IConfigValue<T> holder;
        protected final List<GuiEventListener> eventListeners;
        protected final ConfiguredButton resetButton;
        protected Component validationHint;

        public ConfigItem(IConfigValue<T> holder) {
            super((ListMenuScreen)ConfigScreen.this, ConfigScreen.createLabelFromHolder(holder));
            this.eventListeners = new ArrayList<GuiEventListener>();
            this.holder = holder;
            this.tooltip = this.createToolTip(holder);
            int maxTooltipWidth = Math.max(ConfigScreen.this.width / 2 - 43, 170);
            this.resetButton = new IconButton(0, 0, 0, 0, onPress -> {
                this.holder.restore();
                this.onResetValue();
                ConfigScreen.this.updateButtons();
            });
            this.resetButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"configured.gui.reset")), btn -> btn.isActive() && btn.isHoveredOrFocused());
            this.resetButton.active = !ConfigScreen.this.config.isReadOnly();
            this.eventListeners.add((GuiEventListener)this.resetButton);
        }

        protected void onResetValue() {
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return this.eventListeners;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            boolean showValidationHint = this.validationHint != null;
            int trimLength = showValidationHint ? 100 : 80;
            ChatFormatting labelStyle = this.holder.isChanged() ? Config.getChangedFormatting() : ChatFormatting.RESET;
            graphics.drawString(Minecraft.getInstance().font, (Component)this.getTrimmedLabel(width - trimLength).withStyle(labelStyle), left, top + 6, 0xFFFFFF);
            if (showValidationHint) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                graphics.blit(IconButton.ICONS, left + width - 88, top + 3, 16, 16, 11.0f, 11.0f, 11, 11, 64, 64);
            }
            if (!ConfigScreen.this.config.isReadOnly() && (this.holder.requiresGameRestart() || this.holder.requiresWorldRestart())) {
                boolean gameRestart = this.holder.requiresGameRestart();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                graphics.blit(IconButton.ICONS, left - 18, top + 5, 11, 11, gameRestart ? 51.0f : 11.0f, 22.0f, 11, 11, 64, 64);
                if (ScreenUtil.isMouseWithin(left - 18, top + 5, 11, 11, mouseX, mouseY)) {
                    String translationKey = gameRestart ? "configured.gui.requires_game_restart" : "configured.gui.requires_world_restart";
                    int outline = gameRestart ? -1438090048 : -1437158830;
                    ConfigScreen.this.setActiveTooltip((Component)Component.translatable((String)translationKey), outline);
                }
            }
            if (this.isMouseOver(mouseX, mouseY)) {
                if (showValidationHint && ScreenUtil.isMouseWithin(left + width - 92, top, 23, 20, mouseX, mouseY)) {
                    ConfigScreen.this.setActiveTooltip(this.validationHint, -1428357120);
                } else if (mouseX < ConfigScreen.this.list.getRowLeft() + ConfigScreen.this.list.getRowWidth() - 69) {
                    ConfigScreen.this.setActiveTooltip(this.tooltip);
                }
            }
            this.resetButton.active = !this.holder.isDefault() && !ConfigScreen.this.config.isReadOnly();
            this.resetButton.setX(left + width - 21);
            this.resetButton.setY(top);
            this.resetButton.render(graphics, mouseX, mouseY, partialTicks);
        }

        private MutableComponent getTrimmedLabel(int maxWidth) {
            if (((ConfigScreen)ConfigScreen.this).minecraft.font.width((FormattedText)this.label) > maxWidth) {
                return Component.literal((String)(((ConfigScreen)ConfigScreen.this).minecraft.font.substrByWidth((FormattedText)this.label, maxWidth).getString() + "..."));
            }
            return this.label.copy();
        }

        @Nullable
        private List<FormattedCharSequence> createToolTip(IConfigValue<T> holder) {
            Component comment = holder.getComment();
            if (comment != null) {
                int i;
                Font font = Minecraft.getInstance().font;
                List lines = font.getSplitter().splitLines((FormattedText)comment, 200, Style.EMPTY);
                String name = holder.getName();
                lines.add(0, Component.literal((String)name).withStyle(ChatFormatting.YELLOW));
                int rangeIndex = -1;
                for (i = 0; i < lines.size(); ++i) {
                    String text = ((FormattedText)lines.get(i)).getString();
                    if (!text.startsWith("Range: ") && !text.startsWith("Allowed Values: ")) continue;
                    rangeIndex = i;
                    break;
                }
                if (rangeIndex != -1) {
                    for (i = rangeIndex; i < lines.size(); ++i) {
                        lines.set(i, Component.literal((String)((FormattedText)lines.get(i)).getString()).withStyle(ChatFormatting.GRAY));
                    }
                }
                return Language.getInstance().getVisualOrder(lines);
            }
            return null;
        }

        public void setValidationHint(Component text) {
            this.validationHint = text;
        }
    }

    public abstract class NumberItem<T extends Number>
    extends ConfigItem<T> {
        private final ListMenuScreen.FocusedEditBox textField;
        private long lastTick;

        public NumberItem(IConfigValue<T> holder, Function<String, Number> parser) {
            super(holder);
            String text = ConfigScreen.this.cachedTextMap.getOrDefault(holder.getName(), ((Number)holder.get()).toString());
            this.textField = new ListMenuScreen.FocusedEditBox(ConfigScreen.this, ConfigScreen.this.font, 0, 0, 44, 18, this.label);
            this.textField.setResponder(s -> {
                ConfigScreen.this.cachedTextMap.put(holder.getName(), (String)s);
                try {
                    Number n = (Number)parser.apply((String)s);
                    if (holder.isValid(n)) {
                        this.textField.setTextColor(0xE0E0E0);
                        holder.set(n);
                        ConfigScreen.this.updateButtons();
                        this.setValidationHint(null);
                    } else {
                        this.textField.setTextColor(0xFF0000);
                        this.setValidationHint(holder.getValidationHint());
                    }
                }
                catch (Exception ignored) {
                    this.textField.setTextColor(0xFF0000);
                    this.setValidationHint((Component)Component.translatable((String)"configured.validator.not_a_number"));
                }
            });
            this.textField.setValue(text);
            this.textField.setEditable(!ConfigScreen.this.config.isReadOnly());
            this.eventListeners.add(this.textField);
        }

        @Override
        public void render(GuiGraphics graphics, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.render(graphics, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            long time = Util.getMillis();
            if (time - this.lastTick >= 50L) {
                this.lastTick = time;
            }
            this.textField.setX(left + width - 68);
            this.textField.setY(top + 1);
            this.textField.render(graphics, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onResetValue() {
            this.textField.setValue(((Number)this.holder.get()).toString());
        }
    }
}

