/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ConfirmationScreen
extends Screen
implements IBackgroundTexture {
    private static final int FADE_LENGTH = 4;
    private static final int BRIGHTNESS = 32;
    private static final int MESSAGE_PADDING = 10;
    private final Screen parent;
    private final Component message;
    private final Icon icon;
    private final Function<Boolean, Boolean> handler;
    private Component positiveText = CommonComponents.GUI_YES;
    private Component negativeText = CommonComponents.GUI_NO;
    private ResourceLocation background = Screen.BACKGROUND_LOCATION;
    private int startY;
    private int endY;

    public ConfirmationScreen(Screen parent, Component message, Icon icon, Function<Boolean, Boolean> handler) {
        super(message);
        this.parent = parent;
        this.message = message;
        this.icon = icon;
        this.handler = handler;
    }

    protected void init() {
        List lines = this.font.split((FormattedText)this.message, 300);
        int n = this.height / 2 - 10;
        int n2 = lines.size();
        Objects.requireNonNull(this.font);
        this.startY = n - n2 * (9 + 2) / 2 - 10 - 1;
        int n3 = lines.size();
        Objects.requireNonNull(this.font);
        this.endY = this.startY + n3 * (9 + 2) + 20;
        int offset = this.negativeText != null ? 105 : 50;
        this.addRenderableWidget((GuiEventListener)ScreenUtil.button(this.width / 2 - offset, this.endY + 10, 100, 20, this.positiveText, button -> {
            if (this.handler.apply(true).booleanValue()) {
                this.minecraft.setScreen(this.parent);
            }
        }));
        if (this.negativeText != null) {
            this.addRenderableWidget((GuiEventListener)ScreenUtil.button(this.width / 2 + 5, this.endY + 10, 100, 20, this.negativeText, button -> {
                if (this.handler.apply(false).booleanValue()) {
                    this.minecraft.setScreen(this.parent);
                }
            }));
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        List lines = this.font.split((FormattedText)this.message, 300);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(IconButton.ICONS, this.width / 2 - 10, this.startY - 30, 20, 20, (float)this.icon.u(), (float)this.icon.v(), 10, 10, 64, 64);
        ConfirmationScreen.drawListBackground(0.0, this.width, this.startY, this.endY);
        for (int i = 0; i < lines.size(); ++i) {
            int lineWidth = this.font.width((FormattedCharSequence)lines.get(i));
            FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines.get(i);
            int n = this.width / 2 - lineWidth / 2;
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, formattedCharSequence, n, this.startY + 10 + i * (9 + 2) + 1, 0xFFFFFF);
        }
    }

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.background;
    }

    public void setPositiveText(Component positiveText) {
        this.positiveText = positiveText;
    }

    public void setNegativeText(@Nullable Component negativeText) {
        this.negativeText = negativeText;
    }

    public ConfirmationScreen setBackground(ResourceLocation background) {
        this.background = background;
        return this;
    }

    public static void drawListBackground(double startX, double endX, double startY, double endY) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.getBuilder();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Screen.BACKGROUND_LOCATION);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        buffer.vertex(startX, endY, 0.0).uv((float)startX / 32.0f, (float)endY / 32.0f).color(32, 32, 32, 255).endVertex();
        buffer.vertex(endX, endY, 0.0).uv((float)endX / 32.0f, (float)endY / 32.0f).color(32, 32, 32, 255).endVertex();
        buffer.vertex(endX, startY, 0.0).uv((float)endX / 32.0f, (float)startY / 32.0f).color(32, 32, 32, 255).endVertex();
        buffer.vertex(startX, startY, 0.0).uv((float)startX / 32.0f, (float)startY / 32.0f).color(32, 32, 32, 255).endVertex();
        tesselator.end();
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buffer.vertex(startX, startY + 4.0, 0.0).color(0, 0, 0, 0).endVertex();
        buffer.vertex(endX, startY + 4.0, 0.0).color(0, 0, 0, 0).endVertex();
        buffer.vertex(endX, startY, 0.0).color(0, 0, 0, 255).endVertex();
        buffer.vertex(startX, startY, 0.0).color(0, 0, 0, 255).endVertex();
        buffer.vertex(startX, endY, 0.0).color(0, 0, 0, 255).endVertex();
        buffer.vertex(endX, endY, 0.0).color(0, 0, 0, 255).endVertex();
        buffer.vertex(endX, endY - 4.0, 0.0).color(0, 0, 0, 0).endVertex();
        buffer.vertex(startX, endY - 4.0, 0.0).color(0, 0, 0, 0).endVertex();
        tesselator.end();
    }

    public static enum Icon {
        INFO(11, 44),
        WARNING(0, 11),
        ERROR(11, 11);

        private final int u;
        private final int v;

        private Icon(int u, int v) {
            this.u = u;
            this.v = v;
        }

        public int u() {
            return this.u;
        }

        public int v() {
            return this.v;
        }
    }
}

