/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.network;

import com.mrcrayfish.configured.impl.framework.message.MessageFramework;
import com.mrcrayfish.configured.network.message.MessageSessionData;
import com.mrcrayfish.configured.network.payload.SessionDataPayload;
import com.mrcrayfish.configured.network.payload.SyncNeoForgeConfigPayload;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.IPacketHandler;
import net.neoforged.neoforge.network.handling.ISynchronizedWorkHandler;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

@Mod.EventBusSubscriber(modid="configured", bus=Mod.EventBusSubscriber.Bus.MOD)
public class NeoForgeNetwork {
    public static final ResourceLocation ID = new ResourceLocation("configured", "play");
    public static final int VERSION = 1;

    @SubscribeEvent
    private static void onRegisterPayloadHandler(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("configured").optional().versioned(Integer.toString(1));
        registrar.play(MessageSessionData.ID, SessionDataPayload::new, builder -> builder.client(SessionDataPayload::handle));
        registrar.play(SyncNeoForgeConfigPayload.ID, SyncNeoForgeConfigPayload::new, builder -> builder.client(SyncNeoForgeConfigPayload::handle));
        if (ModList.get().isLoaded("framework")) {
            NeoForgeNetwork.registerPlayPayload(registrar, MessageFramework.Sync.ID, MessageFramework.Sync::encode, MessageFramework.Sync::decode, MessageFramework.Sync::handle, PacketFlow.SERVERBOUND);
            NeoForgeNetwork.registerPlayPayload(registrar, MessageFramework.Request.ID, MessageFramework.Request::encode, MessageFramework.Request::decode, MessageFramework.Request::handle, PacketFlow.SERVERBOUND);
            NeoForgeNetwork.registerPlayPayload(registrar, MessageFramework.Response.ID, MessageFramework.Response::encode, MessageFramework.Response::decode, MessageFramework.Response::handle, PacketFlow.CLIENTBOUND);
        }
    }

    private static <T> void registerPlayPayload(IPayloadRegistrar registrar, ResourceLocation id, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, PayloadHandler<T> handler, @Nullable PacketFlow flow) {
        PayloadEncoder payloadEncoder = new PayloadEncoder(id, encoder);
        registrar.play(payloadEncoder.id, buf -> new PayloadWrapper(decoder.apply((FriendlyByteBuf)buf), payloadEncoder), builder -> {
            if (flow == null || flow.isClientbound()) {
                builder.client((payload, context) -> handler.accept(payload.instance, arg_0 -> ((ISynchronizedWorkHandler)context.workHandler()).execute(arg_0), context.player().orElse(null), arg_0 -> ((IPacketHandler)context.packetHandler()).disconnect(arg_0)));
            }
            if (flow == null || flow.isServerbound()) {
                builder.server((payload, context) -> handler.accept(payload.instance, arg_0 -> ((ISynchronizedWorkHandler)context.workHandler()).execute(arg_0), context.player().orElse(null), arg_0 -> ((IPacketHandler)context.packetHandler()).disconnect(arg_0)));
            }
        });
    }

    @FunctionalInterface
    private static interface PayloadHandler<T> {
        public void accept(T var1, Consumer<Runnable> var2, @Nullable Player var3, Consumer<Component> var4);
    }

    private record PayloadEncoder<T>(ResourceLocation id, BiConsumer<T, FriendlyByteBuf> encoder) {
    }

    private record PayloadWrapper<T>(T instance, PayloadEncoder<T> handler) implements CustomPacketPayload
    {
        public void write(FriendlyByteBuf buf) {
            this.handler.encoder.accept(this.instance, buf);
        }

        public ResourceLocation id() {
            return this.handler.id;
        }
    }
}

