/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.network.payload;

import com.mrcrayfish.configured.impl.framework.message.MessageFramework;
import com.mrcrayfish.configured.network.ConfiguredPayload;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPacketHandler;
import net.neoforged.neoforge.network.handling.ISynchronizedWorkHandler;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public final class FrameworkPayload {

    public static class Response
    implements ConfiguredPayload {
        private final byte[] data;

        private Response(byte[] data) {
            this.data = data;
        }

        public Response(FriendlyByteBuf buf) {
            this(buf.readByteArray());
        }

        public void write(FriendlyByteBuf buf) {
            MessageFramework.Response.encode(new MessageFramework.Response(this.data), buf);
        }

        public ResourceLocation id() {
            return MessageFramework.Response.ID;
        }

        public static void handle(Response payload, PlayPayloadContext context) {
            MessageFramework.Response.handle(new MessageFramework.Response(payload.data), arg_0 -> ((ISynchronizedWorkHandler)context.workHandler()).submitAsync(arg_0), context.player().orElse(null), arg_0 -> ((IPacketHandler)context.packetHandler()).disconnect(arg_0));
        }

        public static Response of(byte[] data) {
            return new Response(data);
        }
    }

    public static class Request
    implements ConfiguredPayload {
        private final ResourceLocation id;

        private Request(ResourceLocation id) {
            this.id = id;
        }

        public Request(FriendlyByteBuf buf) {
            this(buf.readResourceLocation());
        }

        public void write(FriendlyByteBuf buf) {
            MessageFramework.Request.encode(new MessageFramework.Request(this.id), buf);
        }

        public ResourceLocation id() {
            return MessageFramework.Request.ID;
        }

        public static void handle(Request payload, PlayPayloadContext context) {
            MessageFramework.Request.handle(new MessageFramework.Request(payload.id), arg_0 -> ((ISynchronizedWorkHandler)context.workHandler()).submitAsync(arg_0), context.player().orElse(null), arg_0 -> ((IPacketHandler)context.packetHandler()).disconnect(arg_0));
        }

        public static Request of(ResourceLocation id) {
            return new Request(id);
        }
    }

    public static class Sync
    implements ConfiguredPayload {
        private final ResourceLocation id;
        private final byte[] data;

        private Sync(ResourceLocation id, byte[] data) {
            this.id = id;
            this.data = data;
        }

        public Sync(FriendlyByteBuf buf) {
            this(buf.readResourceLocation(), buf.readByteArray());
        }

        public void write(FriendlyByteBuf buf) {
            MessageFramework.Sync.encode(new MessageFramework.Sync(this.id, this.data), buf);
        }

        public ResourceLocation id() {
            return MessageFramework.Sync.ID;
        }

        public static void handle(Sync payload, PlayPayloadContext context) {
            MessageFramework.Sync.handle(new MessageFramework.Sync(payload.id, payload.data), arg_0 -> ((ISynchronizedWorkHandler)context.workHandler()).submitAsync(arg_0), context.player().orElse(null), arg_0 -> ((IPacketHandler)context.packetHandler()).disconnect(arg_0));
        }

        public static Sync of(ResourceLocation id, byte[] data) {
            return new Sync(id, data);
        }
    }
}

