/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.network.payload;

import com.mrcrayfish.configured.network.ConfiguredPayload;
import com.mrcrayfish.configured.network.handler.NeoForgeClientPlayHandler;
import com.mrcrayfish.configured.network.handler.NeoForgeServerPlayHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPacketHandler;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public final class SyncNeoForgeConfigPayload
implements ConfiguredPayload {
    public static final ResourceLocation ID = new ResourceLocation("configured", "sync_neoforge_config");
    private final String fileName;
    private final byte[] data;

    private SyncNeoForgeConfigPayload(String fileName, byte[] data) {
        this.fileName = fileName;
        this.data = data;
    }

    public SyncNeoForgeConfigPayload(FriendlyByteBuf buf) {
        this(buf.readUtf(), buf.readByteArray());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.fileName);
        buf.writeByteArray(this.data);
    }

    public ResourceLocation id() {
        return ID;
    }

    public String fileName() {
        return this.fileName;
    }

    public byte[] data() {
        return this.data;
    }

    public static void handle(SyncNeoForgeConfigPayload payload, PlayPayloadContext context) {
        Player player = context.player().orElse(null);
        if (context.flow() == PacketFlow.SERVERBOUND) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                context.workHandler().submitAsync(() -> NeoForgeServerPlayHandler.handleSyncServerConfigMessage(serverPlayer, payload));
            }
        } else {
            context.workHandler().submitAsync(() -> NeoForgeClientPlayHandler.handleSyncServerConfigMessage(arg_0 -> ((IPacketHandler)context.packetHandler()).disconnect(arg_0), payload));
        }
    }

    public static SyncNeoForgeConfigPayload of(String fileName, byte[] data) {
        return new SyncNeoForgeConfigPayload(fileName, data);
    }
}

