/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.Environment;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.SessionData;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.RequestScreen;
import com.mrcrayfish.configured.client.screen.WorldSelectionScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.platform.Services;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.io.FilenameUtils;

public class ModConfigSelectionScreen
extends ListMenuScreen {
    private final Map<ConfigType, Set<IModConfig>> configMap;

    public ModConfigSelectionScreen(Screen parent, Component title, Map<ConfigType, Set<IModConfig>> configMap) {
        super(parent, title, 30);
        this.configMap = configMap;
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        Set<IModConfig> remoteConfigs;
        Set<IModConfig> localConfigs = this.getLocalConfigs();
        if (!localConfigs.isEmpty()) {
            entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(Component.translatable((String)"configured.gui.title.client_configuration").getString()));
            ArrayList localEntries = new ArrayList();
            localConfigs.forEach(config -> localEntries.add(new FileItem((IModConfig)config)));
            Collections.sort(localEntries);
            entries.addAll(localEntries);
        }
        if (!((remoteConfigs = this.getRemoteConfigs()).isEmpty() || ConfigHelper.isPlayingGame() && !ConfigHelper.isConfiguredInstalledOnServer())) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (ConfigHelper.isPlayingGame() && ModConfigSelectionScreen.isPlayingRemotely()) {
                if (SessionData.isLan()) {
                    entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(Component.translatable((String)"configured.gui.title.server_configuration").getString()));
                    entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((Component)Component.translatable((String)"configured.gui.lan_server")));
                    return;
                }
                if (!ConfigHelper.isOperator((Player)player)) {
                    return;
                }
                if (!SessionData.isDeveloper((Player)player)) {
                    entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(Component.translatable((String)"configured.gui.title.server_configuration").getString()));
                    entries.add(new ListMenuScreen.MultiTextItem((Component)Component.translatable((String)"configured.gui.no_developer_status"), (Component)Component.translatable((String)"configured.gui.developer_details", (Object[])new Object[]{Component.literal((String)"configured.developer.toml").withStyle(ChatFormatting.GOLD).withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)))}).withStyle(ChatFormatting.GRAY).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"configured.gui.developer_file"))))));
                    return;
                }
            }
            entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(Component.translatable((String)"configured.gui.title.server_configuration").getString()));
            ArrayList remoteEntries = new ArrayList();
            remoteConfigs.forEach(config -> remoteEntries.add(new FileItem((IModConfig)config)));
            Collections.sort(remoteEntries);
            entries.addAll(remoteEntries);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)ScreenUtil.button(this.width / 2 - 75, this.height - 29, 150, 20, CommonComponents.GUI_BACK, button -> this.minecraft.setScreen(this.parent)));
    }

    private Set<IModConfig> getLocalConfigs() {
        return this.configMap.entrySet().stream().filter(entry -> !((ConfigType)((Object)((Object)entry.getKey()))).isServer()).flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    private Set<IModConfig> getRemoteConfigs() {
        return this.configMap.entrySet().stream().filter(entry -> {
            ConfigType type = (ConfigType)((Object)((Object)entry.getKey()));
            return type.isServer() && type.getEnv().orElse(null) != Environment.DEDICATED_SERVER;
        }).flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    public static String createLabelFromModConfig(IModConfig config) {
        if (config.getTranslationKey() != null) {
            return I18n.get((String)config.getTranslationKey(), (Object[])new Object[0]);
        }
        String fileName = config.getFileName();
        if ((fileName = fileName.replace(config.getModId() + "-", "")).endsWith(".toml")) {
            fileName = fileName.substring(0, fileName.length() - ".toml".length());
        }
        fileName = FilenameUtils.getName((String)fileName);
        fileName = ConfigScreen.createLabel(fileName);
        return fileName;
    }

    public static boolean canEditConfig(@Nullable Player player, IModConfig config) {
        return switch (config.getType()) {
            default -> throw new MatchException(null, null);
            case ConfigType.CLIENT -> {
                if (Services.PLATFORM.getEnvironment() == Environment.CLIENT) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.UNIVERSAL, ConfigType.MEMORY -> true;
            case ConfigType.SERVER, ConfigType.WORLD, ConfigType.SERVER_SYNC, ConfigType.WORLD_SYNC -> {
                if (!ConfigHelper.isPlayingGame() || ModConfigSelectionScreen.isRunningLocalServer() || ConfigHelper.isOperator(player) && SessionData.isDeveloper(player)) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.DEDICATED_SERVER -> false;
        };
    }

    public static boolean canRestoreConfig(Player player, IModConfig config) {
        return switch (config.getType()) {
            default -> throw new MatchException(null, null);
            case ConfigType.CLIENT, ConfigType.UNIVERSAL, ConfigType.MEMORY -> true;
            case ConfigType.SERVER, ConfigType.SERVER_SYNC -> {
                if (!ConfigHelper.isPlayingGame() || ModConfigSelectionScreen.isRunningLocalServer()) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.WORLD, ConfigType.WORLD_SYNC -> ModConfigSelectionScreen.isRunningLocalServer();
            case ConfigType.DEDICATED_SERVER -> false;
        };
    }

    public static boolean isRunningLocalServer() {
        return Minecraft.getInstance().hasSingleplayerServer();
    }

    public static boolean isPlayingRemotely() {
        ClientPacketListener listener = Minecraft.getInstance().getConnection();
        return listener != null && !listener.getConnection().isMemoryConnection();
    }

    public class FileItem
    extends ListMenuScreen.Item {
        protected final IModConfig config;
        protected final Component title;
        protected final Component fileName;
        protected final Button modifyButton;
        @Nullable
        protected final Button restoreButton;

        public FileItem(IModConfig config) {
            super(ModConfigSelectionScreen.createLabelFromModConfig(config));
            this.config = config;
            this.title = this.createTrimmedFileName(ModConfigSelectionScreen.createLabelFromModConfig(config));
            this.fileName = this.createTrimmedFileName(config.getFileName()).withStyle(ChatFormatting.DARK_GRAY);
            this.modifyButton = this.createModifyButton(config);
            this.modifyButton.active = ModConfigSelectionScreen.canEditConfig((Player)Minecraft.getInstance().player, config);
            this.restoreButton = this.createRestoreButton(config);
            this.updateRestoreDefaultButton();
        }

        private void showRestoreScreen() {
            ConfirmationScreen confirmScreen = new ConfirmationScreen(ModConfigSelectionScreen.this, (Component)Component.translatable((String)"configured.gui.restore_message"), ConfirmationScreen.Icon.WARNING, result -> {
                if (!result.booleanValue()) {
                    return true;
                }
                this.config.restoreDefaults();
                this.updateRestoreDefaultButton();
                return true;
            });
            confirmScreen.setPositiveText((Component)Component.translatable((String)"configured.gui.restore").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            confirmScreen.setNegativeText(CommonComponents.GUI_CANCEL);
            Minecraft.getInstance().setScreen((Screen)confirmScreen);
        }

        private MutableComponent createTrimmedFileName(String fileName) {
            MutableComponent trimmedFileName = Component.literal((String)fileName);
            if (Minecraft.getInstance().font.width(fileName) > 150) {
                trimmedFileName = Component.literal((String)(Minecraft.getInstance().font.plainSubstrByWidth(fileName, 140) + "..."));
            }
            return trimmedFileName;
        }

        private Button createModifyButton(IModConfig config) {
            int width = ModConfigSelectionScreen.canRestoreConfig((Player)Minecraft.getInstance().player, config) ? 60 : 82;
            return new IconButton(0, 0, this.getModifyIconU(config), this.getModifyIconV(config), width, this.getModifyLabel(config), button -> {
                if (!button.isActive() || !button.visible) {
                    return;
                }
                if (!ConfigHelper.isPlayingGame()) {
                    if (ConfigHelper.isWorldConfig(config)) {
                        Minecraft.getInstance().setScreen((Screen)new WorldSelectionScreen((Screen)ModConfigSelectionScreen.this, config, this.title));
                    } else if (config.getType() != ConfigType.DEDICATED_SERVER) {
                        MutableComponent newTitle = ModConfigSelectionScreen.this.title.copy().append((Component)Component.literal((String)" > ").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).append(this.title);
                        Minecraft.getInstance().setScreen((Screen)new ConfigScreen((Screen)ModConfigSelectionScreen.this, (Component)newTitle, config));
                    }
                    return;
                }
                if (ModConfigSelectionScreen.isPlayingRemotely() && config.getType().isServer() && !config.getType().isSync()) {
                    if (Services.PLATFORM.isModLoaded(config.getModId())) {
                        MutableComponent newTitle = ModConfigSelectionScreen.this.title.copy().append((Component)Component.literal((String)" > ").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).append(this.title);
                        Minecraft.getInstance().setScreen((Screen)new RequestScreen((Screen)ModConfigSelectionScreen.this, (Component)newTitle, config));
                    }
                    return;
                }
                if (Services.PLATFORM.isModLoaded(config.getModId())) {
                    MutableComponent newTitle = ModConfigSelectionScreen.this.title.copy().append((Component)Component.literal((String)" > ").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).append(this.title);
                    Minecraft.getInstance().setScreen((Screen)new ConfigScreen((Screen)ModConfigSelectionScreen.this, (Component)newTitle, config));
                }
            });
        }

        private int getModifyIconU(IModConfig config) {
            if (!ConfigHelper.isPlayingGame() && ConfigHelper.isWorldConfig(config)) {
                return 11;
            }
            return 0;
        }

        private int getModifyIconV(IModConfig config) {
            if (ConfigHelper.isPlayingGame() ? config.isReadOnly() : config.isReadOnly() && !ConfigHelper.isWorldConfig(config)) {
                return 33;
            }
            return 22;
        }

        private Component getModifyLabel(IModConfig config) {
            if (!ConfigHelper.isPlayingGame() && ConfigHelper.isWorldConfig(config)) {
                return Component.translatable((String)"configured.gui.select_world");
            }
            if (config.isReadOnly()) {
                return Component.translatable((String)"configured.gui.view");
            }
            return Component.translatable((String)"configured.gui.modify");
        }

        private Button createRestoreButton(IModConfig config) {
            if (ModConfigSelectionScreen.canRestoreConfig((Player)Minecraft.getInstance().player, config)) {
                IconButton restoreButton = new IconButton(0, 0, 0, 0, onPress -> this.showRestoreScreen());
                restoreButton.active = !config.isReadOnly() && ConfigHelper.hasPermissionToEdit((Player)Minecraft.getInstance().player, config);
                return restoreButton;
            }
            return null;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            graphics.drawString(Minecraft.getInstance().font, this.title, left + 28, top + 2, 0xFFFFFF);
            graphics.drawString(Minecraft.getInstance().font, this.fileName, left + 28, top + 12, 0xFFFFFF);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.blit(IconButton.ICONS, left + 4, top, 18, 22, (float)this.getIconU(), (float)this.getIconV(), 9, 11, 64, 64);
            if (this.config.isReadOnly()) {
                graphics.blit(IconButton.ICONS, left + 1, top + 15, 11, 11, 0.0f, 33.0f, 11, 11, 64, 64);
            }
            this.modifyButton.setX(left + width - 83);
            this.modifyButton.setY(top);
            this.modifyButton.render(graphics, mouseX, mouseY, partialTicks);
            if (this.restoreButton != null) {
                this.restoreButton.setX(left + width - 21);
                this.restoreButton.setY(top);
                this.restoreButton.render(graphics, mouseX, mouseY, partialTicks);
            }
            if (this.config.isReadOnly() && ScreenUtil.isMouseWithin(left - 1, top + 15, 11, 11, mouseX, mouseY)) {
                ModConfigSelectionScreen.this.setActiveTooltip((Component)Component.translatable((String)"configured.gui.read_only_config"), -14785178);
            }
        }

        private int getIconU() {
            return this.config.getType().ordinal() % 3 * 9 + 33;
        }

        private int getIconV() {
            return this.config.getType().ordinal() / 3 * 11;
        }

        @Override
        public List<? extends GuiEventListener> children() {
            if (this.restoreButton != null) {
                return ImmutableList.of((Object)this.modifyButton, (Object)this.restoreButton);
            }
            return ImmutableList.of((Object)this.modifyButton);
        }

        private void updateRestoreDefaultButton() {
            if (this.config != null && this.restoreButton != null && ModConfigSelectionScreen.canRestoreConfig((Player)Minecraft.getInstance().player, this.config)) {
                this.restoreButton.active = !this.config.isReadOnly() && this.config.isChanged();
            }
        }
    }
}

