/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.neoforge;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.SessionData;
import com.mrcrayfish.configured.impl.neoforge.NeoForgeFolderEntry;
import com.mrcrayfish.configured.impl.neoforge.NeoForgeListValue;
import com.mrcrayfish.configured.impl.neoforge.NeoForgeValue;
import com.mrcrayfish.configured.network.payload.SyncNeoForgeConfigPayload;
import com.mrcrayfish.configured.util.ConfigHelper;
import com.mrcrayfish.configured.util.NeoForgeConfigHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.config.ConfigFileTypeHandler;
import net.neoforged.fml.config.IConfigEvent;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.network.PacketDistributor;

public class NeoForgeConfig
implements IModConfig {
    protected static final EnumMap<ModConfig.Type, ConfigType> TYPE_RESOLVER = (EnumMap)Util.make(new EnumMap(ModConfig.Type.class), map -> {
        map.put(ModConfig.Type.CLIENT, ConfigType.CLIENT);
        map.put(ModConfig.Type.COMMON, ConfigType.UNIVERSAL);
        map.put(ModConfig.Type.SERVER, ConfigType.WORLD_SYNC);
    });
    protected final ModConfig config;
    protected final List<ForgeValueEntry> allConfigValues;

    public NeoForgeConfig(ModConfig config) {
        this.config = config;
        this.allConfigValues = this.getAllConfigValues(config);
    }

    protected NeoForgeConfig(ModConfig config, List<ForgeValueEntry> allConfigValues) {
        this.config = config;
        this.allConfigValues = allConfigValues;
    }

    @Override
    public void update(IConfigEntry entry) {
        Set<IConfigValue<?>> changedValues = ConfigHelper.getChangedValues(entry);
        if (!changedValues.isEmpty()) {
            CommentedConfig newConfig = CommentedConfig.copy((UnmodifiableCommentedConfig)this.config.getConfigData());
            changedValues.forEach(value -> {
                if (value instanceof NeoForgeValue) {
                    NeoForgeListValue forgeList;
                    List converted;
                    NeoForgeValue forge = (NeoForgeValue)value;
                    if (forge instanceof NeoForgeListValue && (converted = (forgeList = (NeoForgeListValue)forge).getConverted()) != null) {
                        newConfig.set(forge.configValue.getPath(), converted);
                        return;
                    }
                    newConfig.set(forge.configValue.getPath(), value.get());
                }
            });
            this.config.getConfigData().putAll((UnmodifiableConfig)newConfig);
        }
        if (this.getType() == ConfigType.WORLD_SYNC) {
            if (!ConfigHelper.isPlayingGame()) {
                NeoForgeConfigHelper.unload(this.config);
            } else {
                this.syncToServer();
            }
        } else if (!changedValues.isEmpty()) {
            Constants.LOG.info("Sending config reloading event for {}", (Object)this.config.getFileName());
            this.config.getSpec().afterReload();
            IConfigEvent.reloading((ModConfig)this.config).post();
        }
    }

    @Override
    public IConfigEntry getRoot() {
        return new NeoForgeFolderEntry(((ModConfigSpec)this.config.getSpec()).getValues(), (ModConfigSpec)this.config.getSpec());
    }

    @Override
    public ConfigType getType() {
        return TYPE_RESOLVER.get(this.config.getType());
    }

    @Override
    public String getFileName() {
        return this.config.getFileName();
    }

    @Override
    public String getModId() {
        return this.config.getModId();
    }

    @Override
    public void loadWorldConfig(Path path, Consumer<IModConfig> result) {
        CommentedFileConfig data = (CommentedFileConfig)ConfigFileTypeHandler.TOML.reader(path).apply(this.config);
        NeoForgeConfigHelper.setConfigData(this.config, (CommentedConfig)data);
        result.accept(this);
    }

    @Override
    public void stopEditing() {
        if (this.config != null && this.getType() == ConfigType.WORLD && !ConfigHelper.isPlayingGame()) {
            NeoForgeConfigHelper.unload(this.config);
        }
    }

    @Override
    public boolean isChanged() {
        if (ConfigHelper.isWorldConfig(this) && this.config.getConfigData() == null) {
            return false;
        }
        return this.allConfigValues.stream().anyMatch(entry -> !Objects.equals(entry.value.get(), entry.spec.getDefault()));
    }

    @Override
    public void restoreDefaults() {
        if (ConfigHelper.isWorldConfig(this) && this.config.getConfigData() == null) {
            return;
        }
        CommentedConfig newConfig = CommentedConfig.copy((UnmodifiableCommentedConfig)this.config.getConfigData());
        this.allConfigValues.forEach(entry -> newConfig.set(entry.value.getPath(), entry.spec.getDefault()));
        this.config.getConfigData().putAll((UnmodifiableConfig)newConfig);
        this.allConfigValues.forEach(pair -> pair.value.clearCache());
    }

    private void syncToServer() {
        if (this.config == null) {
            return;
        }
        if (!ConfigHelper.isPlayingGame()) {
            return;
        }
        if (!ConfigHelper.isConfiguredInstalledOnServer()) {
            return;
        }
        if (this.getType() != ConfigType.WORLD_SYNC) {
            return;
        }
        Player player = ConfigHelper.getClientPlayer();
        if (!ConfigHelper.isOperator(player) || !SessionData.isDeveloper(player)) {
            return;
        }
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            TomlFormat.instance().createWriter().write((UnmodifiableConfig)this.config.getConfigData(), (OutputStream)stream);
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncNeoForgeConfigPayload(this.config.getFileName(), stream.toByteArray()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            stream.close();
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to close byte stream when sending config to server");
        }
    }

    protected List<ForgeValueEntry> getAllConfigValues(ModConfig config) {
        return NeoForgeConfigHelper.gatherAllConfigValues(config).stream().map(pair -> new ForgeValueEntry((ModConfigSpec.ConfigValue)pair.getLeft(), (ModConfigSpec.ValueSpec)pair.getRight())).toList();
    }

    protected record ForgeValueEntry(ModConfigSpec.ConfigValue<?> value, ModConfigSpec.ValueSpec spec) {
    }
}

