/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.neoforge;

import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.api.IModConfigProvider;
import com.mrcrayfish.configured.api.ModContext;
import com.mrcrayfish.configured.impl.neoforge.NeoForgeConfig;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class NeoForgeConfigProvider
implements IModConfigProvider {
    @Override
    public Set<IModConfig> getConfigurationsForMod(ModContext context) {
        HashSet<IModConfig> configs = new HashSet<IModConfig>();
        NeoForgeConfigProvider.addForgeConfigSetToMap(context, ModConfig.Type.CLIENT, configs::add);
        NeoForgeConfigProvider.addForgeConfigSetToMap(context, ModConfig.Type.COMMON, configs::add);
        NeoForgeConfigProvider.addForgeConfigSetToMap(context, ModConfig.Type.SERVER, configs::add);
        return configs;
    }

    private static void addForgeConfigSetToMap(ModContext context, ModConfig.Type type, Consumer<IModConfig> consumer) {
        Set configSet = (Set)ConfigTracker.INSTANCE.configSets().get(type);
        Set<IModConfig> filteredConfigSets = configSet.stream().filter(config -> config.getModId().equals(context.modId()) && config.getSpec() instanceof ModConfigSpec).map(NeoForgeConfig::new).collect(Collectors.toSet());
        filteredConfigSets.forEach(consumer);
    }
}

