/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.platform;

import com.mrcrayfish.configured.Config;
import com.mrcrayfish.configured.api.Environment;
import com.mrcrayfish.configured.impl.framework.message.MessageFramework;
import com.mrcrayfish.configured.network.message.MessageSessionData;
import com.mrcrayfish.configured.platform.services.IPlatformHelper;
import java.nio.file.Path;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.extensions.ICommonPacketListener;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.NetworkRegistry;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public Environment getEnvironment() {
        return FMLLoader.getDist().isClient() ? Environment.CLIENT : Environment.DEDICATED_SERVER;
    }

    @Override
    public Path getGamePath() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public String getDefaultConfigPath() {
        return FMLConfig.defaultConfigPath();
    }

    @Override
    public void sendSessionData(ServerPlayer player) {
        boolean developer = FMLLoader.getDist().isDedicatedServer() && Config.isDeveloperEnabled() && Config.getDevelopers().contains(player.getStringUUID());
        boolean lan = player.getServer() != null && !player.getServer().isDedicatedServer();
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new MessageSessionData(developer, lan), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendFrameworkConfigToServer(ResourceLocation id, byte[] data) {
        if (!this.isModLoaded("framework")) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new MessageFramework.Sync(id, data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendFrameworkConfigRequest(ResourceLocation id) {
        if (!this.isModLoaded("framework")) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new MessageFramework.Request(id), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendFrameworkConfigResponse(ServerPlayer player, byte[] data) {
        if (!this.isModLoaded("framework")) {
            return;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new MessageFramework.Response(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public boolean isConnectionActive(ClientPacketListener listener) {
        return NetworkRegistry.hasChannel((ICommonPacketListener)listener, (ResourceLocation)MessageSessionData.TYPE.id());
    }
}

