/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.util;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.neoforged.fml.config.ConfigFileTypeHandler;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class NeoForgeConfigHelper {
    private static final Method MOD_CONFIG_SET_CONFIG_DATA = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"setConfigData", (Class[])new Class[]{CommentedConfig.class});

    public static List<Pair<ModConfigSpec.ConfigValue<?>, ModConfigSpec.ValueSpec>> gatherAllConfigValues(UnmodifiableConfig config, ModConfigSpec spec) {
        ArrayList values = new ArrayList();
        NeoForgeConfigHelper.gatherValuesFromModConfig(config, spec, values);
        return ImmutableList.copyOf(values);
    }

    private static void gatherValuesFromModConfig(UnmodifiableConfig config, ModConfigSpec spec, List<Pair<ModConfigSpec.ConfigValue<?>, ModConfigSpec.ValueSpec>> values) {
        config.valueMap().forEach((s, o) -> {
            if (o instanceof AbstractConfig) {
                NeoForgeConfigHelper.gatherValuesFromModConfig((UnmodifiableConfig)o, spec, values);
            } else if (o instanceof ModConfigSpec.ConfigValue) {
                ModConfigSpec.ConfigValue configValue = (ModConfigSpec.ConfigValue)o;
                ModConfigSpec.ValueSpec valueSpec = (ModConfigSpec.ValueSpec)spec.getRaw(configValue.getPath());
                values.add(Pair.of((Object)configValue, (Object)valueSpec));
            }
        });
    }

    public static void setConfigData(ModConfig config, @Nullable CommentedConfig configData) {
        try {
            MOD_CONFIG_SET_CONFIG_DATA.invoke((Object)config, configData);
            if (configData instanceof FileConfig) {
                config.save();
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static ModConfig getModConfig(String fileName) {
        ConcurrentHashMap configMap = (ConcurrentHashMap)ObfuscationReflectionHelper.getPrivateValue(ConfigTracker.class, (Object)ConfigTracker.INSTANCE, (String)"fileMap");
        return configMap != null ? (ModConfig)configMap.get(fileName) : null;
    }

    public static List<Pair<ModConfigSpec.ConfigValue<?>, ModConfigSpec.ValueSpec>> gatherAllConfigValues(ModConfig config) {
        return NeoForgeConfigHelper.gatherAllConfigValues(((ModConfigSpec)config.getSpec()).getValues(), (ModConfigSpec)config.getSpec());
    }

    public static void unload(ModConfig config) {
        if (config.getConfigData() != null) {
            ConfigFileTypeHandler.TOML.unload(config);
            config.save();
            NeoForgeConfigHelper.setConfigData(config, null);
        }
    }
}

