/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.util;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.Environment;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.ClientConfigHelper;
import com.mrcrayfish.configured.platform.Services;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class ConfigHelper {
    public static List<IConfigEntry> gatherAllConfigEntries(IConfigEntry entry) {
        ObjectArrayList entries = new ObjectArrayList();
        ArrayDeque<IConfigEntry> queue = new ArrayDeque<IConfigEntry>(entry.getChildren());
        while (!queue.isEmpty()) {
            IConfigEntry e = (IConfigEntry)queue.poll();
            entries.add(e);
            if (e.isLeaf()) continue;
            queue.addAll(e.getChildren());
        }
        return entries;
    }

    public static List<IConfigValue<?>> gatherAllConfigValues(IConfigEntry entry) {
        ObjectArrayList values = new ObjectArrayList();
        ConfigHelper.gatherValuesFromForgeConfig(entry, values);
        return ImmutableList.copyOf((Collection)values);
    }

    private static void gatherValuesFromForgeConfig(IConfigEntry entry, List<IConfigValue<?>> values) {
        if (entry.isLeaf()) {
            IConfigValue<?> value = entry.getValue();
            if (value != null) {
                values.add(value);
            }
            return;
        }
        for (IConfigEntry children : entry.getChildren()) {
            ConfigHelper.gatherValuesFromForgeConfig(children, values);
        }
    }

    public static boolean isWorldConfig(IModConfig config) {
        return config.getType() == ConfigType.WORLD || config.getType() == ConfigType.WORLD_SYNC;
    }

    public static boolean isServerConfig(IModConfig config) {
        return config.getType().isServer() && !ConfigHelper.isWorldConfig(config);
    }

    public static boolean isConfiguredInstalledOnServer() {
        ClientPacketListener listener = Minecraft.getInstance().getConnection();
        return listener != null && Services.PLATFORM.isConnectionActive(listener);
    }

    public static Set<IConfigValue<?>> getChangedValues(IConfigEntry entry) {
        HashSet changed = new HashSet();
        ArrayDeque<IConfigEntry> found = new ArrayDeque<IConfigEntry>();
        found.add(entry);
        while (!found.isEmpty()) {
            IConfigEntry toSave = (IConfigEntry)found.poll();
            if (!toSave.isLeaf()) {
                found.addAll(toSave.getChildren());
                continue;
            }
            IConfigValue<?> value = toSave.getValue();
            if (value == null || !value.isChanged()) continue;
            changed.add(value);
        }
        return changed;
    }

    public static boolean isPlayingGame() {
        if (Services.PLATFORM.getEnvironment() != Environment.CLIENT) {
            return false;
        }
        return ClientConfigHelper.isPlayingGame();
    }

    public static boolean isServerOwnedByPlayer(@Nullable Player player) {
        return player != null && player.getServer() != null && !player.getServer().isDedicatedServer() && player.getServer().isSingleplayerOwner(player.getGameProfile());
    }

    public static boolean hasPermissionToEdit(@Nullable Player player, IModConfig config) {
        return !config.getType().isServer() || player != null && (player.hasPermissions(4) || ConfigHelper.isServerOwnedByPlayer(player));
    }

    public static boolean isOperator(@Nullable Player player) {
        return player != null && player.hasPermissions(4);
    }

    public static Player getClientPlayer() {
        if (Services.PLATFORM.getEnvironment() != Environment.CLIENT) {
            return null;
        }
        return ClientConfigHelper.getClientPlayer();
    }

    public static boolean isRunningLocalServer() {
        if (Services.PLATFORM.getEnvironment() != Environment.CLIENT) {
            return false;
        }
        return ClientConfigHelper.isRunningLocalServer();
    }
}

