/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="hunterillager", bus=Mod.EventBusSubscriber.Bus.MOD)
public class HunterConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static List<Item> foodWhitelist;

    public static void bakeConfig() {
        foodWhitelist.clear();
        ((List)HunterConfig.COMMON.foodWhitelist.get()).forEach(item -> {
            Item type = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item));
            if (type != null) {
                foodWhitelist.add(type);
            }
        });
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            HunterConfig.bakeConfig();
        }
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent.Reloading configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            HunterConfig.bakeConfig();
        }
    }

    static {
        foodWhitelist = Lists.newArrayList();
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> foodWhitelist;

        public Common(ForgeConfigSpec.Builder builder) {
            this.foodWhitelist = builder.translation("hunterillager.config.foodWhitelist").define("HunterIllager's Food Whitelist", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:apple", "minecraft:cooked_beef", "minecraft:cooked_chicken", "minectaft:cooked_mutton", "minecraft:cooked_porkchop", "minecraft:beef", "minecraft:chicken", "minectaft:mutton", "minecraft:porkchop"}), s -> s instanceof String);
        }
    }
}

