/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class HunterConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    public static void init() {
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue structureSpacing;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> foodWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> attackableWhitelist;

        public Common(ForgeConfigSpec.Builder builder) {
            Predicate<Object> validator = o -> o instanceof String;
            this.structureSpacing = builder.translation("hunterillager.config.structureSpacing").comment("Changed HunterHouse Generate Spacing. [24 ~ 100]").defineInRange("HunterHouse Generate Spacing", 26, 24, 100);
            this.foodWhitelist = builder.translation("hunterillager.config.foodWhitelist").comment("Add Item for What Hunter Illager can eatable [example: minecraft:apple]").defineList("HunterIllager's Food Whitelist", (List)Lists.newArrayList((Object[])new String[]{"minecraft:apple", "minecraft:cooked_beef", "minecraft:cooked_chicken", "minecraft:cooked_mutton", "minecraft:cooked_porkchop", "minecraft:beef", "minecraft:chicken", "minecraft:mutton", "minecraft:porkchop"}), validator);
            this.attackableWhitelist = builder.translation("hunterillager.config.attackableWhitelist").comment("Add Entity for What Hunter Illager can hunt [example: minecraft:chicken]").defineList("HunterIllager's Hunt Entity Whitelist", (List)Lists.newArrayList((Object[])new String[]{"minecraft:chicken", "minecraft:rabbit", "minecraft:pig", "minecraft:cow", "minecraft:sheep", "earthmobsmod:wooly_cow", "earthmobsmod:horned_sheep"}), validator);
        }
    }
}

