/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.init;

import baguchan.hunterillager.HunterConfig;
import baguchan.hunterillager.structure.HunterHousePieces;
import baguchan.hunterillager.structure.HunterHouseStructure;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="hunterillager", bus=Mod.EventBusSubscriber.Bus.MOD)
public class HunterStructureRegister {
    public static final StructureFeature<NoneFeatureConfiguration> HUNTER_HOUSE = new HunterHouseStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final ConfiguredStructureFeature<NoneFeatureConfiguration, ? extends StructureFeature<NoneFeatureConfiguration>> HUNTER_HOUSE_FEATURE = HunterStructureRegister.configFeatureRegister(HunterStructureRegister.prefix("hunter_house"), HUNTER_HOUSE.m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
    public static final StructurePieceType HUNTER_HOUSE_STRUCTURE_PIECE = HunterStructureRegister.setPieceId(HunterHousePieces.Piece::new, "HHSP");

    static StructurePieceType setPieceId(StructurePieceType.StructureTemplateType p_67164_, String p_67165_) {
        return (StructurePieceType)Registry.m_122961_((Registry)Registry.f_122843_, (String)p_67165_.toLowerCase(Locale.ROOT), (Object)p_67164_);
    }

    @SubscribeEvent
    public static void registerfeature(RegistryEvent.Register<StructureFeature<?>> registry) {
        StructureFeature.f_67012_.put((Object)"hunterillager:hunter_house", HUNTER_HOUSE);
        HunterStructureRegister.setupMapSpacingAndLand(HUNTER_HOUSE, new StructureFeatureConfiguration(((Integer)HunterConfig.COMMON.structureSpacing.get()).intValue(), 6, 15437620), false);
        registry.getRegistry().register((IForgeRegistryEntry)((StructureFeature)HUNTER_HOUSE.setRegistryName("hunter_house")));
    }

    public static <F extends StructureFeature<?>> void setupMapSpacingAndLand(F structure, StructureFeatureConfiguration structureFeatureConfiguration, boolean transformSurroundingLand) {
        if (transformSurroundingLand) {
            StructureFeature.f_67031_ = ImmutableList.builder().addAll((Iterable)StructureFeature.f_67031_).add(structure).build();
        }
        StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put(structure, (Object)structureFeatureConfiguration).build();
        BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
            Map structureMap = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(structureMap);
                tempMap.put(structure, structureFeatureConfiguration);
                ((NoiseGeneratorSettings)settings.getValue()).m_64457_().f_64582_ = tempMap;
            } else {
                structureMap.put(structure, structureFeatureConfiguration);
            }
        });
    }

    private static <FC extends FeatureConfiguration, F extends StructureFeature<FC>> ConfiguredStructureFeature<FC, F> configFeatureRegister(String p_127268_, ConfiguredStructureFeature<FC, F> p_127269_) {
        return (ConfiguredStructureFeature)BuiltinRegistries.m_123876_((Registry)BuiltinRegistries.f_123862_, (String)p_127268_, p_127269_);
    }

    private static String prefix(String path) {
        return "hunterillager:" + path;
    }
}

