/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.entity.projectile;

import baguchan.hunterillager.HunterEntityRegistry;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class BoomerangEntity
extends Entity
implements IProjectile {
    private static final DataParameter<Byte> LOYALTY_LEVEL = EntityDataManager.func_187226_a(BoomerangEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> PIERCING_LEVEL = EntityDataManager.func_187226_a(BoomerangEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> RETURNING = EntityDataManager.func_187226_a(BoomerangEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> BOOMERANG = EntityDataManager.func_187226_a(BoomerangEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    @Nullable
    private UUID shootingEntity;
    private Vec3d throwPos;
    private int entityHits;
    private int totalHits;
    private int flyTick;

    public BoomerangEntity(EntityType<? extends BoomerangEntity> type, World world) {
        super(type, world);
    }

    public BoomerangEntity(EntityType<? extends BoomerangEntity> type, World world, @Nullable LivingEntity shootingEntity, ItemStack boomerang) {
        super(type, world);
        this.setShooter((Entity)shootingEntity);
        this.setBoomerang(boomerang);
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)boomerang)));
        this.field_70180_af.func_187227_b(PIERCING_LEVEL, (Object)((byte)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)boomerang)));
        this.throwPos = new Vec3d(shootingEntity == null ? 0.0 : shootingEntity.field_70165_t, shootingEntity == null ? 0.0 : shootingEntity.field_70163_u + (double)shootingEntity.func_70047_e() - 0.1, shootingEntity == null ? 0.0 : shootingEntity.field_70161_v);
        this.func_70107_b(this.throwPos.field_72450_a, this.throwPos.field_72448_b, this.throwPos.field_72449_c);
        this.totalHits = 0;
    }

    public BoomerangEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(HunterEntityRegistry.BOOMERANG, world);
    }

    public BoomerangEntity(World world, LivingEntity entity, ItemStack boomerang) {
        this(HunterEntityRegistry.BOOMERANG, world, entity, boomerang);
    }

    private void onHit(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            Entity shooter;
            boolean returnToOwner;
            boolean bl = returnToOwner = result.func_216346_c() == RayTraceResult.Type.BLOCK;
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockPos pos = ((BlockRayTraceResult)result).func_216350_a();
                BlockState state = this.field_70170_p.func_180495_p(pos);
                SoundType soundType = state.getSoundType((IWorldReader)this.field_70170_p, pos, (Entity)this);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundType.func_185846_f(), SoundCategory.BLOCKS, soundType.func_185843_a() * 0.26f, soundType.func_185847_b());
                ++this.totalHits;
                BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)result;
                BlockState blockstate = this.field_70170_p.func_180495_p(blockraytraceresult.func_216350_a());
                blockstate.func_215690_a(this.field_70170_p, state, blockraytraceresult, (Entity)this);
                this.func_145775_I();
            }
            byte loyaltyLevel = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
            byte piercingLevel = (Byte)this.field_70180_af.func_187225_a(PIERCING_LEVEL);
            if (!(result.func_216346_c() != RayTraceResult.Type.ENTITY || ((EntityRayTraceResult)result).func_216348_a() == this.getShooter() || this.isReturning() && loyaltyLevel > 0)) {
                shooter = this.getShooter();
                int sharpness = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)this.getBoomerang());
                ((EntityRayTraceResult)result).func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)shooter), (float)(3.0 * Math.sqrt(this.func_213322_ci().func_82615_a() * this.func_213322_ci().func_82615_a() + this.func_213322_ci().func_82617_b() * this.func_213322_ci().func_82617_b() * 0.5 + this.func_213322_ci().func_82616_c() * this.func_213322_ci().func_82616_c()) + (double)Math.min(1, sharpness) + (double)Math.max(0, sharpness - 1) * 0.5) + 0.5f * (float)piercingLevel);
                if (shooter instanceof LivingEntity) {
                    this.getBoomerang().func_222118_a(1, (LivingEntity)shooter, p_222182_1_ -> {});
                }
                double velocity = this.getVelocity();
                if (piercingLevel < 1 || this.entityHits >= piercingLevel || velocity < (double)0.4f) {
                    returnToOwner = true;
                    ++this.totalHits;
                }
                ++this.entityHits;
            }
            if (this.isReturning() && loyaltyLevel < 1 && this.totalHits >= 6) {
                this.drop(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                return;
            }
            if (returnToOwner && !this.isReturning()) {
                if (this.getShooter() != null && this.shouldReturnToThrower() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_203193_C, (ItemStack)this.getBoomerang()) > 0) {
                    shooter = this.getShooter();
                    this.field_70170_p.func_184133_a(null, shooter.func_180425_c(), SoundEvents.field_203270_il, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    Vec3d returnVec = this.throwPos.func_178786_a(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72432_b();
                    double velocity = this.getVelocity();
                    this.func_213293_j(velocity * returnVec.field_72450_a, velocity * returnVec.field_72448_b, velocity * returnVec.field_72449_c);
                    this.func_70018_K();
                    this.setReturning(true);
                } else {
                    Vec3d returnVec = this.throwPos.func_178786_a(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72432_b();
                    double velocity = this.getVelocity();
                    this.func_213293_j(velocity * returnVec.field_72450_a, velocity * returnVec.field_72448_b, velocity * returnVec.field_72449_c);
                    this.func_70018_K();
                    this.setReturning(true);
                }
            }
        }
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.getShooter();
        if (entity != null && entity.func_70089_S()) {
            return !(entity instanceof ServerPlayerEntity) || !entity.func_175149_v();
        }
        return false;
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        super.func_70100_b_(entityIn);
        if (!this.field_70170_p.field_72995_K && this.isReturning() && entityIn == this.getShooter()) {
            this.drop(this.getShooter().field_70165_t, this.getShooter().field_70163_u, this.getShooter().field_70161_v);
        }
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (!this.field_70170_p.field_72995_K && this.isReturning() && entityIn == this.getShooter()) {
            this.drop(this.getShooter().field_70165_t, this.getShooter().field_70163_u, this.getShooter().field_70161_v);
        }
    }

    public void drop(double x, double y, double z) {
        if (!(this.getShooter() instanceof PlayerEntity) || this.getShooter() instanceof PlayerEntity && !((PlayerEntity)this.getShooter()).func_184812_l_()) {
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, x, y, z, this.getBoomerang().func_77946_l()));
        }
        this.func_70106_y();
    }

    public void shoot(Entity shooter, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.func_213317_d(this.func_213322_ci().func_72441_c(shooter.func_213322_ci().field_72450_a, shooter.field_70122_E ? 0.0 : shooter.func_213322_ci().field_72448_b, shooter.func_213322_ci().field_72449_c));
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3d vec3d = new Vec3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(vec3d);
        float f = MathHelper.func_76133_a((double)BoomerangEntity.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void func_70071_h_() {
        EntityRayTraceResult entityRaytraceResult;
        boolean flag = this.getNoClip();
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        ++this.flyTick;
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.func_213322_ci().func_82615_a(), this.field_70163_u + this.func_213322_ci().func_82617_b(), this.field_70161_v + this.func_213322_ci().func_82616_c());
        BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            vec3d1 = raytraceresult.func_216347_e();
        }
        if ((entityRaytraceResult = this.func_213866_a(vec3d, vec3d1)) != null) {
            raytraceresult = entityRaytraceResult;
        }
        if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
            Entity entity1 = this.getShooter();
            if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                raytraceresult = null;
            }
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() == Blocks.field_150427_aO) {
            this.func_181015_d(this.func_180425_c());
        }
        if (!ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.onHit((RayTraceResult)raytraceresult);
            this.field_70160_al = true;
        }
        this.field_70165_t += this.func_213322_ci().func_82615_a();
        this.field_70163_u += this.func_213322_ci().func_82617_b();
        this.field_70161_v += this.func_213322_ci().func_82616_c();
        float f = MathHelper.func_76133_a((double)(this.func_213322_ci().func_82615_a() * this.func_213322_ci().func_82615_a() + this.func_213322_ci().func_82616_c() * this.func_213322_ci().func_82616_c()));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.func_213322_ci().func_82615_a(), (double)this.func_213322_ci().func_82616_c()) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.func_213322_ci().func_82617_b(), (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        double f1 = 0.99;
        double f2 = this.getGravityVelocity();
        if (this.func_70090_H()) {
            for (int j = 0; j < 4; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.field_70165_t - this.func_213322_ci().func_82615_a() * 0.25, this.field_70163_u - this.func_213322_ci().func_82617_b() * 0.25, this.field_70161_v - this.func_213322_ci().func_82616_c() * 0.25, this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82617_b(), this.func_213322_ci().func_82616_c());
            }
            f1 = 0.8;
        }
        byte loyaltyLevel = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
        Entity entity = this.getShooter();
        if (loyaltyLevel > 0 && !this.isReturning() && this.flyTick == 100 && entity != null) {
            this.field_70170_p.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_203270_il, SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.setReturning(true);
        }
        if (loyaltyLevel > 0 && entity != null && !this.shouldReturnToThrower() && this.isReturning()) {
            if (!this.field_70170_p.field_72995_K) {
                this.drop(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
            this.func_70106_y();
        } else if (loyaltyLevel > 0 && entity != null && this.isReturning()) {
            this.field_70145_X = true;
            Vec3d vec3d2 = new Vec3d(entity.field_70165_t - this.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() - this.field_70163_u, entity.field_70161_v - this.field_70161_v);
            if (this.field_70170_p.field_72995_K) {
                this.field_70137_T = this.field_70163_u;
            }
            double d0 = 0.05 * (double)loyaltyLevel;
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(vec3d2.func_72432_b().func_186678_a(d0)));
        } else if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -f2, 0.0));
            this.func_213317_d(this.func_213322_ci().func_186678_a(f1));
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.collideWithNearbyEntities();
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vec3d p_213866_1_, Vec3d p_213866_2_) {
        return ProjectileHelper.func_221271_a((World)this.field_70170_p, (Entity)this, (Vec3d)p_213866_1_, (Vec3d)p_213866_2_, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_213871_1_ -> !p_213871_1_.func_175149_v() && p_213871_1_.func_70089_S() && p_213871_1_.func_70067_L() && p_213871_1_ != this.getShooter());
    }

    public boolean getNoClip() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70145_X;
        }
        return false;
    }

    public boolean func_70067_L() {
        return super.func_70067_L();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * BoomerangEntity.func_184183_bd()) * d0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(LOYALTY_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(PIERCING_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(RETURNING, (Object)false);
        this.field_70180_af.func_187214_a(BOOMERANG, (Object)ItemStack.field_190927_a);
    }

    public void func_213281_b(CompoundNBT nbt) {
        if (this.shootingEntity != null) {
            nbt.func_186854_a("shootingEntityId", this.shootingEntity);
        }
        nbt.func_218657_a("boomerang", (INBT)this.getBoomerang().func_77955_b(new CompoundNBT()));
        nbt.func_74780_a("throwX", this.throwPos.field_72450_a);
        nbt.func_74780_a("throwY", this.throwPos.field_72448_b);
        nbt.func_74780_a("throwZ", this.throwPos.field_72449_c);
        nbt.func_74774_a("entityHits", (byte)this.entityHits);
        nbt.func_74774_a("totalHits", (byte)this.totalHits);
        nbt.func_74757_a("returning", this.isReturning());
    }

    public void func_70037_a(CompoundNBT nbt) {
        if (nbt.func_186855_b("shootingEntityId")) {
            this.shootingEntity = nbt.func_186857_a("shootingEntityId");
        }
        this.setBoomerang(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("boomerang")));
        this.throwPos = new Vec3d(nbt.func_74769_h("throwX"), nbt.func_74769_h("throwY"), nbt.func_74769_h("throwZ"));
        this.entityHits = nbt.func_74771_c("entityHits");
        this.totalHits = nbt.func_74771_c("totalHits");
        this.setReturning(nbt.func_74767_n("returning"));
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)this.getBoomerang())));
        this.field_70180_af.func_187227_b(PIERCING_LEVEL, (Object)((byte)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)this.getBoomerang())));
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void collideWithNearbyEntities() {
        List list;
        if (this.isReturning() && !(list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), EntityPredicates.func_200823_a((Entity)this))).isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = (Entity)list.get(l);
                if (entity != this.getShooter()) continue;
                this.drop(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            }
        }
    }

    private double getGravityVelocity() {
        return Math.min(1.0, Math.pow(2.0, -(Math.abs(this.func_213322_ci().func_82615_a()) + Math.abs(this.func_213322_ci().func_82616_c())) * 2.0)) * 0.03;
    }

    public boolean isReturning() {
        return (Boolean)this.field_70180_af.func_187225_a(RETURNING);
    }

    public void setShooter(@Nullable Entity entityIn) {
        this.shootingEntity = entityIn == null ? null : entityIn.func_110124_au();
    }

    @Nullable
    public Entity getShooter() {
        return this.shootingEntity != null && this.field_70170_p instanceof ServerWorld ? ((ServerWorld)this.field_70170_p).func_217461_a(this.shootingEntity) : null;
    }

    public ItemStack getBoomerang() {
        return (ItemStack)this.field_70180_af.func_187225_a(BOOMERANG);
    }

    public double getVelocity() {
        return Math.sqrt(this.func_213322_ci().func_82615_a() * this.func_213322_ci().func_82615_a() + this.func_213322_ci().func_82617_b() * this.func_213322_ci().func_82617_b() + this.func_213322_ci().func_82616_c() * this.func_213322_ci().func_82616_c());
    }

    public int getPiercingLevel() {
        return ((Byte)this.field_70180_af.func_187225_a(PIERCING_LEVEL)).byteValue();
    }

    public void setReturning(boolean returning) {
        this.field_70180_af.func_187227_b(RETURNING, (Object)returning);
    }

    public void setBoomerang(ItemStack stack) {
        this.field_70180_af.func_187227_b(BOOMERANG, (Object)stack);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

