/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.structure;

import baguchan.hunterillager.structure.FeatureRegister;
import baguchan.hunterillager.structure.HunterHousePieces;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class HunterHouseStructure
extends Structure<NoFeatureConfig> {
    public HunterHouseStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51440_1_) {
        super(p_i51440_1_);
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int i = this.getBiomeFeatureDistance(chunkGenerator);
        int j = this.getBiomeFeatureSeparation(chunkGenerator);
        int k = x + i * spacingOffsetsX;
        int l = z + i * spacingOffsetsZ;
        int i1 = k < 0 ? k - i + 1 : k;
        int j1 = l < 0 ? l - i + 1 : l;
        int k1 = i1 / i;
        int l1 = j1 / i;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), k1, l1, this.getSeedModifier());
        k1 *= i;
        l1 *= i;
        return new ChunkPos(k1 += random.nextInt(i - j), l1 += random.nextInt(i - j));
    }

    public boolean func_225558_a_(BiomeManager p_225558_1_, ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ, Biome p_225558_6_) {
        ChunkPos chunkpos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        if (chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b && chunkGen.func_202094_a(p_225558_6_, FeatureRegister.HUNTER_HOUSE)) {
            for (int k = chunkPosX - 10; k <= chunkPosX + 10; ++k) {
                for (int l = chunkPosZ - 10; l <= chunkPosZ + 10; ++l) {
                    if (!Feature.field_214550_p.func_225558_a_(p_225558_1_, chunkGen, rand, k, l, p_225558_6_)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String func_143025_a() {
        return "hunterillager:hunterhouse";
    }

    public int func_202367_b() {
        return 3;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    protected int getSeedModifier() {
        return 10387313;
    }

    protected int getBiomeFeatureDistance(ChunkGenerator<?> chunkGenerator) {
        return 24;
    }

    protected int getBiomeFeatureSeparation(ChunkGenerator<?> chunkGenerator) {
        return 3;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> p_i50460_1_, int p_i50460_2_, int p_i50460_3_, MutableBoundingBox p_i50460_5_, int p_i50460_6_, long p_i50460_7_) {
            super(p_i50460_1_, p_i50460_2_, p_i50460_3_, p_i50460_5_, p_i50460_6_, p_i50460_7_);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            BlockPos blockpos = new BlockPos(chunkX * 16, 90, chunkZ * 16);
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            HunterHousePieces.addStructure(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d, biomeIn);
            this.func_202500_a();
        }

        public void func_225565_a_(IWorld worldIn, ChunkGenerator<?> chunkGenerator, Random rand, MutableBoundingBox structurebb, ChunkPos pos) {
            super.func_225565_a_(worldIn, chunkGenerator, rand, structurebb, pos);
            int i = this.field_75074_b.field_78895_b;
            for (int j = structurebb.field_78897_a; j <= structurebb.field_78893_d; ++j) {
                for (int k = structurebb.field_78896_c; k <= structurebb.field_78892_f; ++k) {
                    BlockPos blockpos1;
                    BlockPos blockpos = new BlockPos(j, i, k);
                    if (worldIn.func_175623_d(blockpos) || !this.field_75074_b.func_175898_b((Vec3i)blockpos)) continue;
                    boolean flag = false;
                    for (StructurePiece structurepiece : this.field_75075_a) {
                        if (!structurepiece.func_74874_b().func_175898_b((Vec3i)blockpos)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    for (int l = i - 1; l > 1 && (worldIn.func_175623_d(blockpos1 = new BlockPos(j, l, k)) || worldIn.func_180495_p(blockpos1).func_185904_a().func_76224_d()); --l) {
                        worldIn.func_180501_a(blockpos1, Blocks.field_150346_d.func_176223_P(), 2);
                    }
                }
            }
        }
    }
}

