/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.item;

import baguchan.hunterillager.init.HunterItems;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class QuiverItem
extends ArrowItem {
    public QuiverItem(Item.Properties group) {
        super(group);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        ItemStack itemstack2 = playerIn.func_184586_b(Hand.OFF_HAND);
        if (itemstack2.func_77973_b() instanceof ArrowItem && itemstack2.func_77973_b() != HunterItems.QUIVER && QuiverItem.getProjectiles(itemstack).size() < 6) {
            QuiverItem.addArrow((LivingEntity)playerIn, itemstack, itemstack2, playerIn.func_184812_l_());
            playerIn.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        if (!(itemstack2.func_77973_b() instanceof ArrowItem) && itemstack2.func_77973_b() != HunterItems.QUIVER && !QuiverItem.getProjectiles(itemstack).isEmpty()) {
            for (ItemStack stack : QuiverItem.getProjectiles(itemstack)) {
                ItemStack dropItemStack = stack.func_77946_l();
                ItemEntity itemEntity = new ItemEntity(worldIn, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), dropItemStack);
                worldIn.func_217376_c((Entity)itemEntity);
            }
            QuiverItem.clearProjectiles(itemstack);
            playerIn.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    private static boolean addArrow(LivingEntity livingEntity, ItemStack stack, ItemStack arrow, boolean isCreative) {
        ItemStack itemstack;
        boolean flag;
        if (arrow.func_190926_b()) {
            return false;
        }
        boolean bl = flag = isCreative && arrow.func_77973_b() instanceof ArrowItem;
        if (!flag && !isCreative) {
            itemstack = arrow.func_77979_a(arrow.func_190916_E());
            if (arrow.func_190926_b() && livingEntity instanceof PlayerEntity) {
                ((PlayerEntity)livingEntity).field_71071_by.func_184437_d(arrow);
            }
        } else {
            itemstack = arrow.func_77946_l();
        }
        QuiverItem.addProjectile(stack, itemstack);
        return true;
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, PlayerEntity player) {
        return true;
    }

    public boolean hasArrow(ItemStack quiver, PlayerEntity player) {
        return QuiverItem.getProjectiles(quiver).stream().anyMatch(p_220010_1_ -> p_220010_1_.func_77973_b() instanceof ArrowItem);
    }

    public static void addProjectile(ItemStack quiver, ItemStack projectile) {
        CompoundNBT compoundnbt = quiver.func_196082_o();
        ListNBT listnbt = compoundnbt.func_150297_b("Projectiles", 9) ? compoundnbt.func_150295_c("Projectiles", 10) : new ListNBT();
        CompoundNBT compoundnbt1 = new CompoundNBT();
        projectile.func_77955_b(compoundnbt1);
        listnbt.add((Object)compoundnbt1);
        compoundnbt.func_218657_a("Projectiles", (INBT)listnbt);
    }

    public static List<ItemStack> getProjectiles(ItemStack stack) {
        ListNBT listnbt;
        ArrayList list = Lists.newArrayList();
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("Projectiles", 9) && (listnbt = compoundnbt.func_150295_c("Projectiles", 10)) != null) {
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt1 = listnbt.func_150305_b(i);
                list.add(ItemStack.func_199557_a((CompoundNBT)compoundnbt1));
            }
        }
        return list;
    }

    public static ItemStack getProjectileFromQuivers(ItemStack quiver) {
        if (quiver.func_77942_o() && quiver.func_77978_p().func_150297_b("Projectiles", 9)) {
            List<ItemStack> list = QuiverItem.getProjectiles(quiver);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack stack = list.get(i);
                if (stack.func_190926_b()) continue;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    private static void clearProjectiles(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null) {
            ListNBT listnbt = compoundnbt.func_150295_c("Projectiles", 9);
            listnbt.clear();
            compoundnbt.func_218657_a("Projectiles", (INBT)listnbt);
        }
    }

    public static void consumeProjectiles(ItemStack stack) {
        ItemStack itemstack;
        int i;
        List<ItemStack> list = QuiverItem.getProjectiles(stack);
        ArrayList list2 = Lists.newArrayList();
        boolean hasArrow = false;
        for (i = 0; i < list.size(); ++i) {
            itemstack = list.get(i);
            if (!hasArrow && !itemstack.func_190926_b()) {
                itemstack.func_190918_g(1);
                hasArrow = true;
            }
            if (itemstack.func_190926_b()) continue;
            list2.add(itemstack);
        }
        QuiverItem.clearProjectiles(stack);
        for (i = 0; i < list2.size(); ++i) {
            itemstack = (ItemStack)list2.get(i);
            QuiverItem.addProjectile(stack, itemstack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        List<ItemStack> list = QuiverItem.getProjectiles(stack);
        TextFormatting[] atextformatting = new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY};
        tooltip.add((ITextComponent)new TranslationTextComponent("item.hunterillager.quiver.desc").func_240701_a_(atextformatting));
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemstack = list.get(i);
                tooltip.add((ITextComponent)new TranslationTextComponent("item.minecraft.crossbow.projectile").func_240702_b_(" ").func_230529_a_(itemstack.func_151000_E()).func_240702_b_(" *" + itemstack.func_190916_E()));
            }
        }
    }
}

