/*
 * Decompiled with CFR 0.152.
 */
package com.syllient.livingchest.animation.entity;

import com.syllient.livingchest.entity.ChesterEntity;
import com.syllient.livingchest.eventhandler.registry.SoundRegistry;
import com.syllient.livingchest.geckolib.ExtendedAnimationController;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class ChesterAnimation
extends com.syllient.livingchest.animation.Animation<ChesterEntity> {
    private final ExtendedAnimationController<ChesterEntity> idleController;
    private final ExtendedAnimationController<ChesterEntity> jumpController;
    private final ExtendedAnimationController<ChesterEntity> openController;
    private int idleSoundTimes = 0;
    private int ticksIdling = 0;
    private boolean wasMouthOpen = false;

    public ChesterAnimation(ChesterEntity chester) {
        super(chester);
        this.idleController = new ExtendedAnimationController<ChesterEntity>(chester, "idle_controller", 0.0f, this::idlePredicate);
        this.jumpController = new ExtendedAnimationController<ChesterEntity>(chester, "jump_controller", 0.0f, this::jumpPredicate);
        this.openController = new ExtendedAnimationController<ChesterEntity>(chester, "open_controller", 0.0f, this::openPredicate);
    }

    @Override
    public void registerControllers(AnimationData data) {
        this.idleController.registerSoundListener(this::soundListener);
        this.jumpController.registerSoundListener(this::soundListener);
        this.openController.registerSoundListener(this::soundListener);
        data.addAnimationController(this.idleController);
        data.addAnimationController(this.jumpController);
        data.addAnimationController(this.openController);
    }

    private void onTick() {
        boolean isIdling = this.jumpController.isAnimationStopped();
        this.ticksIdling = isIdling ? ++this.ticksIdling : 0;
        if (((ChesterEntity)this.animatable).isMouthOpen() && !this.wasMouthOpen || this.ticksIdling < 5) {
            this.idleSoundTimes = 0;
        }
        this.wasMouthOpen = ((ChesterEntity)this.animatable).isMouthOpen();
    }

    private PlayState idlePredicate(AnimationEvent<? extends IAnimatable> event) {
        this.onTick();
        if (this.ticksIdling < 5) {
            return PlayState.STOP;
        }
        this.idleController.setAnimationSpeed(1.1);
        this.idleController.setAnimation(new AnimationBuilder().addAnimation("animation.chester.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private PlayState jumpPredicate(AnimationEvent<? extends IAnimatable> event) {
        if (this.jumpController.isAnimationStopped("animation.chester.init_jump")) {
            this.jumpController.setAnimation(new AnimationBuilder().addAnimation("animation.chester.jump"));
            return PlayState.CONTINUE;
        }
        boolean isJumping = this.jumpController.isCurrentAnimation("animation.chester.jump");
        if (event.isMoving() && ((ChesterEntity)this.animatable).field_70122_E && this.openController.isAnimationStopped()) {
            if (!isJumping) {
                this.jumpController.setAnimation(new AnimationBuilder().addAnimation("animation.chester.init_jump"));
            }
            return PlayState.CONTINUE;
        }
        if (isJumping && this.jumpController.hasJustFinishedAnimation()) {
            this.jumpController.setAnimation(new AnimationBuilder().addAnimation("animation.chester.stop_jump"));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    private PlayState openPredicate(AnimationEvent<? extends IAnimatable> event) {
        if (this.ticksIdling < 5) {
            return PlayState.STOP;
        }
        if (((ChesterEntity)this.animatable).isMouthOpen()) {
            this.openController.setAnimation(new AnimationBuilder().addAnimation("animation.chester.open_mouth").addAnimation("animation.chester.idle_mouth"));
            return PlayState.CONTINUE;
        }
        if (this.openController.isCurrentAnimation("animation.chester.idle_mouth")) {
            this.openController.setAnimation(new AnimationBuilder().addAnimation("animation.chester.close_mouth"));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    private void soundListener(SoundKeyframeEvent<? extends IAnimatable> event) {
        switch (event.sound) {
            case "idle": {
                ++this.idleSoundTimes;
                this.playSound(SoundRegistry.Entity.Chester.IDLE, Math.max(0.025f, 0.1f - (float)this.idleSoundTimes * 0.005f), 1.0f);
                break;
            }
            case "jump": {
                this.playSound(SoundRegistry.Entity.Chester.JUMP, 0.15f, 1.0f);
                break;
            }
            case "open_mouth": {
                this.playSound(SoundRegistry.Entity.Chester.OPEN_MOUTH, 0.5f, 1.0f);
                break;
            }
            case "close_mouth": {
                this.playSound(SoundRegistry.Entity.Chester.CLOSE_MOUTH, 0.5f, 1.0f);
                break;
            }
        }
    }

    private void playSound(SoundEvent sound, float volume, float pitch) {
        Minecraft.func_71410_x().field_71441_e.func_184156_a(new BlockPos(((ChesterEntity)this.animatable).field_70165_t, ((ChesterEntity)this.animatable).field_70163_u, ((ChesterEntity)this.animatable).field_70161_v), sound, SoundCategory.NEUTRAL, volume, pitch, false);
    }

    private static class Controller {
        private static final String IDLE = "idle_controller";
        private static final String JUMP = "jump_controller";
        private static final String OPEN = "open_controller";

        private Controller() {
        }
    }

    private static class Animation {
        private static final String IDLE = "animation.chester.idle";
        private static final String INIT_JUMP = "animation.chester.init_jump";
        private static final String JUMP = "animation.chester.jump";
        private static final String STOP_JUMP = "animation.chester.stop_jump";
        private static final String OPEN_MOUTH = "animation.chester.open_mouth";
        private static final String IDLE_MOUTH = "animation.chester.idle_mouth";
        private static final String CLOSE_MOUTH = "animation.chester.close_mouth";

        private Animation() {
        }
    }
}

