/*
 * Decompiled with CFR 0.152.
 */
package com.syllient.livingchest.entity;

import com.syllient.livingchest.LivingChest;
import com.syllient.livingchest.animation.entity.ChesterAnimation;
import com.syllient.livingchest.entity.ai.ChesterSitAi;
import com.syllient.livingchest.eventhandler.registry.BlockRegistry;
import com.syllient.livingchest.eventhandler.registry.ItemRegistry;
import com.syllient.livingchest.eventhandler.registry.SoundRegistry;
import com.syllient.livingchest.inventory.ChesterInventory;
import com.syllient.livingchest.saveddata.VirtualChesterSavedData;
import com.syllient.livingchest.util.InventoryUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.items.IItemHandler;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ChesterEntity
extends EntityTameable
implements IAnimatable,
IEntityAdditionalSpawnData {
    private static final DataParameter<Boolean> IS_MOUTH_OPEN = EntityDataManager.func_187226_a(ChesterEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private final ChesterInventory inventory = new ChesterInventory(this, 27);
    private final ChesterAnimation animation = new ChesterAnimation(this);
    private BlockPos eyeBone;

    public ChesterEntity(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.85f);
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 1, false, false));
        this.field_70765_h = new MoveHelper(this);
        this.field_70158_ak = true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_MOUTH_OPEN, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70911_d = new ChesterSitAi(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(450.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.37);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound tagCompoundIn) {
        VirtualChesterSavedData.getInstance(this.field_70170_p).onChesterWriteToNbt(this);
        if (this.inventory != null) {
            tagCompoundIn.func_74782_a("Inventory", (NBTBase)this.inventory.serializeNBT());
        }
        if (this.eyeBone != null) {
            tagCompoundIn.func_74782_a("EyeBone", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.eyeBone));
        }
        return super.func_189511_e(tagCompoundIn);
    }

    public void func_70020_e(NBTTagCompound tagCompoundIn) {
        if (tagCompoundIn.func_74764_b("Inventory")) {
            this.inventory.deserializeNBT(tagCompoundIn.func_74775_l("Inventory"));
        }
        if (tagCompoundIn.func_74764_b("EyeBone")) {
            this.eyeBone = NBTUtil.func_186861_c((NBTTagCompound)tagCompoundIn.func_74775_l("EyeBone"));
        }
        super.func_70020_e(tagCompoundIn);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.field_70177_z);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.setYawRotation(buffer.readFloat());
        this.setPrevYawRotation(this.field_70177_z);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.onServerUpdate();
        } else {
            this.onClientUpdate();
        }
    }

    public void onServerUpdate() {
        this.checkEyeBone();
    }

    public void onClientUpdate() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkEyeBone() {
        if (this.eyeBone == null) {
            this.func_70904_g(false);
            if (!this.func_70909_n()) return;
            if (this.field_70173_aa % 60 != 0) return;
            EntityPlayer owner = (EntityPlayer)this.func_70902_q();
            if (owner != null) {
                if (owner.field_71069_bz.field_75153_a.stream().map(ItemStack::func_77973_b).anyMatch(ItemRegistry.EYE_BONE::equals)) return;
            }
            boolean bl = true;
            boolean shouldDespawn = bl;
            if (!shouldDespawn) return;
            VirtualChesterSavedData.getInstance(this.field_70170_p).despawnChester(this.func_184753_b(), this.field_70170_p);
            return;
        } else {
            this.func_70904_g(true);
            boolean isEyeBoneBlock = this.field_70170_p.func_180495_p(this.eyeBone).func_177230_c().equals(BlockRegistry.EYE_BONE);
            if (isEyeBoneBlock) return;
            this.eyeBone = null;
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            VirtualChesterSavedData.getInstance(this.field_70170_p).onChesterDie(this);
            InventoryUtil.dropInventoryItems(this.field_70170_p, (Entity)this, (IItemHandler)this.inventory);
        }
        super.func_70645_a(cause);
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            VirtualChesterSavedData.getInstance(this.field_70170_p).onChesterSetDead(this);
        }
        super.func_70106_y();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (hand == EnumHand.MAIN_HAND) {
            this.openGuiTo(player);
            return true;
        }
        return false;
    }

    public boolean isMouthOpen() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_MOUTH_OPEN);
    }

    private void setIsMouthOpen(boolean value) {
        this.field_70180_af.func_187227_b(IS_MOUTH_OPEN, (Object)value);
    }

    public void openMouth() {
        this.setIsMouthOpen(true);
    }

    public void closeMouth() {
        this.setIsMouthOpen(false);
    }

    public void openGuiTo(EntityPlayer player) {
        player.openGui((Object)LivingChest.INSTANCE, 0, this.field_70170_p, this.func_145782_y(), 0, 0);
    }

    public BlockPos getEyeBone() {
        return this.eyeBone;
    }

    public void setEyeBone(BlockPos pos) {
        this.eyeBone = pos;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.Entity.Chester.DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundRegistry.Entity.Chester.HURT;
    }

    public void func_70642_aH() {
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public void setYawRotation(float yaw) {
        this.field_70177_z = yaw;
        this.field_70759_as = yaw;
        this.field_70761_aq = yaw;
    }

    public void setPrevYawRotation(float yaw) {
        this.field_70126_B = yaw;
        this.field_70758_at = yaw;
        this.field_70760_ar = yaw;
    }

    public int getDeathCooldown() {
        int minutes = 10;
        return 12000;
    }

    protected float func_175134_bD() {
        return 0.5f;
    }

    public ChesterInventory getInventory() {
        return this.inventory;
    }

    public AnimationFactory getFactory() {
        return this.animation.getFactory();
    }

    public void registerControllers(AnimationData data) {
        this.animation.registerControllers(data);
    }

    private static class MoveHelper
    extends EntityMoveHelper {
        private final ChesterEntity chester;

        public MoveHelper(ChesterEntity chester) {
            super((EntityLiving)chester);
            this.chester = chester;
        }

        public void func_75641_c() {
            if (this.chester.isMouthOpen()) {
                this.chester.func_191989_p(0.0f);
                return;
            }
            super.func_75641_c();
        }

        protected float func_75639_a(float sourceAngle, float targetAngle, float maximumChange) {
            return super.func_75639_a(sourceAngle, targetAngle, 30.0f);
        }
    }

    class TagKey {
        public static final String INVENTORY = "Inventory";
        public static final String EYE_BONE = "EyeBone";

        TagKey() {
        }
    }
}

