/*
 * Decompiled with CFR 0.152.
 */
package com.syllient.livingchest.saveddata;

import com.syllient.livingchest.PacketHandler;
import com.syllient.livingchest.entity.ChesterEntity;
import com.syllient.livingchest.network.message.SyncVirtualChesterMessage;
import com.syllient.livingchest.util.Position;
import com.syllient.livingchest.util.WorldUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class VirtualChesterSavedData
extends WorldSavedData {
    private static final String DATA_NAME = "livingchest_virtualchester";
    private static final int TICKS_REDUCE_DEAD_TIME_STEP = 600;
    private final Map<UUID, VirtualChester> virtualChesterFromPlayerId = new HashMap<UUID, VirtualChester>();
    private int ticks = 0;

    public VirtualChesterSavedData() {
        super(DATA_NAME);
    }

    public VirtualChesterSavedData(String name) {
        super(name);
    }

    public void onServerTick() {
        ++this.ticks;
        if (this.ticks % 600 == 0) {
            this.reduceDeadTime();
        }
    }

    private void reduceDeadTime() {
        boolean wasResurrected = this.virtualChesterFromPlayerId.values().stream().reduce(false, (wasResurrectedIn, virtualChester) -> {
            if (virtualChester.getDeadTime() > 0) {
                ((VirtualChester)virtualChester).setDeadTime(virtualChester.getDeadTime() - 600);
                if (virtualChester.getDeadTime() <= 0) {
                    return true;
                }
            }
            return wasResurrectedIn;
        }, Boolean::logicalOr);
        if (wasResurrected) {
            this.onChesterResurrect();
        }
    }

    public void toggleChester(EntityPlayer player, World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        if (this.getVirtualChester(player.func_110124_au()).isSpawned()) {
            this.despawnChester(player.func_110124_au(), world);
        } else {
            this.spawnChester(player, world, pos);
        }
    }

    public void spawnChester(EntityPlayer player, World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        VirtualChester virtualChester = this.getVirtualChester(player.func_110124_au());
        if (virtualChester.isSpawned()) {
            return;
        }
        if (virtualChester.isDead()) {
            int minutes = (int)Math.ceil((float)virtualChester.getDeadTime() / 20.0f / 60.0f);
            player.func_145747_a((ITextComponent)new TextComponentString("Ooh, looks like your Chester is dead. You still need to wait " + TextFormatting.RED + minutes + " minute" + (minutes > 1 ? "s " : " ") + TextFormatting.WHITE + "before you can summon him again."));
            return;
        }
        if (!world.func_175623_d(pos.func_177984_a())) {
            return;
        }
        ChesterEntity chesterEntity = new ChesterEntity(world);
        chesterEntity.func_193101_c(player);
        chesterEntity.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
        chesterEntity.setYawRotation(player.field_70177_z - 180.0f);
        chesterEntity.setPrevYawRotation(chesterEntity.field_70177_z);
        if (virtualChester.getInventory() != null) {
            chesterEntity.getInventory().deserializeNBT(virtualChester.getInventory());
            virtualChester.setInventory(null);
        }
        if (virtualChester.getHealth() > 0.0f) {
            chesterEntity.func_70606_j(virtualChester.getHealth());
            virtualChester.setHealth(0.0f);
        }
        virtualChester.setIsSpawned(chesterEntity.func_110124_au());
        world.func_72838_d((Entity)chesterEntity);
    }

    public void despawnChester(UUID playerId, World world) {
        if (world.field_72995_K) {
            return;
        }
        VirtualChester virtualChester = this.getVirtualChester(playerId);
        if (!virtualChester.isSpawned()) {
            return;
        }
        ChesterEntity chesterEntity = (ChesterEntity)WorldUtil.getEntityByUuid(world, virtualChester.getUniqueId());
        if (chesterEntity != null) {
            virtualChester.setInventory(chesterEntity.getInventory().serializeNBT());
            virtualChester.setHealth(chesterEntity.func_110143_aJ());
            virtualChester.setIsDespawned();
            chesterEntity.func_70106_y();
            return;
        }
        EntityPlayer player = world.func_152378_a(playerId);
        if (player != null) {
            player.func_145747_a((ITextComponent)new TextComponentString("You need to get closer to your Chester. Last know position:"));
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + virtualChester.getPosition().toString()));
        }
    }

    public void onPlaceEyeBone(EntityPlayer player, BlockPos pos) {
        VirtualChester virtualChester = this.getVirtualChester(player.func_110124_au());
        if (!virtualChester.isSpawned()) {
            return;
        }
        ChesterEntity chesterEntity = (ChesterEntity)WorldUtil.getEntityByUuid(player.field_70170_p, virtualChester.getUniqueId());
        if (chesterEntity == null) {
            return;
        }
        chesterEntity.setEyeBone(pos);
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "A new Eye Bone position has been set for your Chester."));
    }

    private void onChesterResurrect() {
        PacketHandler.INSTANCE.sendToAll((IMessage)new SyncVirtualChesterMessage());
    }

    public void onChesterDie(ChesterEntity chester) {
        if (chester.func_184753_b() == null) {
            return;
        }
        VirtualChester virtualChester = this.getVirtualChester(chester.func_184753_b());
        virtualChester.setIsDespawned();
        virtualChester.setDeadTime(chester.getDeathCooldown());
        PacketHandler.INSTANCE.sendToAll((IMessage)new SyncVirtualChesterMessage());
    }

    public void onChesterSetDead(ChesterEntity chester) {
        if (chester.func_184753_b() == null) {
            return;
        }
        this.getVirtualChester(chester.func_184753_b()).setIsDespawned();
    }

    public void onChesterWriteToNbt(ChesterEntity chester) {
        if (chester.func_184753_b() == null) {
            return;
        }
        this.getVirtualChester(chester.func_184753_b()).setPosition(chester);
    }

    public VirtualChester getVirtualChester(UUID playerId) {
        return this.virtualChesterFromPlayerId.computeIfAbsent(playerId, key -> new VirtualChester());
    }

    public static VirtualChesterSavedData getInstance(World world) {
        MapStorage worldStorage = world.func_175693_T();
        return (VirtualChesterSavedData)Optional.ofNullable(worldStorage.func_75742_a(VirtualChesterSavedData.class, DATA_NAME)).orElseGet(() -> {
            VirtualChesterSavedData instance = new VirtualChesterSavedData();
            worldStorage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
            return instance;
        });
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tagCompoundIn) {
        NBTTagList tagList = new NBTTagList();
        this.virtualChesterFromPlayerId.forEach((playerId, virtualChester) -> {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_186854_a("PlayerId", playerId);
            tagCompound.func_74782_a("VirtualChester", (NBTBase)virtualChester.serializeNBT());
            tagList.func_74742_a((NBTBase)tagCompound);
        });
        tagCompoundIn.func_74782_a("VirtualChesterTagList", (NBTBase)tagList);
        return tagCompoundIn;
    }

    public void func_76184_a(NBTTagCompound tagCompoundIn) {
        tagCompoundIn.func_150295_c("VirtualChesterTagList", 10).forEach(tag -> {
            NBTTagCompound tagCompound = (NBTTagCompound)tag;
            this.virtualChesterFromPlayerId.put(tagCompound.func_186857_a("PlayerId"), new VirtualChester(tagCompound.func_74775_l("VirtualChester")));
        });
    }

    public class VirtualChester
    implements INBTSerializable<NBTTagCompound> {
        private NBTTagCompound inventory = null;
        private int deadTime = 0;
        private float health = 0.0f;
        private UUID uniqueId = null;
        private Position position = null;

        public VirtualChester() {
        }

        public VirtualChester(NBTTagCompound tagCompoundIn) {
            this.deserializeNBT(tagCompoundIn);
        }

        public boolean isDead() {
            return this.deadTime > 0;
        }

        public boolean isSpawned() {
            return this.uniqueId != null;
        }

        private void setIsSpawned(UUID uuid) {
            this.setUniqueId(uuid);
        }

        private void setIsDespawned() {
            this.setUniqueId(null);
        }

        public NBTTagCompound getInventory() {
            return this.inventory;
        }

        private void setInventory(NBTTagCompound inventory) {
            this.inventory = inventory;
            VirtualChesterSavedData.this.func_76185_a();
        }

        public int getDeadTime() {
            return this.deadTime;
        }

        private void setDeadTime(int deadTime) {
            this.deadTime = deadTime;
            VirtualChesterSavedData.this.func_76185_a();
        }

        public float getHealth() {
            return this.health;
        }

        private void setHealth(float health) {
            this.health = health;
            VirtualChesterSavedData.this.func_76185_a();
        }

        public UUID getUniqueId() {
            return this.uniqueId;
        }

        private void setUniqueId(UUID uniqueId) {
            this.uniqueId = uniqueId;
            VirtualChesterSavedData.this.func_76185_a();
        }

        public Position getPosition() {
            return this.position;
        }

        private void setPosition(ChesterEntity chester) {
            this.setPosition(chester.field_70165_t, chester.field_70163_u, chester.field_70161_v, chester.field_71093_bK);
        }

        private void setPosition(double posX, double posY, double posZ, int dim) {
            if (this.position == null) {
                this.position = new Position(posX, posY, posZ, dim);
            } else {
                this.position.setPosition(posX, posY, posZ, dim);
            }
            VirtualChesterSavedData.this.func_76185_a();
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tagCompound = new NBTTagCompound();
            if (this.inventory != null) {
                tagCompound.func_74782_a("Inventory", (NBTBase)this.inventory);
            }
            if (this.deadTime > 0) {
                tagCompound.func_74768_a("DeadTime", this.deadTime);
            }
            if (this.health > 0.0f) {
                tagCompound.func_74776_a("Health", this.health);
            }
            if (this.uniqueId != null) {
                tagCompound.func_186854_a("UniqueId", this.uniqueId);
            }
            if (this.position != null) {
                tagCompound.func_74782_a("Position", (NBTBase)this.position.serializeNBT());
            }
            return tagCompound;
        }

        public void deserializeNBT(NBTTagCompound tagCompoundIn) {
            if (tagCompoundIn.func_74764_b("Inventory")) {
                this.inventory = tagCompoundIn.func_74775_l("Inventory");
            }
            if (tagCompoundIn.func_74764_b("DeadTime")) {
                this.deadTime = tagCompoundIn.func_74762_e("DeadTime");
            }
            if (tagCompoundIn.func_74764_b("Health")) {
                this.health = tagCompoundIn.func_74760_g("Health");
            }
            if (tagCompoundIn.func_186855_b("UniqueId")) {
                this.uniqueId = tagCompoundIn.func_186857_a("UniqueId");
            }
            if (tagCompoundIn.func_74764_b("Position")) {
                this.position = new Position(tagCompoundIn.func_74775_l("Position"));
            }
        }

        class TagKey {
            public static final String INVENTORY = "Inventory";
            public static final String DEAD_TIME = "DeadTime";
            public static final String HEALTH = "Health";
            public static final String UNIQUE_ID = "UniqueId";
            public static final String POSITION = "Position";

            TagKey() {
            }
        }
    }

    class TagKey {
        public static final String VIRTUAL_CHESTER_TAG_LIST = "VirtualChesterTagList";
        public static final String PLAYER_ID = "PlayerId";
        public static final String VIRTUAL_CHESTER = "VirtualChester";

        TagKey() {
        }
    }
}

