/*
 * Decompiled with CFR 0.152.
 */
package com.syllient.livingchest.animation.entity;

import com.syllient.livingchest.entity.ChesterEntity;
import com.syllient.livingchest.eventhandler.registry.SoundRegistry;
import com.syllient.livingchest.geckolib.ExtendedAnimationController;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class ChesterAnimation
extends com.syllient.livingchest.animation.Animation<ChesterEntity> {
    private final ExtendedAnimationController<ChesterEntity> idleController;
    private final ExtendedAnimationController<ChesterEntity> jumpController;
    private final ExtendedAnimationController<ChesterEntity> openController;
    private int idleSoundTimes = 0;
    private int ticksIdling = 0;
    private boolean wasMouthOpen = false;

    public ChesterAnimation(ChesterEntity chester) {
        super(chester);
        this.idleController = new ExtendedAnimationController<ChesterEntity>(chester, "idle_controller", 0.0f, this::handleIdleAnimation);
        this.jumpController = new ExtendedAnimationController<ChesterEntity>(chester, "jump_controller", 0.0f, this::handleJumpAnimation);
        this.openController = new ExtendedAnimationController<ChesterEntity>(chester, "open_controller", 0.0f, this::handleOpenAnimation);
    }

    @Override
    public void registerControllers(AnimationData data) {
        this.idleController.registerSoundListener(this::handleSoundKeyframes);
        this.jumpController.registerSoundListener(this::handleSoundKeyframes);
        this.openController.registerSoundListener(this::handleSoundKeyframes);
        data.addAnimationController(this.idleController);
        data.addAnimationController(this.jumpController);
        data.addAnimationController(this.openController);
    }

    private void handleAnimationTick() {
        boolean isIdling = this.jumpController.isAnimationStopped();
        this.ticksIdling = isIdling ? ++this.ticksIdling : 0;
        if (((ChesterEntity)this.animatable).isMouthOpen() && !this.wasMouthOpen || this.ticksIdling < 5) {
            this.idleSoundTimes = 0;
        }
        this.wasMouthOpen = ((ChesterEntity)this.animatable).isMouthOpen();
    }

    private PlayState handleIdleAnimation(AnimationEvent<? extends IAnimatable> event) {
        this.handleAnimationTick();
        if (this.ticksIdling < 5) {
            return PlayState.STOP;
        }
        this.idleController.setAnimationSpeed(1.1);
        this.idleController.setAnimation(new AnimationBuilder().addAnimation("animation.chester.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private PlayState handleJumpAnimation(AnimationEvent<? extends IAnimatable> event) {
        if (this.jumpController.isAnimationStopped("animation.chester.init_jump")) {
            this.jumpController.setAnimation(new AnimationBuilder().addAnimation("animation.chester.jump"));
            return PlayState.CONTINUE;
        }
        boolean isJumping = this.jumpController.isCurrentAnimation("animation.chester.jump");
        if (((ChesterEntity)this.animatable).isMoving() && ((ChesterEntity)this.animatable).func_233570_aj_() && this.openController.isAnimationStopped()) {
            if (!isJumping) {
                this.jumpController.setAnimation(new AnimationBuilder().addAnimation("animation.chester.init_jump"));
            }
            return PlayState.CONTINUE;
        }
        if (isJumping && this.jumpController.hasJustFinishedAnimation()) {
            this.jumpController.setAnimation(new AnimationBuilder().addAnimation("animation.chester.stop_jump"));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    private PlayState handleOpenAnimation(AnimationEvent<? extends IAnimatable> event) {
        if (this.ticksIdling < 5) {
            return PlayState.STOP;
        }
        if (((ChesterEntity)this.animatable).isMouthOpen()) {
            this.openController.setAnimation(new AnimationBuilder().addAnimation("animation.chester.open_mouth").addAnimation("animation.chester.idle_mouth"));
            return PlayState.CONTINUE;
        }
        if (this.openController.isCurrentAnimation("animation.chester.idle_mouth")) {
            this.openController.setAnimation(new AnimationBuilder().addAnimation("animation.chester.close_mouth"));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    private void handleSoundKeyframes(SoundKeyframeEvent<? extends IAnimatable> event) {
        switch (event.sound) {
            case "idle": {
                ++this.idleSoundTimes;
                this.playSound(SoundRegistry.Entity.Chester.IDLE, Math.max(0.025f, 0.1f - (float)this.idleSoundTimes * 0.005f), 1.0f);
                break;
            }
            case "jump": {
                this.playSound(SoundRegistry.Entity.Chester.JUMP, 0.15f, 1.0f);
                break;
            }
            case "open_mouth": {
                this.playSound(SoundRegistry.Entity.Chester.OPEN_MOUTH, 0.5f, 1.0f);
                break;
            }
            case "close_mouth": {
                this.playSound(SoundRegistry.Entity.Chester.CLOSE_MOUTH, 0.5f, 1.0f);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void playSound(SoundEvent sound, float volume, float pitch) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71441_e.func_184156_a(new BlockPos(((ChesterEntity)this.animatable).func_213303_ch()), sound, SoundCategory.NEUTRAL, volume, pitch, false);
    }

    private static class Controller {
        private static final String IDLE = "idle_controller";
        private static final String JUMP = "jump_controller";
        private static final String OPEN = "open_controller";

        private Controller() {
        }
    }

    private static class Animation {
        private static final String IDLE = "animation.chester.idle";
        private static final String INIT_JUMP = "animation.chester.init_jump";
        private static final String JUMP = "animation.chester.jump";
        private static final String STOP_JUMP = "animation.chester.stop_jump";
        private static final String OPEN_MOUTH = "animation.chester.open_mouth";
        private static final String IDLE_MOUTH = "animation.chester.idle_mouth";
        private static final String CLOSE_MOUTH = "animation.chester.close_mouth";

        private Animation() {
        }
    }
}

