/*
 * Decompiled with CFR 0.152.
 */
package com.syllient.livingchest.block;

import com.syllient.livingchest.saveddata.VirtualChesterSavedData;
import com.syllient.livingchest.tile.EyeBoneTile;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EyeBoneBlock
extends HorizontalBlock {
    public EyeBoneBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof EyeBoneTile && placer instanceof PlayerEntity) {
            if (!world.field_72995_K) {
                VirtualChesterSavedData.getServerInstance(world).handleEyeBonePlacement((PlayerEntity)placer, pos);
            }
            ((EyeBoneTile)tileEntity).setOwnerId(placer.func_110124_au());
        }
    }

    public void func_190948_a(ItemStack stack, IBlockReader reader, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "To spawn/despawn your Chester, use the Eye Bone on a block while sneaking."));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)ctx.func_195992_f().func_176734_d());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EyeBoneTile();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext ctx) {
        Direction facing = (Direction)state.func_177229_b((Property)field_185512_D);
        return facing == Direction.WEST || facing == Direction.EAST ? Shape.FULL_WE : Shape.FULL_NS;
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    private static class Shape {
        private static final VoxelShape EYE = VoxelShapes.func_197873_a((double)0.3425, (double)0.5375, (double)0.3425, (double)0.6575, (double)0.85, (double)0.6575);
        private static final VoxelShape GRIP = VoxelShapes.func_197873_a((double)0.455, (double)0.09125, (double)0.455, (double)0.545, (double)0.545, (double)0.545);
        private static final VoxelShape BASE_NS = VoxelShapes.func_197873_a((double)0.3875, (double)0.0, (double)0.455, (double)0.6125, (double)0.09125, (double)0.545);
        private static final VoxelShape BASE_WE = VoxelShapes.func_197873_a((double)0.455, (double)0.0, (double)0.3875, (double)0.545, (double)0.09125, (double)0.6125);
        private static final VoxelShape FULL_NS = VoxelShapes.func_216384_a((VoxelShape)EYE, (VoxelShape[])new VoxelShape[]{GRIP, BASE_NS});
        private static final VoxelShape FULL_WE = VoxelShapes.func_216384_a((VoxelShape)EYE, (VoxelShape[])new VoxelShape[]{GRIP, BASE_WE});

        private Shape() {
        }
    }
}

