/*
 * Decompiled with CFR 0.152.
 */
package com.syllient.livingchest.entity;

import com.syllient.livingchest.animation.entity.ChesterAnimation;
import com.syllient.livingchest.container.ChesterContainer;
import com.syllient.livingchest.entity.ai.ChesterSitAi;
import com.syllient.livingchest.entity.ai.helper.ChesterMoveHelper;
import com.syllient.livingchest.entity.ai.pathfinding.FixedGroundPathNavigator;
import com.syllient.livingchest.eventhandler.registry.BlockRegistry;
import com.syllient.livingchest.eventhandler.registry.ItemRegistry;
import com.syllient.livingchest.eventhandler.registry.SoundRegistry;
import com.syllient.livingchest.inventory.ChesterInventory;
import com.syllient.livingchest.saveddata.VirtualChesterSavedData;
import com.syllient.livingchest.util.InventoryUtil;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ChesterEntity
extends TameableEntity
implements IAnimatable,
IEntityAdditionalSpawnData,
INamedContainerProvider {
    private static final DataParameter<Boolean> IS_MOUTH_OPEN = EntityDataManager.func_187226_a(ChesterEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_MOVING = EntityDataManager.func_187226_a(ChesterEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final ChesterInventory inventory = new ChesterInventory(this, 27);
    private final ChesterAnimation animation = new ChesterAnimation(this);
    private BlockPos eyeBone;

    public ChesterEntity(EntityType<? extends ChesterEntity> type, World world) {
        super(type, world);
        this.func_195064_c(new EffectInstance(Effects.field_76428_l, Integer.MAX_VALUE, 1, false, false));
        this.field_70765_h = new ChesterMoveHelper(this);
        this.field_70158_ak = true;
    }

    protected PathNavigator func_175447_b(World world) {
        return new FixedGroundPathNavigator((MobEntity)this, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_MOUTH_OPEN, (Object)false);
        this.field_70180_af.func_187214_a(IS_MOVING, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new ChesterSitAi(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
    }

    public void func_213281_b(CompoundNBT compoundIn) {
        VirtualChesterSavedData.getServerInstance(this.field_70170_p).handleChesterDataSave(this);
        if (this.inventory != null) {
            compoundIn.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        }
        if (this.eyeBone != null) {
            compoundIn.func_218657_a("EyeBone", (INBT)NBTUtil.func_186859_a((BlockPos)this.eyeBone));
        }
        super.func_213281_b(compoundIn);
    }

    public void func_70037_a(CompoundNBT compoundIn) {
        if (compoundIn.func_74764_b("Inventory")) {
            this.inventory.deserializeNBT(compoundIn.func_74775_l("Inventory"));
        }
        if (compoundIn.func_74764_b("EyeBone")) {
            this.eyeBone = NBTUtil.func_186861_c((CompoundNBT)compoundIn.func_74775_l("EyeBone"));
        }
        super.func_70037_a(compoundIn);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeFloat(this.field_70177_z);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.setYawRotations(buffer.readFloat());
        this.setPrevYawRotations(this.field_70177_z);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.tickClient();
        } else {
            this.tickServer();
        }
    }

    private void tickClient() {
    }

    private void tickServer() {
        if (this.field_70173_aa % 40 == 0) {
            this.checkEyeBone();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkEyeBone() {
        if (this.eyeBone == null) {
            this.func_233686_v_(false);
            if (!this.func_70909_n()) return;
            PlayerEntity owner = (PlayerEntity)this.func_70902_q();
            if (owner != null) {
                if (owner.field_71070_bA.func_75138_a().stream().map(ItemStack::func_77973_b).anyMatch(ItemRegistry.EYE_BONE::equals)) return;
            }
            boolean bl = true;
            boolean shouldDespawn = bl;
            if (!shouldDespawn) return;
            VirtualChesterSavedData.getServerInstance(this.field_70170_p).despawnChester(this);
            return;
        } else {
            this.func_233686_v_(true);
            boolean isEyeBoneBlock = this.field_70170_p.func_180495_p(this.eyeBone).func_177230_c().equals(BlockRegistry.EYE_BONE);
            if (isEyeBoneBlock) return;
            this.eyeBone = null;
        }
    }

    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K) {
            VirtualChesterSavedData.getServerInstance(this.field_70170_p).handleChesterDeath(this);
            InventoryUtil.dropItems(this.field_70170_p, (Entity)this, (IItemHandler)this.inventory);
        }
        super.func_70645_a(source);
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vector, Hand hand) {
        if (this.field_70170_p.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (hand == Hand.MAIN_HAND) {
            this.openGuiTo(player);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean isMouthOpen() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_MOUTH_OPEN);
    }

    private void setIsMouthOpen(boolean value) {
        this.field_70180_af.func_187227_b(IS_MOUTH_OPEN, (Object)value);
    }

    public boolean isMoving() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_MOVING);
    }

    public void setIsMoving(boolean value) {
        this.field_70180_af.func_187227_b(IS_MOVING, (Object)value);
    }

    public void openMouth() {
        this.setIsMouthOpen(true);
    }

    public void closeMouth() {
        this.setIsMouthOpen(false);
    }

    public void openGuiTo(PlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buf -> buf.writeInt(this.func_145782_y()));
    }

    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return new ChesterContainer(windowId, player, this);
    }

    public BlockPos getEyeBone() {
        return this.eyeBone;
    }

    public void setEyeBone(BlockPos pos) {
        this.eyeBone = pos;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.Entity.Chester.DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.Entity.Chester.HURT;
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity entity) {
        return null;
    }

    public void setYawRotations(float yaw) {
        this.field_70177_z = yaw;
        this.field_70759_as = yaw;
        this.field_70761_aq = yaw;
    }

    public void setPrevYawRotations(float yaw) {
        this.field_70126_B = yaw;
        this.field_70758_at = yaw;
        this.field_70760_ar = yaw;
    }

    public int getDeathCooldown() {
        int minutes = 10;
        return 12000;
    }

    protected float func_175134_bD() {
        return 0.5f;
    }

    public ChesterInventory getInventory() {
        return this.inventory;
    }

    public AnimationFactory getFactory() {
        return this.animation.getFactory();
    }

    public void registerControllers(AnimationData data) {
        this.animation.registerControllers(data);
    }

    class NbtKey {
        public static final String INVENTORY = "Inventory";
        public static final String EYE_BONE = "EyeBone";

        NbtKey() {
        }
    }
}

